/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.worker.util;

import com.alibaba.schedulerx.common.domain.JSONResult;
import com.alibaba.schedulerx.common.util.ConfigUtil;
import com.alibaba.schedulerx.common.util.JsonUtil;
import com.alibaba.schedulerx.shade.com.google.common.collect.Lists;
import com.alibaba.schedulerx.shade.com.mashape.unirest.http.HttpResponse;
import com.alibaba.schedulerx.shade.com.mashape.unirest.http.JsonNode;
import com.alibaba.schedulerx.shade.com.mashape.unirest.http.Unirest;
import com.alibaba.schedulerx.shade.org.apache.commons.collections.CollectionUtils;
import com.alibaba.schedulerx.shade.org.apache.commons.lang.StringUtils;
import com.alibaba.schedulerx.shade.org.apache.commons.lang.math.NumberUtils;
import com.alibaba.schedulerx.worker.log.LogFactory;
import com.alibaba.schedulerx.worker.log.Logger;
import java.io.BufferedReader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;

public class ConsoleUtil {
    private static final Logger LOGGER = LogFactory.getLogger(ConsoleUtil.class);
    private static final String APP_GROUP_URL = "/worker/v1/appgroup/getId";
    private static final String AUTHENTICATE_URL = "/worker/v1/appgroup/authenticate";
    private static final String CONSOLE_LIST_URL = "/worker/v1/meta/consolelist";

    public static long getAppGroupId(String groupId, String namespace, String namespaceSource) {
        long appGroupId = 0L;
        HashMap<String, String> parameterMap = new HashMap<String, String>();
        parameterMap.put("groupId", groupId);
        String domain = ConfigUtil.getWorkerConfig().getString("domainName");
        if (StringUtils.isNotBlank(domain)) {
            String url;
            if (namespace != null) {
                url = "http://" + domain + APP_GROUP_URL + "?groupId=" + groupId + "&namespace=" + namespace;
                if (StringUtils.isNotBlank(namespaceSource)) {
                    url = url + "&namespaceSource=" + namespaceSource;
                }
            } else {
                url = "http://" + domain + APP_GROUP_URL + "?groupId=" + groupId;
            }
            try {
                JSONResult jsonResult;
                HttpResponse<JsonNode> jsonResponse = Unirest.get(url).asJson();
                if (jsonResponse != null && (jsonResult = JsonUtil.fromJson(jsonResponse.getBody().toString(), JSONResult.class)) != null) {
                    appGroupId = NumberUtils.toLong((String)jsonResult.getData(), 0L);
                }
            }
            catch (Throwable e) {
                LOGGER.error("getAppGroupId error, url={}", url, e);
            }
        }
        return appGroupId;
    }

    public static List<String> getVipServerList(String addressServerDomain, String port) {
        ArrayList<String> serverList = Lists.newArrayList();
        String url = null;
        try {
            url = String.format("http://%s:%s/schedulerx2/consolelist", addressServerDomain, port);
            HttpResponse<String> response = Unirest.get(url).asString();
            if (response != null && response.getStatus() == 200) {
                String line;
                BufferedReader reader = new BufferedReader(new StringReader(response.getBody()));
                while ((line = reader.readLine()) != null) {
                    if (!StringUtils.isNotBlank(line)) continue;
                    serverList.add(StringUtils.trim(line));
                }
            }
            return serverList;
        }
        catch (Exception ex) {
            LOGGER.warn("Fetch domainName from address server error, url={}.", url);
            return serverList;
        }
    }

    private static String getAddressServerPort() {
        String addressPort = System.getProperty("address.server.port");
        if (StringUtils.isBlank(addressPort)) {
            addressPort = (String)ConfigUtil.getWorkerConfig().getProperty("address.server.port");
        }
        if (StringUtils.isBlank(addressPort)) {
            addressPort = System.getenv("address.server.port".replace(".", "_"));
        }
        if (StringUtils.isBlank(addressPort) || Integer.parseInt(addressPort) <= 0) {
            addressPort = "8080";
        }
        ConfigUtil.getWorkerConfig().setProperty("address.server.port", addressPort);
        return addressPort;
    }

    public static String getAddressServerDomain() {
        String domainName = ConfigUtil.getWorkerConfig().getString("address.server.domain");
        if (StringUtils.isBlank(domainName)) {
            domainName = System.getProperty("address.server.domain");
        }
        if (StringUtils.isBlank(domainName)) {
            domainName = System.getenv("address.server.domain".replace(".", "_"));
        }
        if (StringUtils.isNotBlank(domainName)) {
            ConfigUtil.getWorkerConfig().setProperty("address.server.domain", domainName);
        }
        return domainName;
    }

    public static String getDomainFromHttpServer() {
        String addressDomain = ConsoleUtil.getAddressServerDomain();
        if (StringUtils.isBlank(addressDomain)) {
            return "";
        }
        List<String> serverList = ConsoleUtil.getVipServerList(addressDomain, ConsoleUtil.getAddressServerPort());
        if (CollectionUtils.isNotEmpty(serverList)) {
            int index2 = 0;
            if (serverList.size() > 1) {
                Random random = new Random();
                index2 = random.nextInt(serverList.size());
            }
            return serverList.get(index2);
        }
        return "";
    }

    public static Map<String, Object> fetchMetaInfoFromConsole(String namespace, String namespaceSource, List<String> groupIds) throws Exception {
        String url = null;
        try {
            String domain = ConfigUtil.getWorkerConfig().getString("domainName");
            url = StringUtils.isBlank(namespaceSource) ? "http://" + domain + "/worker/v1/meta/get?namespace=" + namespace + "&groups=" + StringUtils.join(groupIds, ",") : "http://" + domain + "/worker/v1/meta/get?namespace=" + namespace + "&namespaceSource=" + namespaceSource + "&groups=" + StringUtils.join(groupIds, ",");
            url = url + "&encodeKey=true";
            HttpResponse<JsonNode> response = Unirest.get(url).asJson();
            if (response != null && response.getStatus() == 200) {
                JSONResult jsonResult = JsonUtil.fromJson(response.getBody().toString(), JSONResult.class);
                return (Map)jsonResult.getData();
            }
        }
        catch (Exception ex) {
            LOGGER.error("fetch metaInfo from console error, url={}", url, ex);
            throw ex;
        }
        return null;
    }

    public static String getRandomConsoleIp(String domain) {
        String console = null;
        String url = "http://" + domain + CONSOLE_LIST_URL;
        try {
            JSONResult jsonResult;
            List consoleList;
            HttpResponse<JsonNode> response = Unirest.get(url).asJson();
            if (response != null && response.getStatus() == 200 && CollectionUtils.isNotEmpty(consoleList = (List)(jsonResult = JsonUtil.fromJson(response.getBody().toString(), JSONResult.class)).getData())) {
                int index2 = new Random().nextInt(consoleList.size());
                console = (String)consoleList.get(index2);
            }
        }
        catch (Exception e) {
            LOGGER.error("get consolelist error, url={}", url, e);
        }
        return console;
    }
}

