/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.worker.timer;

import com.alibaba.schedulerx.common.domain.JobInstanceInfo;
import com.alibaba.schedulerx.common.util.ConfigUtil;
import com.alibaba.schedulerx.common.util.UnirestUtil;
import com.alibaba.schedulerx.shade.com.google.common.collect.Lists;
import com.alibaba.schedulerx.shade.com.google.common.collect.Maps;
import com.alibaba.schedulerx.shade.org.apache.commons.collections.CollectionUtils;
import com.alibaba.schedulerx.shade.org.apache.commons.collections.ListUtils;
import com.alibaba.schedulerx.shade.org.apache.commons.collections.MapUtils;
import com.alibaba.schedulerx.shade.org.apache.commons.lang.StringUtils;
import com.alibaba.schedulerx.worker.log.LogFactory;
import com.alibaba.schedulerx.worker.log.Logger;
import com.alibaba.schedulerx.worker.master.TaskMaster;
import com.alibaba.schedulerx.worker.master.TaskMasterPool;
import com.alibaba.schedulerx.worker.timer.AbstractTimerTask;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class TaskMasterUpdateWorkersTimer
extends AbstractTimerTask {
    private TaskMasterPool masterPool = TaskMasterPool.INSTANCE;
    protected static final Logger LOGGER = LogFactory.getLogger(TaskMasterUpdateWorkersTimer.class);

    @Override
    public String getName() {
        return "TaskMasterUpdateWorkersTimer";
    }

    @Override
    public long getInitialDelay() {
        return 60L;
    }

    @Override
    public long getPeriod() {
        return 60L;
    }

    @Override
    public void run() {
        try {
            Long appGroupId;
            Collection<TaskMaster> allTaskMaster = this.masterPool.getAllTaskMaster();
            if (CollectionUtils.isEmpty(allTaskMaster)) {
                return;
            }
            HashMap jobInstanceMap = Maps.newHashMap();
            HashMap appGroupJob = Maps.newHashMap();
            for (TaskMaster taskMaster : allTaskMaster) {
                Long jobId = taskMaster.getJobInstanceInfo().getJobId();
                ArrayList<JobInstanceInfo> list = (ArrayList<JobInstanceInfo>)jobInstanceMap.get(jobId);
                if (list == null) {
                    list = Lists.newArrayList();
                    jobInstanceMap.put(jobId, list);
                }
                list.add(taskMaster.getJobInstanceInfo());
                appGroupId = taskMaster.getJobInstanceInfo().getAppGroupId();
                ArrayList<Long> agList = (ArrayList<Long>)appGroupJob.get(appGroupId);
                if (agList == null) {
                    agList = Lists.newArrayList();
                    appGroupJob.put(appGroupId, agList);
                }
                agList.add(jobId);
            }
            HashMap hasNotDesignatedAppGroupJob = Maps.newHashMap();
            ArrayList<Long> hasDesignatedJobIds = Lists.newArrayList();
            for (Map.Entry entry : appGroupJob.entrySet()) {
                Set<Long> ids = this.grepHasDesignateJobIds((Long)entry.getKey(), (List)entry.getValue());
                if (CollectionUtils.isNotEmpty(ids)) {
                    HashSet idSet = new HashSet(ids.size());
                    for (Number number2 : ids) {
                        idSet.add(number2.longValue());
                    }
                    hasDesignatedJobIds.addAll(idSet);
                    hasNotDesignatedAppGroupJob.put(entry.getKey(), ListUtils.removeAll((Collection)entry.getValue(), idSet));
                    continue;
                }
                hasNotDesignatedAppGroupJob.put(entry.getKey(), (List<Object>)entry.getValue());
            }
            if (MapUtils.isNotEmpty(hasNotDesignatedAppGroupJob)) {
                for (Map.Entry entry : hasNotDesignatedAppGroupJob.entrySet()) {
                    Set<String> allWorkers = this.getAllWorkers((Long)entry.getKey(), -1L);
                    for (Long jobId : (List)entry.getValue()) {
                        this.updateWorkers(allWorkers, (List)jobInstanceMap.get(jobId));
                    }
                }
            }
            for (Long jobId : hasDesignatedJobIds) {
                appGroupId = ((JobInstanceInfo)((List)jobInstanceMap.get(jobId)).get(0)).getAppGroupId();
                Set<String> allWorkers = this.getAllWorkers(appGroupId, jobId);
                this.updateWorkers(allWorkers, (List)jobInstanceMap.get(jobId));
            }
        }
        catch (Exception ex) {
            LOGGER.error("update master workers error.", ex);
        }
    }

    private Set<Long> grepHasDesignateJobIds(Long appGroupId, List<Long> jobIds) throws Exception {
        String url = "http://{0}/app/grepHasDesignateJobIds.json?appGroupId={1}&jobIds={2}";
        return UnirestUtil.getSetData(url, ConfigUtil.getWorkerConfig().getString("domainName"), appGroupId, StringUtils.join(jobIds, ","));
    }

    private void updateWorkers(Set<String> allWorkers, List<JobInstanceInfo> instanceInfos) {
        if (CollectionUtils.isEmpty(allWorkers)) {
            return;
        }
        for (JobInstanceInfo instanceInfo : instanceInfos) {
            if (instanceInfo.getAllWorkers().size() == allWorkers.size() && instanceInfo.getAllWorkers().containsAll(allWorkers)) continue;
            instanceInfo.setAllWorkers(Lists.newCopyOnWriteArrayList(allWorkers));
            LOGGER.info("update appGroupId={} instanceId={} workers.", instanceInfo.getAppGroupId(), instanceInfo.getJobInstanceId());
        }
    }

    private Set<String> getAllWorkers(Long appGroupId, Long jobId) throws Exception {
        String url = "http://{0}/app/getAllUsefulWorkerList.json?appGroupId={1}&jobId={2}";
        try {
            return UnirestUtil.getSetData(url, ConfigUtil.getWorkerConfig().getString("domainName"), appGroupId, jobId);
        }
        catch (Exception ex) {
            LOGGER.error("getAllWorkers failed.", ex);
            return null;
        }
    }
}

