/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.worker.metrics;

import com.alibaba.schedulerx.common.util.ConfigUtil;
import com.alibaba.schedulerx.shade.com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.alibaba.schedulerx.worker.log.LogFactory;
import com.alibaba.schedulerx.worker.log.Logger;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class CgroupMetrics {
    private volatile long lastCpuTime;
    private volatile long lastTotalTime;
    private String cgroupPath;
    private ScheduledExecutorService ses = new ScheduledThreadPoolExecutor(1, new ThreadFactoryBuilder().setNameFormat("Schedulerx-CgroupMetrics-thread").build(), new ThreadPoolExecutor.DiscardPolicy());
    private static CgroupMetrics instance = new CgroupMetrics();
    private static final Logger LOGGER = LogFactory.getLogger(CgroupMetrics.class);

    private CgroupMetrics() {
        this.cgroupPath = ConfigUtil.getWorkerConfig().getString("cgroup.path.prefix", "/sys/fs/cgroup/cpu/");
        this.lastCpuTime = this.getCpuTime();
        this.lastTotalTime = System.nanoTime();
        this.ses.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                CgroupMetrics.this.getCpuUsagePercent();
            }
        }, 5L, 5L, TimeUnit.SECONDS);
    }

    public static CgroupMetrics getInstance() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getCpuTime() {
        InputStreamReader fr = null;
        BufferedReader br = null;
        long cpuTime = -1L;
        try {
            fr = new FileReader(this.cgroupPath + "cpuacct.usage");
            br = new BufferedReader(fr);
            String line = br.readLine();
            cpuTime = Long.parseLong(line);
        }
        catch (Exception e) {
            LOGGER.error("", e);
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException e) {
                    LOGGER.error("", e);
                }
            }
            if (fr != null) {
                try {
                    fr.close();
                }
                catch (IOException e) {
                    LOGGER.error("", e);
                }
            }
        }
        return cpuTime;
    }

    public double getCpuUsagePercent() {
        double usage = 0.0;
        long currentCpuTime = this.getCpuTime();
        long currentTotalTime = System.nanoTime();
        usage = (double)(currentCpuTime - this.lastCpuTime) / (double)(currentTotalTime - this.lastTotalTime);
        this.lastCpuTime = currentCpuTime;
        this.lastTotalTime = currentTotalTime;
        return usage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getCpuCores() {
        InputStreamReader fr1 = null;
        BufferedReader br1 = null;
        InputStreamReader fr2 = null;
        BufferedReader br2 = null;
        int cores = 0;
        try {
            fr1 = new FileReader(this.cgroupPath + "cpu.cfs_quota_us");
            br1 = new BufferedReader(fr1);
            long quota = Long.parseLong(br1.readLine());
            if (quota > 0L) {
                fr2 = new FileReader(this.cgroupPath + "cpu.cfs_period_us");
                br2 = new BufferedReader(fr2);
                long period = Long.parseLong(br2.readLine());
                cores = (int)(quota / period);
            } else {
                cores = Runtime.getRuntime().availableProcessors();
            }
        }
        catch (Exception e) {
            cores = Runtime.getRuntime().availableProcessors();
            LOGGER.error("", e);
        }
        finally {
            if (br1 != null) {
                try {
                    br1.close();
                }
                catch (IOException e) {
                    LOGGER.error("", e);
                }
            }
            if (fr1 != null) {
                try {
                    fr1.close();
                }
                catch (IOException e) {
                    LOGGER.error("", e);
                }
            }
            if (br2 != null) {
                try {
                    br2.close();
                }
                catch (IOException e) {
                    LOGGER.error("", e);
                }
            }
            if (fr2 != null) {
                try {
                    fr2.close();
                }
                catch (IOException e) {
                    LOGGER.error("", e);
                }
            }
        }
        return cores;
    }
}

