/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.worker.domain;

import com.alibaba.schedulerx.common.domain.JobInstanceData;
import com.alibaba.schedulerx.common.domain.TaskStatus;
import com.alibaba.schedulerx.common.util.ConfigUtil;
import com.alibaba.schedulerx.common.util.IdUtil;
import com.alibaba.schedulerx.worker.logcollector.LogCollector;
import com.alibaba.schedulerx.worker.logcollector.LogCollectorFactory;
import java.util.List;
import java.util.Map;
import org.joda.time.DateTime;

public final class JobContext {
    private long jobId;
    private long jobInstanceId;
    private Long wfInstanceId;
    private long taskId = 0L;
    private String jobName;
    private DateTime scheduleTime;
    private DateTime dataTime;
    private String executeMode;
    private String jobType;
    private String instanceMasterActorPath;
    private String taskName;
    private Object task;
    private String groupId;
    private String content;
    private String user;
    private int maxAttempt;
    private int attempt;
    private String jobParameters;
    private String instanceParameters;
    private List<JobInstanceData> upstreamData;
    private Map<Long, String> taskResults;
    private Map<Long, TaskStatus> taskStatuses;
    private int taskMaxAttempt;
    private int taskAttempt = 0;
    private int taskAttemptInterval;
    private long serialNum;
    private LogCollector logCollector;
    private Long shardingId;
    private String shardingParameter;
    private int shardingNum = 0;
    private List<String> allWorkerAddrs;
    private String workerAddr;

    private JobContext() {
    }

    public long getJobId() {
        return this.jobId;
    }

    public long getJobInstanceId() {
        return this.jobInstanceId;
    }

    public Long getWfInstanceId() {
        return this.wfInstanceId;
    }

    public long getTaskId() {
        return this.taskId;
    }

    public String getUniqueId() {
        return IdUtil.getUniqueId(this.jobId, this.jobInstanceId, this.taskId);
    }

    public String getJobName() {
        return this.jobName;
    }

    public DateTime getScheduleTime() {
        return this.scheduleTime;
    }

    public DateTime getDataTime() {
        return this.dataTime;
    }

    public String getExecuteMode() {
        return this.executeMode;
    }

    public String getJobType() {
        return this.jobType;
    }

    public String getContent() {
        return this.content;
    }

    public String getUser() {
        return this.user;
    }

    public String getJobParameters() {
        return this.jobParameters;
    }

    public String getInstanceParameters() {
        return this.instanceParameters;
    }

    public String getTaskMasterActorPath() {
        return this.getInstanceMasterActorPath();
    }

    public String getInstanceMasterActorPath() {
        return this.instanceMasterActorPath;
    }

    public String getTaskName() {
        return this.taskName;
    }

    public Object getTask() {
        return this.task;
    }

    public int getTaskMaxAttempt() {
        return this.taskMaxAttempt;
    }

    public int getTaskAttemptInterval() {
        return this.taskAttemptInterval;
    }

    private void collectLog(String log2) {
        this.logCollector.collect(this.getUniqueId(), log2);
    }

    public String getGroupId() {
        return this.groupId;
    }

    public List<JobInstanceData> getUpstreamData() {
        return this.upstreamData;
    }

    public Map<Long, String> getTaskResults() {
        return this.taskResults;
    }

    public Map<Long, TaskStatus> getTaskStatuses() {
        return this.taskStatuses;
    }

    public int getMaxAttempt() {
        return this.maxAttempt;
    }

    public int getAttempt() {
        return this.attempt;
    }

    public long getSerialNum() {
        return this.serialNum;
    }

    public int getTaskAttempt() {
        return this.taskAttempt;
    }

    public Long getShardingId() {
        return this.shardingId;
    }

    public String getShardingParameter() {
        return this.shardingParameter;
    }

    public void setTaskAttempt(int taskAttempt) {
        this.taskAttempt = taskAttempt;
    }

    public int getShardingNum() {
        return this.shardingNum;
    }

    public List<String> getAllWorkerAddrs() {
        return this.allWorkerAddrs;
    }

    public String getWorkerAddr() {
        return this.workerAddr;
    }

    public static JobContextBuilder newBuilder() {
        return new JobContextBuilder();
    }

    public static JobContextBuilder newBuilder(JobContext context) {
        return new JobContextBuilder(context);
    }

    public static final class JobContextBuilder {
        private JobContext context = new JobContext();

        private JobContextBuilder() {
        }

        private JobContextBuilder(JobContext context) {
            this.context = context;
        }

        public JobContextBuilder setJobId(long jobId) {
            this.context.jobId = jobId;
            return this;
        }

        public JobContextBuilder setJobInstanceId(long jobInstanceId) {
            this.context.jobInstanceId = jobInstanceId;
            return this;
        }

        public JobContextBuilder setWfInstanceId(long wfInstanceId) {
            this.context.wfInstanceId = wfInstanceId;
            return this;
        }

        public JobContextBuilder setTaskId(long taskId) {
            this.context.taskId = taskId;
            return this;
        }

        public JobContextBuilder setJobName(String jobName) {
            this.context.jobName = jobName;
            return this;
        }

        public JobContextBuilder setScheduleTime(DateTime scheduleTime) {
            this.context.scheduleTime = scheduleTime;
            return this;
        }

        public JobContextBuilder setDataTime(DateTime dataTime) {
            this.context.dataTime = dataTime;
            return this;
        }

        public JobContextBuilder setExecuteMode(String executeMode) {
            this.context.executeMode = executeMode;
            return this;
        }

        public JobContextBuilder setJobType(String jobType) {
            this.context.jobType = jobType;
            return this;
        }

        public JobContextBuilder setContent(String content) {
            this.context.content = content;
            return this;
        }

        public JobContextBuilder setUser(String user) {
            this.context.user = user;
            return this;
        }

        public JobContextBuilder setJobParameters(String jobParameters) {
            this.context.jobParameters = jobParameters;
            return this;
        }

        public JobContextBuilder setInstanceParameters(String instanceParameters) {
            this.context.instanceParameters = instanceParameters;
            return this;
        }

        public JobContextBuilder setTaskMasterActorPath(String actorPath) {
            this.context.instanceMasterActorPath = actorPath;
            return this;
        }

        public JobContextBuilder setTaskName(String taskName) {
            this.context.taskName = taskName;
            return this;
        }

        public JobContextBuilder setTask(Object task) {
            this.context.task = task;
            return this;
        }

        public JobContextBuilder setGroupId(String groupId) {
            this.context.groupId = groupId;
            return this;
        }

        public JobContextBuilder setUpstreamData(List<JobInstanceData> upstreamData) {
            this.context.upstreamData = upstreamData;
            return this;
        }

        public JobContextBuilder setTaskResults(Map<Long, String> taskResults) {
            this.context.taskResults = taskResults;
            return this;
        }

        public JobContextBuilder setTaskStatuses(Map<Long, TaskStatus> taskStatuses) {
            this.context.taskStatuses = taskStatuses;
            return this;
        }

        public JobContextBuilder setMaxAttempt(int maxAttempt) {
            this.context.maxAttempt = maxAttempt;
            return this;
        }

        public JobContextBuilder setAttempt(int attempt) {
            this.context.attempt = attempt;
            return this;
        }

        public JobContextBuilder setTaskMaxAttempt(int taskMaxAttempt) {
            this.context.taskMaxAttempt = taskMaxAttempt;
            return this;
        }

        public JobContextBuilder setTaskAttemptInterval(int taskAttemptInterval) {
            this.context.taskAttemptInterval = taskAttemptInterval;
            return this;
        }

        public JobContextBuilder setSerialNum(long serialNum) {
            this.context.serialNum = serialNum;
            return this;
        }

        public JobContextBuilder setShardingId(long shardingId) {
            this.context.shardingId = shardingId;
            return this;
        }

        public JobContextBuilder setShardingParameter(String shardingParameter) {
            this.context.shardingParameter = shardingParameter;
            return this;
        }

        public JobContextBuilder setShardingNum(int shardingNum) {
            this.context.shardingNum = shardingNum;
            return this;
        }

        public JobContextBuilder setAllWorkerAddrs(List<String> allWorkerAddrs) {
            this.context.allWorkerAddrs = allWorkerAddrs;
            return this;
        }

        public JobContextBuilder setWorkerAddrs(String workerAddr) {
            this.context.workerAddr = workerAddr;
            return this;
        }

        public JobContext build() {
            if (ConfigUtil.getWorkerConfig().getBoolean("log.collector.enable", true)) {
                this.context.logCollector = LogCollectorFactory.get();
            }
            return this.context;
        }
    }
}

