/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.worker.batch;

import com.alibaba.schedulerx.protocol.Worker;
import com.alibaba.schedulerx.shade.com.google.common.collect.Maps;
import com.alibaba.schedulerx.worker.batch.ContainerStatusReqHandler;
import com.alibaba.schedulerx.worker.log.LogFactory;
import com.alibaba.schedulerx.worker.log.Logger;
import java.util.Map;

public enum ContainerStatusReqHandlerPool {
    INSTANCE;

    private static final Logger LOGGER;
    private Map<Long, ContainerStatusReqHandler<Worker.ContainerReportTaskStatusRequest>> handlers = Maps.newConcurrentMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(long jobInstanceId, ContainerStatusReqHandler<Worker.ContainerReportTaskStatusRequest> reqHandler) {
        if (!this.handlers.containsKey(jobInstanceId)) {
            ContainerStatusReqHandlerPool containerStatusReqHandlerPool = this;
            synchronized (containerStatusReqHandlerPool) {
                if (!this.handlers.containsKey(jobInstanceId)) {
                    this.handlers.put(jobInstanceId, reqHandler);
                    reqHandler.start();
                }
            }
        }
    }

    public void stop(long jobInstanceId) {
        if (this.handlers.containsKey(jobInstanceId)) {
            this.handlers.get(jobInstanceId).stop();
            this.handlers.remove(jobInstanceId);
        }
    }

    public boolean contains(long jobInstanceId) {
        return this.handlers.containsKey(jobInstanceId);
    }

    public boolean submitReq(long jobInstanceId, Worker.ContainerReportTaskStatusRequest request2) {
        boolean success2;
        try {
            this.handlers.get(jobInstanceId).submitRequest(request2);
            success2 = true;
        }
        catch (Throwable e) {
            success2 = false;
            LOGGER.error("container buffer status req error, uniqueId:{}_{}_{}", request2.getJobId(), request2.getJobInstanceId(), request2.getTaskId(), e);
        }
        return success2;
    }

    public Map<Long, ContainerStatusReqHandler<Worker.ContainerReportTaskStatusRequest>> getHandlers() {
        return this.handlers;
    }

    static {
        LOGGER = LogFactory.getLogger(ContainerStatusReqHandlerPool.class);
    }
}

