/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.shade.org.jboss.netty.channel.local;

import com.alibaba.schedulerx.shade.org.jboss.netty.channel.AbstractChannelSink;
import com.alibaba.schedulerx.shade.org.jboss.netty.channel.Channel;
import com.alibaba.schedulerx.shade.org.jboss.netty.channel.ChannelEvent;
import com.alibaba.schedulerx.shade.org.jboss.netty.channel.ChannelException;
import com.alibaba.schedulerx.shade.org.jboss.netty.channel.ChannelFuture;
import com.alibaba.schedulerx.shade.org.jboss.netty.channel.ChannelPipeline;
import com.alibaba.schedulerx.shade.org.jboss.netty.channel.ChannelState;
import com.alibaba.schedulerx.shade.org.jboss.netty.channel.ChannelStateEvent;
import com.alibaba.schedulerx.shade.org.jboss.netty.channel.Channels;
import com.alibaba.schedulerx.shade.org.jboss.netty.channel.MessageEvent;
import com.alibaba.schedulerx.shade.org.jboss.netty.channel.local.DefaultLocalChannel;
import com.alibaba.schedulerx.shade.org.jboss.netty.channel.local.DefaultLocalServerChannel;
import com.alibaba.schedulerx.shade.org.jboss.netty.channel.local.LocalAddress;
import com.alibaba.schedulerx.shade.org.jboss.netty.channel.local.LocalChannelRegistry;
import com.alibaba.schedulerx.shade.org.jboss.netty.logging.InternalLogger;
import com.alibaba.schedulerx.shade.org.jboss.netty.logging.InternalLoggerFactory;
import java.io.IOException;
import java.net.ConnectException;
import java.net.SocketAddress;

final class LocalClientChannelSink
extends AbstractChannelSink {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(LocalClientChannelSink.class);

    LocalClientChannelSink() {
    }

    public void eventSunk(ChannelPipeline pipeline, ChannelEvent e) throws Exception {
        if (e instanceof ChannelStateEvent) {
            ChannelStateEvent event = (ChannelStateEvent)e;
            DefaultLocalChannel channel = (DefaultLocalChannel)event.getChannel();
            ChannelFuture future2 = event.getFuture();
            ChannelState state = event.getState();
            Object value2 = event.getValue();
            switch (state) {
                case OPEN: {
                    if (!Boolean.FALSE.equals(value2)) break;
                    channel.closeNow(future2);
                    break;
                }
                case BOUND: {
                    if (value2 != null) {
                        LocalClientChannelSink.bind(channel, future2, (LocalAddress)value2);
                        break;
                    }
                    channel.closeNow(future2);
                    break;
                }
                case CONNECTED: {
                    if (value2 != null) {
                        this.connect(channel, future2, (LocalAddress)value2);
                        break;
                    }
                    channel.closeNow(future2);
                    break;
                }
                case INTEREST_OPS: {
                    future2.setSuccess();
                }
            }
        } else if (e instanceof MessageEvent) {
            MessageEvent event = (MessageEvent)e;
            DefaultLocalChannel channel = (DefaultLocalChannel)event.getChannel();
            boolean offered = channel.writeBuffer.offer(event);
            assert (offered);
            channel.flushWriteBuffer();
        }
    }

    private static void bind(DefaultLocalChannel channel, ChannelFuture future2, LocalAddress localAddress) {
        try {
            if (!LocalChannelRegistry.register(localAddress, channel)) {
                throw new ChannelException("address already in use: " + localAddress);
            }
            channel.setBound();
            channel.localAddress = localAddress;
            future2.setSuccess();
            Channels.fireChannelBound(channel, (SocketAddress)localAddress);
        }
        catch (Throwable t) {
            LocalChannelRegistry.unregister(localAddress);
            future2.setFailure(t);
            Channels.fireExceptionCaught(channel, t);
        }
    }

    private void connect(DefaultLocalChannel channel, ChannelFuture future2, LocalAddress remoteAddress) {
        DefaultLocalChannel acceptedChannel;
        ChannelPipeline pipeline;
        Channel remoteChannel = LocalChannelRegistry.getChannel(remoteAddress);
        if (!(remoteChannel instanceof DefaultLocalServerChannel)) {
            future2.setFailure(new ConnectException("connection refused: " + remoteAddress));
            return;
        }
        DefaultLocalServerChannel serverChannel = (DefaultLocalServerChannel)remoteChannel;
        try {
            pipeline = serverChannel.getConfig().getPipelineFactory().getPipeline();
        }
        catch (Exception e) {
            future2.setFailure(e);
            Channels.fireExceptionCaught(channel, (Throwable)e);
            if (logger.isWarnEnabled()) {
                logger.warn("Failed to initialize an accepted socket.", e);
            }
            return;
        }
        future2.setSuccess();
        channel.pairedChannel = acceptedChannel = new DefaultLocalChannel(serverChannel, serverChannel.getFactory(), pipeline, this, channel);
        if (!channel.isBound()) {
            LocalClientChannelSink.bind(channel, Channels.succeededFuture(channel), new LocalAddress("ephemeral"));
        }
        channel.remoteAddress = serverChannel.getLocalAddress();
        channel.setConnected();
        Channels.fireChannelConnected(channel, (SocketAddress)serverChannel.getLocalAddress());
        acceptedChannel.localAddress = serverChannel.getLocalAddress();
        try {
            acceptedChannel.setBound();
        }
        catch (IOException e) {
            throw new Error(e);
        }
        Channels.fireChannelBound(acceptedChannel, (SocketAddress)channel.getRemoteAddress());
        acceptedChannel.remoteAddress = channel.getLocalAddress();
        acceptedChannel.setConnected();
        Channels.fireChannelConnected(acceptedChannel, (SocketAddress)channel.getLocalAddress());
        channel.flushWriteBuffer();
        acceptedChannel.flushWriteBuffer();
    }
}

