/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.shade.org.h2.value;

import com.alibaba.schedulerx.shade.org.h2.engine.SysProperties;
import com.alibaba.schedulerx.shade.org.h2.util.Bits;
import com.alibaba.schedulerx.shade.org.h2.util.MathUtils;
import com.alibaba.schedulerx.shade.org.h2.util.StringUtils;
import com.alibaba.schedulerx.shade.org.h2.util.Utils;
import com.alibaba.schedulerx.shade.org.h2.value.CompareMode;
import com.alibaba.schedulerx.shade.org.h2.value.Value;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Arrays;

public class ValueBytes
extends Value {
    private static final ValueBytes EMPTY = new ValueBytes(Utils.EMPTY_BYTES);
    protected byte[] value;
    protected int hash;

    protected ValueBytes(byte[] byArray) {
        this.value = byArray;
    }

    public static ValueBytes get(byte[] byArray) {
        if (byArray.length == 0) {
            return EMPTY;
        }
        byArray = Utils.cloneByteArray(byArray);
        return ValueBytes.getNoCopy(byArray);
    }

    public static ValueBytes getNoCopy(byte[] byArray) {
        if (byArray.length == 0) {
            return EMPTY;
        }
        ValueBytes valueBytes = new ValueBytes(byArray);
        if (byArray.length > SysProperties.OBJECT_CACHE_MAX_PER_ELEMENT_SIZE) {
            return valueBytes;
        }
        return (ValueBytes)Value.cache(valueBytes);
    }

    @Override
    public int getType() {
        return 12;
    }

    @Override
    public String getSQL() {
        return "X'" + StringUtils.convertBytesToHex(this.getBytesNoCopy()) + "'";
    }

    @Override
    public byte[] getBytesNoCopy() {
        return this.value;
    }

    @Override
    public byte[] getBytes() {
        return Utils.cloneByteArray(this.getBytesNoCopy());
    }

    @Override
    protected int compareSecure(Value value2, CompareMode compareMode) {
        byte[] byArray = ((ValueBytes)value2).value;
        if (compareMode.isBinaryUnsigned()) {
            return Bits.compareNotNullUnsigned(this.value, byArray);
        }
        return Bits.compareNotNullSigned(this.value, byArray);
    }

    @Override
    public String getString() {
        return StringUtils.convertBytesToHex(this.value);
    }

    @Override
    public long getPrecision() {
        return this.value.length;
    }

    @Override
    public int hashCode() {
        if (this.hash == 0) {
            this.hash = Utils.getByteArrayHash(this.value);
        }
        return this.hash;
    }

    @Override
    public Object getObject() {
        return this.getBytes();
    }

    @Override
    public void set(PreparedStatement preparedStatement, int n) throws SQLException {
        preparedStatement.setBytes(n, this.value);
    }

    @Override
    public int getDisplaySize() {
        return MathUtils.convertLongToInt((long)this.value.length * 2L);
    }

    @Override
    public int getMemory() {
        return this.value.length + 24;
    }

    @Override
    public boolean equals(Object object) {
        return object instanceof ValueBytes && Arrays.equals(this.value, ((ValueBytes)object).value);
    }

    @Override
    public Value convertPrecision(long l, boolean bl) {
        if ((long)this.value.length <= l) {
            return this;
        }
        int n = MathUtils.convertLongToInt(l);
        byte[] byArray = Arrays.copyOf(this.value, n);
        return ValueBytes.get(byArray);
    }
}

