/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.shade.org.h2.index;

import com.alibaba.schedulerx.shade.org.h2.engine.Session;
import com.alibaba.schedulerx.shade.org.h2.index.Cursor;
import com.alibaba.schedulerx.shade.org.h2.message.DbException;
import com.alibaba.schedulerx.shade.org.h2.result.Row;
import com.alibaba.schedulerx.shade.org.h2.result.SearchRow;
import com.alibaba.schedulerx.shade.org.h2.table.Column;
import com.alibaba.schedulerx.shade.org.h2.table.TableLink;
import com.alibaba.schedulerx.shade.org.h2.value.DataType;
import com.alibaba.schedulerx.shade.org.h2.value.Value;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class LinkedCursor
implements Cursor {
    private final TableLink tableLink;
    private final PreparedStatement prep;
    private final String sql;
    private final Session session;
    private final ResultSet rs;
    private Row current;

    LinkedCursor(TableLink tableLink, ResultSet resultSet, Session session, String string2, PreparedStatement preparedStatement) {
        this.session = session;
        this.tableLink = tableLink;
        this.rs = resultSet;
        this.sql = string2;
        this.prep = preparedStatement;
    }

    @Override
    public Row get() {
        return this.current;
    }

    @Override
    public SearchRow getSearchRow() {
        return this.current;
    }

    @Override
    public boolean next() {
        int n;
        try {
            n = this.rs.next();
            if (n == 0) {
                this.rs.close();
                this.tableLink.reusePreparedStatement(this.prep, this.sql);
                this.current = null;
                return false;
            }
        }
        catch (SQLException sQLException) {
            throw DbException.convert(sQLException);
        }
        this.current = this.tableLink.getTemplateRow();
        for (n = 0; n < this.current.getColumnCount(); ++n) {
            Column column = this.tableLink.getColumn(n);
            Value value2 = DataType.readValue(this.session, this.rs, n + 1, column.getType());
            this.current.setValue(n, value2);
        }
        return true;
    }

    @Override
    public boolean previous() {
        throw DbException.throwInternalError(this.toString());
    }
}

