/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.shade.org.h2.constraint;

import com.alibaba.schedulerx.shade.org.h2.constraint.Constraint;
import com.alibaba.schedulerx.shade.org.h2.engine.Session;
import com.alibaba.schedulerx.shade.org.h2.expression.Expression;
import com.alibaba.schedulerx.shade.org.h2.expression.ExpressionVisitor;
import com.alibaba.schedulerx.shade.org.h2.index.Index;
import com.alibaba.schedulerx.shade.org.h2.message.DbException;
import com.alibaba.schedulerx.shade.org.h2.result.ResultInterface;
import com.alibaba.schedulerx.shade.org.h2.result.Row;
import com.alibaba.schedulerx.shade.org.h2.schema.Schema;
import com.alibaba.schedulerx.shade.org.h2.table.Column;
import com.alibaba.schedulerx.shade.org.h2.table.Table;
import com.alibaba.schedulerx.shade.org.h2.table.TableFilter;
import com.alibaba.schedulerx.shade.org.h2.util.StringUtils;
import com.alibaba.schedulerx.shade.org.h2.value.Value;
import com.alibaba.schedulerx.shade.org.h2.value.ValueNull;
import java.util.HashSet;
import java.util.Iterator;

public class ConstraintCheck
extends Constraint {
    private TableFilter filter;
    private Expression expr;

    public ConstraintCheck(Schema schema, int n, String string2, Table table) {
        super(schema, n, string2, table);
    }

    @Override
    public Constraint.Type getConstraintType() {
        return Constraint.Type.CHECK;
    }

    public void setTableFilter(TableFilter tableFilter) {
        this.filter = tableFilter;
    }

    public void setExpression(Expression expression) {
        this.expr = expression;
    }

    @Override
    public String getCreateSQLForCopy(Table table, String string2) {
        StringBuilder stringBuilder = new StringBuilder("ALTER TABLE ");
        stringBuilder.append(table.getSQL()).append(" ADD CONSTRAINT ");
        if (table.isHidden()) {
            stringBuilder.append("IF NOT EXISTS ");
        }
        stringBuilder.append(string2);
        if (this.comment != null) {
            stringBuilder.append(" COMMENT ").append(StringUtils.quoteStringSQL(this.comment));
        }
        stringBuilder.append(" CHECK").append(StringUtils.enclose(this.expr.getSQL())).append(" NOCHECK");
        return stringBuilder.toString();
    }

    private String getShortDescription() {
        return this.getName() + ": " + this.expr.getSQL();
    }

    @Override
    public String getCreateSQLWithoutIndexes() {
        return this.getCreateSQL();
    }

    @Override
    public String getCreateSQL() {
        return this.getCreateSQLForCopy(this.table, this.getSQL());
    }

    @Override
    public void removeChildrenAndResources(Session session) {
        this.table.removeConstraint(this);
        this.database.removeMeta(session, this.getId());
        this.filter = null;
        this.expr = null;
        this.table = null;
        this.invalidate();
    }

    @Override
    public void checkRow(Session session, Table table, Row row, Row row2) {
        boolean bl;
        if (row2 == null) {
            return;
        }
        this.filter.set(row2);
        try {
            Value value2 = this.expr.getValue(session);
            bl = value2 == ValueNull.INSTANCE || value2.getBoolean();
        }
        catch (DbException dbException) {
            throw DbException.get(23514, dbException, this.getShortDescription());
        }
        if (!bl) {
            throw DbException.get(23513, this.getShortDescription());
        }
    }

    @Override
    public boolean usesIndex(Index index2) {
        return false;
    }

    @Override
    public void setIndexOwner(Index index2) {
        DbException.throwInternalError(this.toString());
    }

    @Override
    public HashSet<Column> getReferencedColumns(Table table) {
        HashSet<Column> hashSet = new HashSet<Column>();
        this.expr.isEverything(ExpressionVisitor.getColumnsVisitor(hashSet));
        Iterator<Column> iterator2 = hashSet.iterator();
        while (iterator2.hasNext()) {
            if (iterator2.next().getTable() == table) continue;
            iterator2.remove();
        }
        return hashSet;
    }

    public Expression getExpression() {
        return this.expr;
    }

    @Override
    public boolean isBefore() {
        return true;
    }

    @Override
    public void checkExistingData(Session session) {
        if (session.getDatabase().isStarting()) {
            return;
        }
        String string2 = "SELECT 1 FROM " + this.filter.getTable().getSQL() + " WHERE NOT(" + this.expr.getSQL() + ")";
        ResultInterface resultInterface = session.prepare(string2).query(1);
        if (resultInterface.next()) {
            throw DbException.get(23513, this.getName());
        }
    }

    @Override
    public Index getUniqueIndex() {
        return null;
    }

    @Override
    public void rebuild() {
    }

    @Override
    public boolean isEverything(ExpressionVisitor expressionVisitor) {
        return this.expr.isEverything(expressionVisitor);
    }
}

