/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.shade.org.h2.command.dml;

import com.alibaba.schedulerx.shade.org.h2.command.Prepared;
import com.alibaba.schedulerx.shade.org.h2.command.dml.SelectOrderBy;
import com.alibaba.schedulerx.shade.org.h2.engine.Database;
import com.alibaba.schedulerx.shade.org.h2.engine.Session;
import com.alibaba.schedulerx.shade.org.h2.expression.Alias;
import com.alibaba.schedulerx.shade.org.h2.expression.Expression;
import com.alibaba.schedulerx.shade.org.h2.expression.ExpressionColumn;
import com.alibaba.schedulerx.shade.org.h2.expression.ExpressionVisitor;
import com.alibaba.schedulerx.shade.org.h2.expression.Parameter;
import com.alibaba.schedulerx.shade.org.h2.expression.ValueExpression;
import com.alibaba.schedulerx.shade.org.h2.message.DbException;
import com.alibaba.schedulerx.shade.org.h2.result.ResultInterface;
import com.alibaba.schedulerx.shade.org.h2.result.ResultTarget;
import com.alibaba.schedulerx.shade.org.h2.result.SortOrder;
import com.alibaba.schedulerx.shade.org.h2.table.ColumnResolver;
import com.alibaba.schedulerx.shade.org.h2.table.Table;
import com.alibaba.schedulerx.shade.org.h2.table.TableFilter;
import com.alibaba.schedulerx.shade.org.h2.util.New;
import com.alibaba.schedulerx.shade.org.h2.value.Value;
import com.alibaba.schedulerx.shade.org.h2.value.ValueInt;
import com.alibaba.schedulerx.shade.org.h2.value.ValueNull;
import java.util.ArrayList;
import java.util.HashSet;

public abstract class Query
extends Prepared {
    protected Expression limitExpr;
    protected Expression offsetExpr;
    protected Expression sampleSizeExpr;
    protected boolean distinct;
    protected boolean randomAccessResult;
    private boolean noCache;
    private int lastLimit;
    private long lastEvaluated;
    private ResultInterface lastResult;
    private Value[] lastParameters;
    private boolean cacheableChecked;
    private boolean neverLazy;

    Query(Session session) {
        super(session);
    }

    public void setNeverLazy(boolean bl) {
        this.neverLazy = bl;
    }

    public boolean isNeverLazy() {
        return this.neverLazy;
    }

    public abstract boolean isUnion();

    public abstract void prepareJoinBatch();

    protected abstract ResultInterface queryWithoutCache(int var1, ResultTarget var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResultInterface queryWithoutCacheLazyCheck(int n, ResultTarget resultTarget) {
        boolean bl;
        boolean bl2 = bl = this.neverLazy && this.session.isLazyQueryExecution();
        if (bl) {
            this.session.setLazyQueryExecution(false);
        }
        try {
            ResultInterface resultInterface = this.queryWithoutCache(n, resultTarget);
            return resultInterface;
        }
        finally {
            if (bl) {
                this.session.setLazyQueryExecution(true);
            }
        }
    }

    public abstract void init();

    public abstract ArrayList<Expression> getExpressions();

    public abstract double getCost();

    public int getCostAsExpression() {
        return (int)Math.min(1000000.0, 10.0 + 10.0 * this.getCost());
    }

    public abstract HashSet<Table> getTables();

    public abstract void setOrder(ArrayList<SelectOrderBy> var1);

    public abstract boolean hasOrder();

    public abstract void setForUpdate(boolean var1);

    public abstract int getColumnCount();

    public abstract void mapColumns(ColumnResolver var1, int var2);

    public abstract void setEvaluatable(TableFilter var1, boolean var2);

    public abstract void addGlobalCondition(Parameter var1, int var2, int var3);

    public abstract boolean allowGlobalConditions();

    public abstract boolean isEverything(ExpressionVisitor var1);

    public abstract void updateAggregate(Session var1);

    public abstract void fireBeforeSelectTriggers();

    public void setDistinct(boolean bl) {
        this.distinct = bl;
    }

    public boolean isDistinct() {
        return this.distinct;
    }

    public void setRandomAccessResult(boolean bl) {
        this.randomAccessResult = bl;
    }

    @Override
    public boolean isQuery() {
        return true;
    }

    @Override
    public boolean isTransactional() {
        return true;
    }

    public void disableCache() {
        this.noCache = true;
    }

    private boolean sameResultAsLast(Session session, Value[] valueArray, Value[] valueArray2, long l) {
        if (!this.cacheableChecked) {
            long l2 = this.getMaxDataModificationId();
            this.noCache = l2 == Long.MAX_VALUE;
            this.cacheableChecked = true;
        }
        if (this.noCache) {
            return false;
        }
        Database database = session.getDatabase();
        for (int i = 0; i < valueArray.length; ++i) {
            Value value2 = valueArray2[i];
            Value value3 = valueArray[i];
            if (value2.getType() == value3.getType() && database.areEqual(value2, value3)) continue;
            return false;
        }
        if (!this.isEverything(ExpressionVisitor.DETERMINISTIC_VISITOR) || !this.isEverything(ExpressionVisitor.INDEPENDENT_VISITOR)) {
            return false;
        }
        return database.getModificationDataId() <= l || this.getMaxDataModificationId() <= l;
    }

    public final Value[] getParameterValues() {
        ArrayList<Parameter> arrayList = this.getParameters();
        if (arrayList == null) {
            arrayList = New.arrayList();
        }
        int n = arrayList.size();
        Value[] valueArray = new Value[n];
        for (int i = 0; i < n; ++i) {
            Value value2;
            valueArray[i] = value2 = arrayList.get(i).getParamValue();
        }
        return valueArray;
    }

    @Override
    public final ResultInterface query(int n) {
        return this.query(n, null);
    }

    public final ResultInterface query(int n, ResultTarget resultTarget) {
        ResultInterface resultInterface;
        if (this.isUnion()) {
            return this.queryWithoutCacheLazyCheck(n, resultTarget);
        }
        this.fireBeforeSelectTriggers();
        if (this.noCache || !this.session.getDatabase().getOptimizeReuseResults() || this.session.isLazyQueryExecution()) {
            return this.queryWithoutCacheLazyCheck(n, resultTarget);
        }
        Value[] valueArray = this.getParameterValues();
        long l = this.session.getDatabase().getModificationDataId();
        if (this.isEverything(ExpressionVisitor.DETERMINISTIC_VISITOR) && this.lastResult != null && !this.lastResult.isClosed() && n == this.lastLimit && this.sameResultAsLast(this.session, valueArray, this.lastParameters, this.lastEvaluated)) {
            this.lastResult = this.lastResult.createShallowCopy(this.session);
            if (this.lastResult != null) {
                this.lastResult.reset();
                return this.lastResult;
            }
        }
        this.lastParameters = valueArray;
        this.closeLastResult();
        this.lastResult = resultInterface = this.queryWithoutCacheLazyCheck(n, resultTarget);
        this.lastEvaluated = l;
        this.lastLimit = n;
        return resultInterface;
    }

    private void closeLastResult() {
        if (this.lastResult != null) {
            this.lastResult.close();
        }
    }

    static void initOrder(Session session, ArrayList<Expression> arrayList, ArrayList<String> arrayList2, ArrayList<SelectOrderBy> arrayList3, int n, boolean bl, ArrayList<TableFilter> arrayList4) {
        Database database = session.getDatabase();
        for (SelectOrderBy selectOrderBy : arrayList3) {
            Object object;
            Expression expression = selectOrderBy.expression;
            if (expression == null) continue;
            boolean bl2 = false;
            int n2 = arrayList.size();
            if (expression instanceof ExpressionColumn) {
                object = (ExpressionColumn)expression;
                String string2 = ((ExpressionColumn)object).getOriginalTableAliasName();
                String string3 = ((ExpressionColumn)object).getOriginalColumnName();
                for (int i = 0; i < n; ++i) {
                    Object object2;
                    Expression expression2;
                    boolean bl3 = false;
                    Expression expression3 = arrayList.get(i);
                    if (expression3 instanceof ExpressionColumn) {
                        expression2 = (ExpressionColumn)expression3;
                        bl3 = database.equalsIdentifiers(string3, ((ExpressionColumn)expression2).getColumnName());
                        if (bl3 && string2 != null) {
                            object2 = ((ExpressionColumn)expression2).getOriginalTableAliasName();
                            if (object2 == null) {
                                bl3 = false;
                                if (arrayList4 != null) {
                                    for (TableFilter tableFilter : arrayList4) {
                                        if (!database.equalsIdentifiers(tableFilter.getTableAlias(), string2)) continue;
                                        bl3 = true;
                                        break;
                                    }
                                }
                            } else {
                                bl3 = database.equalsIdentifiers((String)object2, string2);
                            }
                        }
                    } else {
                        if (!(expression3 instanceof Alias)) continue;
                        if (string2 == null && database.equalsIdentifiers(string3, expression3.getAlias())) {
                            bl3 = true;
                        } else {
                            expression2 = expression3.getNonAliasExpression();
                            if (expression2 instanceof ExpressionColumn) {
                                object2 = expression2;
                                String string4 = ((ExpressionColumn)object).getSQL();
                                String string5 = ((ExpressionColumn)object2).getSQL();
                                String string6 = ((ExpressionColumn)object2).getColumnName();
                                bl3 = database.equalsIdentifiers(string3, string6);
                                if (!database.equalsIdentifiers(string4, string5)) {
                                    bl3 = false;
                                }
                            }
                        }
                    }
                    if (!bl3) continue;
                    n2 = i;
                    bl2 = true;
                    break;
                }
            } else {
                object = expression.getSQL();
                if (arrayList2 != null) {
                    int n3 = arrayList2.size();
                    for (int i = 0; i < n3; ++i) {
                        String string6 = arrayList2.get(i);
                        if (!database.equalsIdentifiers(string6, (String)object)) continue;
                        n2 = i;
                        bl2 = true;
                        break;
                    }
                }
            }
            if (!bl2) {
                if (bl) {
                    throw DbException.get(90068, expression.getSQL());
                }
                arrayList.add(expression);
                object = expression.getSQL();
                arrayList2.add((String)object);
            }
            selectOrderBy.columnIndexExpr = ValueExpression.get(ValueInt.get(n2 + 1));
            selectOrderBy.expression = arrayList.get(n2).getNonAliasExpression();
        }
    }

    public SortOrder prepareOrder(ArrayList<SelectOrderBy> arrayList, int n) {
        int n2 = arrayList.size();
        int[] nArray = new int[n2];
        int[] nArray2 = new int[n2];
        for (int i = 0; i < n2; ++i) {
            int n3;
            int n4;
            SelectOrderBy selectOrderBy = arrayList.get(i);
            boolean bl = false;
            Expression expression = selectOrderBy.columnIndexExpr;
            Value value2 = expression.getValue(null);
            if (value2 == ValueNull.INSTANCE) {
                n4 = 0;
            } else {
                n4 = value2.getInt();
                if (n4 < 0) {
                    bl = true;
                    n4 = -n4;
                }
                if (--n4 < 0 || n4 >= n) {
                    throw DbException.get(90068, "" + (n4 + 1));
                }
            }
            nArray[i] = n4;
            boolean bl2 = selectOrderBy.descending;
            if (bl) {
                bl2 = !bl2;
            }
            int n5 = n3 = bl2 ? 1 : 0;
            if (selectOrderBy.nullsFirst) {
                n3 += 2;
            } else if (selectOrderBy.nullsLast) {
                n3 += 4;
            }
            nArray2[i] = n3;
        }
        return new SortOrder(this.session.getDatabase(), nArray, nArray2, arrayList);
    }

    public void setOffset(Expression expression) {
        this.offsetExpr = expression;
    }

    public Expression getOffset() {
        return this.offsetExpr;
    }

    public void setLimit(Expression expression) {
        this.limitExpr = expression;
    }

    public Expression getLimit() {
        return this.limitExpr;
    }

    void addParameter(Parameter parameter) {
        if (this.parameters == null) {
            this.parameters = New.arrayList();
        }
        this.parameters.add(parameter);
    }

    public void setSampleSize(Expression expression) {
        this.sampleSizeExpr = expression;
    }

    int getSampleSizeValue(Session session) {
        if (this.sampleSizeExpr == null) {
            return 0;
        }
        Value value2 = this.sampleSizeExpr.optimize(session).getValue(session);
        if (value2 == ValueNull.INSTANCE) {
            return 0;
        }
        return value2.getInt();
    }

    public final long getMaxDataModificationId() {
        ExpressionVisitor expressionVisitor = ExpressionVisitor.getMaxModificationIdVisitor();
        this.isEverything(expressionVisitor);
        return expressionVisitor.getMaxDataModificationId();
    }
}

