/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.shade.org.h2.command.ddl;

import com.alibaba.schedulerx.shade.org.h2.command.ddl.DefineCommand;
import com.alibaba.schedulerx.shade.org.h2.engine.Database;
import com.alibaba.schedulerx.shade.org.h2.engine.Session;
import com.alibaba.schedulerx.shade.org.h2.index.Index;
import com.alibaba.schedulerx.shade.org.h2.message.DbException;
import com.alibaba.schedulerx.shade.org.h2.schema.Schema;

public class AlterIndexRename
extends DefineCommand {
    private boolean ifExists;
    private Schema oldSchema;
    private String oldIndexName;
    private Index oldIndex;
    private String newIndexName;

    public AlterIndexRename(Session session) {
        super(session);
    }

    public void setIfExists(boolean bl) {
        this.ifExists = bl;
    }

    public void setOldSchema(Schema schema) {
        this.oldSchema = schema;
    }

    public void setOldName(String string2) {
        this.oldIndexName = string2;
    }

    public void setNewName(String string2) {
        this.newIndexName = string2;
    }

    @Override
    public int update() {
        this.session.commit(true);
        Database database = this.session.getDatabase();
        this.oldIndex = this.oldSchema.findIndex(this.session, this.oldIndexName);
        if (this.oldIndex == null) {
            if (!this.ifExists) {
                throw DbException.get(42112, this.newIndexName);
            }
            return 0;
        }
        if (this.oldSchema.findIndex(this.session, this.newIndexName) != null || this.newIndexName.equals(this.oldIndexName)) {
            throw DbException.get(42111, this.newIndexName);
        }
        this.session.getUser().checkRight(this.oldIndex.getTable(), 15);
        database.renameSchemaObject(this.session, this.oldIndex, this.newIndexName);
        return 0;
    }

    @Override
    public int getType() {
        return 1;
    }
}

