/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.shade.org.h2.bnf.context;

import com.alibaba.schedulerx.shade.org.h2.bnf.Bnf;
import com.alibaba.schedulerx.shade.org.h2.bnf.BnfVisitor;
import com.alibaba.schedulerx.shade.org.h2.bnf.Rule;
import com.alibaba.schedulerx.shade.org.h2.bnf.RuleElement;
import com.alibaba.schedulerx.shade.org.h2.bnf.RuleHead;
import com.alibaba.schedulerx.shade.org.h2.bnf.RuleList;
import com.alibaba.schedulerx.shade.org.h2.bnf.Sentence;
import com.alibaba.schedulerx.shade.org.h2.bnf.context.DbColumn;
import com.alibaba.schedulerx.shade.org.h2.bnf.context.DbContents;
import com.alibaba.schedulerx.shade.org.h2.bnf.context.DbProcedure;
import com.alibaba.schedulerx.shade.org.h2.bnf.context.DbSchema;
import com.alibaba.schedulerx.shade.org.h2.bnf.context.DbTableOrView;
import com.alibaba.schedulerx.shade.org.h2.message.DbException;
import com.alibaba.schedulerx.shade.org.h2.util.ParserUtil;
import com.alibaba.schedulerx.shade.org.h2.util.StringUtils;
import java.util.HashMap;
import java.util.HashSet;

public class DbContextRule
implements Rule {
    public static final int COLUMN = 0;
    public static final int TABLE = 1;
    public static final int TABLE_ALIAS = 2;
    public static final int NEW_TABLE_ALIAS = 3;
    public static final int COLUMN_ALIAS = 4;
    public static final int SCHEMA = 5;
    public static final int PROCEDURE = 6;
    private final DbContents contents;
    private final int type;
    private String columnType;

    public DbContextRule(DbContents dbContents, int n) {
        this.contents = dbContents;
        this.type = n;
    }

    public void setColumnType(String string2) {
        this.columnType = string2;
    }

    @Override
    public void setLinks(HashMap<String, RuleHead> hashMap) {
    }

    @Override
    public void accept(BnfVisitor bnfVisitor) {
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean autoComplete(Sentence sentence) {
        String string2;
        String string3 = string2 = sentence.getQuery();
        String string4 = sentence.getQueryUpper();
        switch (this.type) {
            case 5: {
                DbSchema[] dbSchemaArray = this.contents.getSchemas();
                String object2 = null;
                Object object3 = null;
                for (DbSchema dbSchema : dbSchemaArray) {
                    String string5 = StringUtils.toUpperEnglish(dbSchema.name);
                    if (string4.startsWith(string5)) {
                        if (object2 != null && string5.length() <= object2.length()) continue;
                        object2 = string5;
                        object3 = dbSchema;
                        continue;
                    }
                    if (string3.length() != 0 && !string5.startsWith(string4) || string3.length() >= string5.length()) continue;
                    sentence.add(string5, string5.substring(string3.length()), this.type);
                    sentence.add(dbSchema.quotedName + ".", dbSchema.quotedName.substring(string3.length()) + ".", 0);
                }
                if (object2 == null) break;
                sentence.setLastMatchedSchema((DbSchema)object3);
                string3 = string3.substring(object2.length());
                break;
            }
            case 1: {
                void var8_17;
                void var11_28;
                DbSchema dbSchema = sentence.getLastMatchedSchema();
                if (dbSchema == null) {
                    dbSchema = this.contents.getDefaultSchema();
                }
                DbTableOrView[] dbTableOrViewArray = dbSchema.getTables();
                Object object3 = null;
                Object var8_16 = null;
                DbTableOrView[] dbTableOrViewArray2 = dbTableOrViewArray;
                int n = dbTableOrViewArray2.length;
                boolean bl = false;
                while (var11_28 < n) {
                    DbTableOrView dbTableOrView = dbTableOrViewArray2[var11_28];
                    String string6 = string4;
                    String string7 = StringUtils.toUpperEnglish(dbTableOrView.getName());
                    if (dbTableOrView.getQuotedName().length() > string7.length()) {
                        string7 = dbTableOrView.getQuotedName();
                        string6 = string2;
                    }
                    if (string6.startsWith(string7)) {
                        if (object3 == null || string7.length() > ((String)object3).length()) {
                            object3 = string7;
                            DbTableOrView dbTableOrView2 = dbTableOrView;
                        }
                    } else if ((string3.length() == 0 || string7.startsWith(string6)) && string3.length() < string7.length()) {
                        sentence.add(dbTableOrView.getQuotedName(), dbTableOrView.getQuotedName().substring(string3.length()), 0);
                    }
                    ++var11_28;
                }
                if (object3 == null) break;
                sentence.setLastMatchedTable((DbTableOrView)var8_17);
                sentence.addTable((DbTableOrView)var8_17);
                string3 = string3.substring(((String)object3).length());
                break;
            }
            case 3: {
                string3 = DbContextRule.autoCompleteTableAlias(sentence, true);
                break;
            }
            case 2: {
                string3 = DbContextRule.autoCompleteTableAlias(sentence, false);
                break;
            }
            case 4: {
                String string7;
                char c;
                int n;
                if (string2.indexOf(32) < 0) break;
                for (n = 0; n < string4.length() && ((c = string4.charAt(n)) == '_' || Character.isLetterOrDigit(c)); ++n) {
                }
                if (n == 0 || ParserUtil.isKeyword(string7 = string4.substring(0, n))) break;
                string3 = string3.substring(string7.length());
                break;
            }
            case 0: {
                HashSet<DbTableOrView> hashSet = sentence.getTables();
                String string8 = null;
                Object object3 = sentence.getLastMatchedTable();
                if (object3 != null && ((DbTableOrView)object3).getColumns() != null) {
                    for (DbColumn dbColumn : ((DbTableOrView)object3).getColumns()) {
                        void var12_34;
                        String string9 = string4;
                        String string10 = StringUtils.toUpperEnglish(dbColumn.getName());
                        if (dbColumn.getQuotedName().length() > string10.length()) {
                            string10 = dbColumn.getQuotedName();
                            String string11 = string2;
                        }
                        if (!var12_34.startsWith(string10) || this.columnType != null && !dbColumn.getDataType().contains(this.columnType)) continue;
                        String string12 = string3.substring(string10.length());
                        if (string8 == null || string12.length() < string8.length()) {
                            string8 = string12;
                            continue;
                        }
                        if (string3.length() != 0 && !string10.startsWith((String)var12_34) || string3.length() >= string10.length()) continue;
                        sentence.add(dbColumn.getName(), dbColumn.getName().substring(string3.length()), 0);
                    }
                }
                for (DbSchema dbSchema : this.contents.getSchemas()) {
                    for (DbTableOrView dbTableOrView : dbSchema.getTables()) {
                        if (dbTableOrView != object3 && hashSet != null && !hashSet.contains(dbTableOrView) || dbTableOrView == null || dbTableOrView.getColumns() == null) continue;
                        for (DbColumn dbColumn : dbTableOrView.getColumns()) {
                            String string13 = StringUtils.toUpperEnglish(dbColumn.getName());
                            if (this.columnType != null && !dbColumn.getDataType().contains(this.columnType)) continue;
                            if (string4.startsWith(string13)) {
                                String string14 = string3.substring(string13.length());
                                if (string8 != null && string14.length() >= string8.length()) continue;
                                string8 = string14;
                                continue;
                            }
                            if (string3.length() != 0 && !string13.startsWith(string4) || string3.length() >= string13.length()) continue;
                            sentence.add(dbColumn.getName(), dbColumn.getName().substring(string3.length()), 0);
                        }
                    }
                }
                if (string8 == null) break;
                string3 = string8;
                break;
            }
            case 6: {
                this.autoCompleteProcedure(sentence);
                break;
            }
            default: {
                throw DbException.throwInternalError("type=" + this.type);
            }
        }
        if (!string3.equals(string2)) {
            while (Bnf.startWithSpace(string3)) {
                string3 = string3.substring(1);
            }
            sentence.setQuery(string3);
            return true;
        }
        return false;
    }

    private void autoCompleteProcedure(Sentence sentence) {
        String string2;
        DbSchema dbSchema = sentence.getLastMatchedSchema();
        if (dbSchema == null) {
            dbSchema = this.contents.getDefaultSchema();
        }
        String string3 = string2 = sentence.getQueryUpper();
        if (string2.contains("(")) {
            string3 = string2.substring(0, string2.indexOf(40)).trim();
        }
        RuleElement ruleElement = new RuleElement("(", "Function");
        RuleElement ruleElement2 = new RuleElement(")", "Function");
        RuleElement ruleElement3 = new RuleElement(",", "Function");
        for (DbProcedure dbProcedure : dbSchema.getProcedures()) {
            String string4 = dbProcedure.getName();
            if (!string4.startsWith(string3)) continue;
            RuleElement ruleElement4 = new RuleElement(string4, "Function");
            RuleList ruleList = new RuleList(ruleElement4, ruleElement, false);
            if (string2.contains("(")) {
                for (DbColumn dbColumn : dbProcedure.getParameters()) {
                    if (dbColumn.getPosition() > 1) {
                        ruleList = new RuleList(ruleList, ruleElement3, false);
                    }
                    DbContextRule dbContextRule = new DbContextRule(this.contents, 0);
                    String string5 = dbColumn.getDataType();
                    if (string5.contains("(")) {
                        string5 = string5.substring(0, string5.indexOf(40));
                    }
                    dbContextRule.setColumnType(string5);
                    ruleList = new RuleList(ruleList, dbContextRule, false);
                }
                ruleList = new RuleList(ruleList, ruleElement2, false);
            }
            ruleList.autoComplete(sentence);
        }
    }

    private static String autoCompleteTableAlias(Sentence sentence, boolean bl) {
        HashMap<String, DbTableOrView> hashMap;
        char c;
        int n;
        String string2 = sentence.getQuery();
        String string3 = sentence.getQueryUpper();
        for (n = 0; n < string3.length() && ((c = string3.charAt(n)) == '_' || Character.isLetterOrDigit(c)); ++n) {
        }
        if (n == 0) {
            return string2;
        }
        String string4 = string3.substring(0, n);
        if ("SET".equals(string4) || ParserUtil.isKeyword(string4)) {
            return string2;
        }
        if (bl) {
            sentence.addAlias(string4, sentence.getLastTable());
        }
        if ((hashMap = sentence.getAliases()) != null && hashMap.containsKey(string4) || sentence.getLastTable() == null) {
            if (bl && string2.length() == string4.length()) {
                return string2;
            }
            if ((string2 = string2.substring(string4.length())).length() == 0) {
                sentence.add(string4 + ".", ".", 0);
            }
            return string2;
        }
        HashSet<DbTableOrView> hashSet = sentence.getTables();
        if (hashSet != null) {
            String string5 = null;
            for (DbTableOrView dbTableOrView : hashSet) {
                String string6 = StringUtils.toUpperEnglish(dbTableOrView.getName());
                if (string4.startsWith(string6) && (string5 == null || string6.length() > string5.length())) {
                    sentence.setLastMatchedTable(dbTableOrView);
                    string5 = string6;
                    continue;
                }
                if (string2.length() != 0 && !string6.startsWith(string4)) continue;
                sentence.add(string6 + ".", string6.substring(string2.length()) + ".", 0);
            }
            if (string5 != null) {
                if ((string2 = string2.substring(string5.length())).length() == 0) {
                    sentence.add(string4 + ".", ".", 0);
                }
                return string2;
            }
        }
        return string2;
    }
}

