/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.shade.org.apache.http.impl.cookie;

import com.alibaba.schedulerx.shade.org.apache.http.annotation.Contract;
import com.alibaba.schedulerx.shade.org.apache.http.annotation.ThreadingBehavior;
import com.alibaba.schedulerx.shade.org.apache.http.cookie.CommonCookieAttributeHandler;
import com.alibaba.schedulerx.shade.org.apache.http.cookie.MalformedCookieException;
import com.alibaba.schedulerx.shade.org.apache.http.cookie.SetCookie;
import com.alibaba.schedulerx.shade.org.apache.http.impl.cookie.AbstractCookieAttributeHandler;
import com.alibaba.schedulerx.shade.org.apache.http.util.Args;
import java.util.Date;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class BasicMaxAgeHandler
extends AbstractCookieAttributeHandler
implements CommonCookieAttributeHandler {
    @Override
    public void parse(SetCookie cookie, String value2) throws MalformedCookieException {
        int age;
        Args.notNull(cookie, "Cookie");
        if (value2 == null) {
            throw new MalformedCookieException("Missing value for 'max-age' attribute");
        }
        try {
            age = Integer.parseInt(value2);
        }
        catch (NumberFormatException e) {
            throw new MalformedCookieException("Invalid 'max-age' attribute: " + value2);
        }
        if (age < 0) {
            throw new MalformedCookieException("Negative 'max-age' attribute: " + value2);
        }
        cookie.setExpiryDate(new Date(System.currentTimeMillis() + (long)age * 1000L));
    }

    @Override
    public String getAttributeName() {
        return "max-age";
    }
}

