/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.shade.org.apache.commons.configuration.tree;

import com.alibaba.schedulerx.shade.org.apache.commons.configuration.tree.ConfigurationNode;
import com.alibaba.schedulerx.shade.org.apache.commons.configuration.tree.NodeCombiner;
import com.alibaba.schedulerx.shade.org.apache.commons.configuration.tree.ViewNode;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MergeCombiner
extends NodeCombiner {
    @Override
    public ConfigurationNode combine(ConfigurationNode node1, ConfigurationNode node2) {
        ViewNode result2 = this.createViewNode();
        result2.setName(node1.getName());
        result2.setValue(node1.getValue());
        this.addAttributes(result2, node1, node2);
        LinkedList<ConfigurationNode> children2 = new LinkedList<ConfigurationNode>(node2.getChildren());
        for (ConfigurationNode child1 : node1.getChildren()) {
            ConfigurationNode child2 = this.canCombine(node1, node2, child1, children2);
            if (child2 != null) {
                result2.addChild(this.combine(child1, child2));
                children2.remove(child2);
                continue;
            }
            result2.addChild(child1);
        }
        for (ConfigurationNode c : children2) {
            result2.addChild(c);
        }
        return result2;
    }

    protected void addAttributes(ViewNode result2, ConfigurationNode node1, ConfigurationNode node2) {
        result2.appendAttributes(node1);
        for (ConfigurationNode attr : node2.getAttributes()) {
            if (node1.getAttributeCount(attr.getName()) != 0) continue;
            result2.addAttribute(attr);
        }
    }

    protected ConfigurationNode canCombine(ConfigurationNode node1, ConfigurationNode node2, ConfigurationNode child, List<ConfigurationNode> children2) {
        List<ConfigurationNode> attrs1 = child.getAttributes();
        ArrayList<ConfigurationNode> nodes = new ArrayList<ConfigurationNode>();
        List<ConfigurationNode> children = node2.getChildren(child.getName());
        for (ConfigurationNode node : children) {
            for (ConfigurationNode attr1 : attrs1) {
                List<ConfigurationNode> list2 = node.getAttributes(attr1.getName());
                if (list2.size() != 1 || attr1.getValue().equals(list2.get(0).getValue())) continue;
                node = null;
                break;
            }
            if (node == null) continue;
            nodes.add(node);
        }
        if (nodes.size() == 1) {
            return (ConfigurationNode)nodes.get(0);
        }
        if (nodes.size() > 1 && !this.isListNode(child)) {
            Iterator iter2 = nodes.iterator();
            while (iter2.hasNext()) {
                children2.remove(iter2.next());
            }
        }
        return null;
    }
}

