/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.shade.net.sf.json.util;

import com.alibaba.schedulerx.shade.net.sf.ezmorph.MorphUtils;
import com.alibaba.schedulerx.shade.net.sf.ezmorph.MorpherRegistry;
import com.alibaba.schedulerx.shade.net.sf.ezmorph.bean.MorphDynaBean;
import com.alibaba.schedulerx.shade.net.sf.ezmorph.bean.MorphDynaClass;
import com.alibaba.schedulerx.shade.net.sf.json.JSON;
import com.alibaba.schedulerx.shade.net.sf.json.JSONArray;
import com.alibaba.schedulerx.shade.net.sf.json.JSONException;
import com.alibaba.schedulerx.shade.net.sf.json.JSONFunction;
import com.alibaba.schedulerx.shade.net.sf.json.JSONNull;
import com.alibaba.schedulerx.shade.net.sf.json.JSONObject;
import com.alibaba.schedulerx.shade.net.sf.json.JSONString;
import com.alibaba.schedulerx.shade.net.sf.json.JsonConfig;
import com.alibaba.schedulerx.shade.net.sf.json.regexp.RegexpUtils;
import com.aliyun.log.thirdparty.org.apache.commons.beanutils.DynaBean;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public final class JSONUtils {
    public static final String DOUBLE_QUOTE = "\"";
    public static final String SINGLE_QUOTE = "'";
    private static final String FUNCTION_BODY_PATTERN = "^function[ ]?\\(.*?\\)[ \n\t]*\\{(.*?)\\}$";
    private static final String FUNCTION_HEADER_PATTERN = "^function[ ]?\\(.*?\\)$";
    private static final String FUNCTION_PARAMS_PATTERN = "^function[ ]?\\((.*?)\\).*";
    private static final String FUNCTION_PATTERN = "^function[ ]?\\(.*?\\)[ \n\t]*\\{.*?\\}$";
    private static final String FUNCTION_PREFIX = "function";
    private static final MorpherRegistry morpherRegistry = new MorpherRegistry();
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$util$List;
    static /* synthetic */ Class class$net$sf$json$JSONFunction;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$math$BigInteger;
    static /* synthetic */ Class class$java$math$BigDecimal;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$util$Collection;
    static /* synthetic */ Class class$net$sf$json$JSONArray;
    static /* synthetic */ Class class$java$lang$Number;
    static /* synthetic */ Class class$java$lang$Character;

    public static String convertToJavaIdentifier(String key) {
        return JSONUtils.convertToJavaIdentifier(key, new JsonConfig());
    }

    public static String convertToJavaIdentifier(String key, JsonConfig jsonConfig) {
        try {
            return jsonConfig.getJavaIdentifierTransformer().transformToJavaIdentifier(key);
        }
        catch (JSONException jsone) {
            throw jsone;
        }
        catch (Exception e) {
            throw new JSONException(e);
        }
    }

    public static String doubleToString(double d) {
        if (Double.isInfinite(d) || Double.isNaN(d)) {
            return "null";
        }
        String s2 = Double.toString(d);
        if (s2.indexOf(46) > 0 && s2.indexOf(101) < 0 && s2.indexOf(69) < 0) {
            while (s2.endsWith("0")) {
                s2 = s2.substring(0, s2.length() - 1);
            }
            if (s2.endsWith(".")) {
                s2 = s2.substring(0, s2.length() - 1);
            }
        }
        return s2;
    }

    public static String getFunctionBody(String function) {
        return RegexpUtils.getMatcher(FUNCTION_BODY_PATTERN, true).getGroupIfMatches(function, 1);
    }

    public static String getFunctionParams(String function) {
        return RegexpUtils.getMatcher(FUNCTION_PARAMS_PATTERN, true).getGroupIfMatches(function, 1);
    }

    public static Class getInnerComponentType(Class type) {
        if (!type.isArray()) {
            return type;
        }
        return JSONUtils.getInnerComponentType(type.getComponentType());
    }

    public static MorpherRegistry getMorpherRegistry() {
        return morpherRegistry;
    }

    public static Map getProperties(JSONObject jsonObject) {
        HashMap<String, Class> properties = new HashMap<String, Class>();
        Iterator keys = jsonObject.keys();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            properties.put(key, JSONUtils.getTypeClass(jsonObject.get(key)));
        }
        return properties;
    }

    public static Class getTypeClass(Object obj) {
        if (JSONUtils.isNull(obj)) {
            return class$java$lang$Object == null ? (class$java$lang$Object = JSONUtils.class$("java.lang.Object")) : class$java$lang$Object;
        }
        if (JSONUtils.isArray(obj)) {
            return class$java$util$List == null ? (class$java$util$List = JSONUtils.class$("java.util.List")) : class$java$util$List;
        }
        if (JSONUtils.isFunction(obj)) {
            return class$net$sf$json$JSONFunction == null ? (class$net$sf$json$JSONFunction = JSONUtils.class$("com.alibaba.schedulerx.shade.net.sf.json.JSONFunction")) : class$net$sf$json$JSONFunction;
        }
        if (JSONUtils.isBoolean(obj)) {
            return class$java$lang$Boolean == null ? (class$java$lang$Boolean = JSONUtils.class$("java.lang.Boolean")) : class$java$lang$Boolean;
        }
        if (JSONUtils.isNumber(obj)) {
            Number n = (Number)obj;
            if (JSONUtils.isInteger(n)) {
                return class$java$lang$Integer == null ? (class$java$lang$Integer = JSONUtils.class$("java.lang.Integer")) : class$java$lang$Integer;
            }
            if (JSONUtils.isLong(n)) {
                return class$java$lang$Long == null ? (class$java$lang$Long = JSONUtils.class$("java.lang.Long")) : class$java$lang$Long;
            }
            if (JSONUtils.isFloat(n)) {
                return class$java$lang$Float == null ? (class$java$lang$Float = JSONUtils.class$("java.lang.Float")) : class$java$lang$Float;
            }
            if (JSONUtils.isBigInteger(n)) {
                return class$java$math$BigInteger == null ? (class$java$math$BigInteger = JSONUtils.class$("java.math.BigInteger")) : class$java$math$BigInteger;
            }
            if (JSONUtils.isBigDecimal(n)) {
                return class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = JSONUtils.class$("java.math.BigDecimal")) : class$java$math$BigDecimal;
            }
            if (JSONUtils.isDouble(n)) {
                return class$java$lang$Double == null ? (class$java$lang$Double = JSONUtils.class$("java.lang.Double")) : class$java$lang$Double;
            }
            throw new JSONException("Unsupported type");
        }
        if (JSONUtils.isString(obj)) {
            return class$java$lang$String == null ? (class$java$lang$String = JSONUtils.class$("java.lang.String")) : class$java$lang$String;
        }
        if (JSONUtils.isObject(obj)) {
            return class$java$lang$Object == null ? (class$java$lang$Object = JSONUtils.class$("java.lang.Object")) : class$java$lang$Object;
        }
        throw new JSONException("Unsupported type");
    }

    public static int hashCode(Object value2) {
        if (value2 == null) {
            return JSONNull.getInstance().hashCode();
        }
        if (value2 instanceof JSON || value2 instanceof String || value2 instanceof JSONFunction) {
            return value2.hashCode();
        }
        return String.valueOf(value2).hashCode();
    }

    public static boolean isArray(Class clazz) {
        return clazz != null && (clazz.isArray() || (class$java$util$Collection == null ? (class$java$util$Collection = JSONUtils.class$("java.util.Collection")) : class$java$util$Collection).isAssignableFrom(clazz) || (class$net$sf$json$JSONArray == null ? (class$net$sf$json$JSONArray = JSONUtils.class$("com.alibaba.schedulerx.shade.net.sf.json.JSONArray")) : class$net$sf$json$JSONArray).isAssignableFrom(clazz));
    }

    public static boolean isArray(Object obj) {
        return obj != null && obj.getClass().isArray() || obj instanceof Collection || obj instanceof JSONArray;
    }

    public static boolean isBoolean(Class clazz) {
        return clazz != null && (Boolean.TYPE.isAssignableFrom(clazz) || (class$java$lang$Boolean == null ? (class$java$lang$Boolean = JSONUtils.class$("java.lang.Boolean")) : class$java$lang$Boolean).isAssignableFrom(clazz));
    }

    public static boolean isBoolean(Object obj) {
        return obj instanceof Boolean || obj != null && obj.getClass() == Boolean.TYPE;
    }

    public static boolean isDouble(Class clazz) {
        return clazz != null && (Double.TYPE.isAssignableFrom(clazz) || (class$java$lang$Double == null ? (class$java$lang$Double = JSONUtils.class$("java.lang.Double")) : class$java$lang$Double).isAssignableFrom(clazz));
    }

    public static boolean isFunction(Object obj) {
        if (obj instanceof String) {
            String str = (String)obj;
            return str.startsWith(FUNCTION_PREFIX) && RegexpUtils.getMatcher(FUNCTION_PATTERN, true).matches(str);
        }
        return obj instanceof JSONFunction;
    }

    public static boolean isFunctionHeader(Object obj) {
        if (obj instanceof String) {
            String str = (String)obj;
            return str.startsWith(FUNCTION_PREFIX) && RegexpUtils.getMatcher(FUNCTION_HEADER_PATTERN, true).matches(str);
        }
        return false;
    }

    public static boolean isJavaIdentifier(String str) {
        if (str.length() == 0 || !Character.isJavaIdentifierStart(str.charAt(0))) {
            return false;
        }
        for (int i = 1; i < str.length(); ++i) {
            if (Character.isJavaIdentifierPart(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isNull(Object obj) {
        if (obj instanceof JSONObject) {
            return ((JSONObject)obj).isNullObject();
        }
        return JSONNull.getInstance().equals(obj);
    }

    public static boolean isNumber(Class clazz) {
        return clazz != null && (Byte.TYPE.isAssignableFrom(clazz) || Short.TYPE.isAssignableFrom(clazz) || Integer.TYPE.isAssignableFrom(clazz) || Long.TYPE.isAssignableFrom(clazz) || Float.TYPE.isAssignableFrom(clazz) || Double.TYPE.isAssignableFrom(clazz) || (class$java$lang$Number == null ? (class$java$lang$Number = JSONUtils.class$("java.lang.Number")) : class$java$lang$Number).isAssignableFrom(clazz));
    }

    public static boolean isNumber(Object obj) {
        if (obj != null && obj.getClass() == Byte.TYPE || obj != null && obj.getClass() == Short.TYPE || obj != null && obj.getClass() == Integer.TYPE || obj != null && obj.getClass() == Long.TYPE || obj != null && obj.getClass() == Float.TYPE || obj != null && obj.getClass() == Double.TYPE) {
            return true;
        }
        return obj instanceof Number;
    }

    public static boolean isObject(Object obj) {
        return !JSONUtils.isNumber(obj) && !JSONUtils.isString(obj) && !JSONUtils.isBoolean(obj) && !JSONUtils.isArray(obj) && !JSONUtils.isFunction(obj) || JSONUtils.isNull(obj);
    }

    public static boolean isString(Class clazz) {
        return clazz != null && ((class$java$lang$String == null ? (class$java$lang$String = JSONUtils.class$("java.lang.String")) : class$java$lang$String).isAssignableFrom(clazz) || Character.TYPE.isAssignableFrom(clazz) || (class$java$lang$Character == null ? (class$java$lang$Character = JSONUtils.class$("java.lang.Character")) : class$java$lang$Character).isAssignableFrom(clazz));
    }

    public static boolean isString(Object obj) {
        return obj instanceof String || obj instanceof Character || obj != null && (obj.getClass() == Character.TYPE || (class$java$lang$String == null ? (class$java$lang$String = JSONUtils.class$("java.lang.String")) : class$java$lang$String).isAssignableFrom(obj.getClass()));
    }

    public static boolean mayBeJSON(String string2) {
        return string2 != null && ("null".equals(string2) || string2.startsWith("[") && string2.endsWith("]") || string2.startsWith("{") && string2.endsWith("}"));
    }

    public static DynaBean newDynaBean(JSONObject jsonObject) {
        return JSONUtils.newDynaBean(jsonObject, new JsonConfig());
    }

    public static DynaBean newDynaBean(JSONObject jsonObject, JsonConfig jsonConfig) {
        Map props2 = JSONUtils.getProperties(jsonObject);
        Iterator entries = props2.entrySet().iterator();
        while (entries.hasNext()) {
            String parsedKey;
            Map.Entry entry = entries.next();
            String key = (String)entry.getKey();
            if (JSONUtils.isJavaIdentifier(key) || (parsedKey = JSONUtils.convertToJavaIdentifier(key, jsonConfig)).compareTo(key) == 0) continue;
            props2.put(parsedKey, props2.remove(key));
        }
        MorphDynaClass dynaClass = new MorphDynaClass(props2);
        MorphDynaBean dynaBean = null;
        try {
            dynaBean = (MorphDynaBean)dynaClass.newInstance();
            dynaBean.setDynaBeanClass(dynaClass);
        }
        catch (Exception e) {
            throw new JSONException(e);
        }
        return dynaBean;
    }

    public static String numberToString(Number n) {
        if (n == null) {
            throw new JSONException("Null pointer");
        }
        JSONUtils.testValidity(n);
        String s2 = n.toString();
        if (s2.indexOf(46) > 0 && s2.indexOf(101) < 0 && s2.indexOf(69) < 0) {
            while (s2.endsWith("0")) {
                s2 = s2.substring(0, s2.length() - 1);
            }
            if (s2.endsWith(".")) {
                s2 = s2.substring(0, s2.length() - 1);
            }
        }
        return s2;
    }

    public static String quote(String string2) {
        if (JSONUtils.isFunction(string2)) {
            return string2;
        }
        if (string2 == null || string2.length() == 0) {
            return "\"\"";
        }
        char c = '\u0000';
        int len2 = string2.length();
        StringBuffer sb = new StringBuffer(len2 * 2);
        char[] chars = string2.toCharArray();
        char[] buffer = new char[1030];
        int bufferIndex = 0;
        sb.append('\"');
        block11: for (int i = 0; i < len2; ++i) {
            if (bufferIndex > 1024) {
                sb.append(buffer, 0, bufferIndex);
                bufferIndex = 0;
            }
            char b = c;
            c = chars[i];
            switch (c) {
                case '\"': 
                case '\\': {
                    buffer[bufferIndex++] = 92;
                    buffer[bufferIndex++] = c;
                    continue block11;
                }
                case '/': {
                    if (b == '<') {
                        buffer[bufferIndex++] = 92;
                    }
                    buffer[bufferIndex++] = c;
                    continue block11;
                }
                default: {
                    if (c < ' ') {
                        switch (c) {
                            case '\b': {
                                buffer[bufferIndex++] = 92;
                                buffer[bufferIndex++] = 98;
                                continue block11;
                            }
                            case '\t': {
                                buffer[bufferIndex++] = 92;
                                buffer[bufferIndex++] = 116;
                                continue block11;
                            }
                            case '\n': {
                                buffer[bufferIndex++] = 92;
                                buffer[bufferIndex++] = 110;
                                continue block11;
                            }
                            case '\f': {
                                buffer[bufferIndex++] = 92;
                                buffer[bufferIndex++] = 102;
                                continue block11;
                            }
                            case '\r': {
                                buffer[bufferIndex++] = 92;
                                buffer[bufferIndex++] = 114;
                                continue block11;
                            }
                        }
                        String t = "000" + Integer.toHexString(c);
                        int tLength = t.length();
                        buffer[bufferIndex++] = 92;
                        buffer[bufferIndex++] = 117;
                        buffer[bufferIndex++] = t.charAt(tLength - 4);
                        buffer[bufferIndex++] = t.charAt(tLength - 3);
                        buffer[bufferIndex++] = t.charAt(tLength - 2);
                        buffer[bufferIndex++] = t.charAt(tLength - 1);
                        continue block11;
                    }
                    buffer[bufferIndex++] = c;
                }
            }
        }
        sb.append(buffer, 0, bufferIndex);
        sb.append('\"');
        return sb.toString();
    }

    public static String stripQuotes(String input2) {
        if (input2.length() < 2) {
            return input2;
        }
        if (input2.startsWith(SINGLE_QUOTE) && input2.endsWith(SINGLE_QUOTE)) {
            return input2.substring(1, input2.length() - 1);
        }
        if (input2.startsWith(DOUBLE_QUOTE) && input2.endsWith(DOUBLE_QUOTE)) {
            return input2.substring(1, input2.length() - 1);
        }
        return input2;
    }

    public static boolean hasQuotes(String input2) {
        if (input2 == null || input2.length() < 2) {
            return false;
        }
        return input2.startsWith(SINGLE_QUOTE) && input2.endsWith(SINGLE_QUOTE) || input2.startsWith(DOUBLE_QUOTE) && input2.endsWith(DOUBLE_QUOTE);
    }

    public static boolean isJsonKeyword(String input2, JsonConfig jsonConfig) {
        if (input2 == null) {
            return false;
        }
        return "null".equals(input2) || "true".equals(input2) || "false".equals(input2) || jsonConfig.isJavascriptCompliant() && "undefined".equals(input2);
    }

    public static void testValidity(Object o) {
        if (o != null) {
            if (o instanceof Double) {
                if (((Double)o).isInfinite() || ((Double)o).isNaN()) {
                    throw new JSONException("JSON does not allow non-finite numbers");
                }
            } else if (o instanceof Float) {
                if (((Float)o).isInfinite() || ((Float)o).isNaN()) {
                    throw new JSONException("JSON does not allow non-finite numbers.");
                }
            } else if (o instanceof BigDecimal || o instanceof BigInteger) {
                return;
            }
        }
    }

    public static Number transformNumber(Number input2) {
        if (input2 instanceof Float) {
            return new Double(input2.toString());
        }
        if (input2 instanceof Short) {
            return new Integer(input2.intValue());
        }
        if (input2 instanceof Byte) {
            return new Integer(input2.intValue());
        }
        if (input2 instanceof Long) {
            Long max2 = new Long(Integer.MAX_VALUE);
            if (input2.longValue() <= max2 && input2.longValue() >= Integer.MIN_VALUE) {
                return new Integer(input2.intValue());
            }
        }
        return input2;
    }

    public static String valueToString(Object value2) {
        if (value2 == null || JSONUtils.isNull(value2)) {
            return "null";
        }
        if (value2 instanceof JSONFunction) {
            return ((JSONFunction)value2).toString();
        }
        if (value2 instanceof JSONString) {
            String o;
            try {
                o = ((JSONString)value2).toJSONString();
            }
            catch (Exception e) {
                throw new JSONException(e);
            }
            if (o instanceof String) {
                return o;
            }
            throw new JSONException("Bad value from toJSONString: " + o);
        }
        if (value2 instanceof Number) {
            return JSONUtils.numberToString((Number)value2);
        }
        if (value2 instanceof Boolean || value2 instanceof JSONObject || value2 instanceof JSONArray) {
            return value2.toString();
        }
        return JSONUtils.quote(value2.toString());
    }

    public static String valueToString(Object value2, int indentFactor, int indent) {
        if (value2 == null || JSONUtils.isNull(value2)) {
            return "null";
        }
        if (value2 instanceof JSONFunction) {
            return ((JSONFunction)value2).toString();
        }
        if (value2 instanceof JSONString) {
            return ((JSONString)value2).toJSONString();
        }
        if (value2 instanceof Number) {
            return JSONUtils.numberToString((Number)value2);
        }
        if (value2 instanceof Boolean) {
            return value2.toString();
        }
        if (value2 instanceof JSONObject) {
            return ((JSONObject)value2).toString(indentFactor, indent);
        }
        if (value2 instanceof JSONArray) {
            return ((JSONArray)value2).toString(indentFactor, indent);
        }
        return JSONUtils.quote(value2.toString());
    }

    private static boolean isBigDecimal(Number n) {
        if (n instanceof BigDecimal) {
            return true;
        }
        try {
            new BigDecimal(String.valueOf(n));
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private static boolean isBigInteger(Number n) {
        if (n instanceof BigInteger) {
            return true;
        }
        try {
            new BigInteger(String.valueOf(n));
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private static boolean isDouble(Number n) {
        if (n instanceof Double) {
            return true;
        }
        try {
            double d = Double.parseDouble(String.valueOf(n));
            return !Double.isInfinite(d);
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private static boolean isFloat(Number n) {
        if (n instanceof Float) {
            return true;
        }
        try {
            float f = Float.parseFloat(String.valueOf(n));
            return !Float.isInfinite(f);
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private static boolean isInteger(Number n) {
        if (n instanceof Integer) {
            return true;
        }
        try {
            Integer.parseInt(String.valueOf(n));
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private static boolean isLong(Number n) {
        if (n instanceof Long) {
            return true;
        }
        try {
            Long.parseLong(String.valueOf(n));
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private JSONUtils() {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        MorphUtils.registerStandardMorphers(morpherRegistry);
    }
}

