/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.shade.javassist.bytecode;

import com.alibaba.schedulerx.shade.javassist.bytecode.AnnotationDefaultAttribute;
import com.alibaba.schedulerx.shade.javassist.bytecode.AnnotationsAttribute;
import com.alibaba.schedulerx.shade.javassist.bytecode.BootstrapMethodsAttribute;
import com.alibaba.schedulerx.shade.javassist.bytecode.CodeAttribute;
import com.alibaba.schedulerx.shade.javassist.bytecode.ConstPool;
import com.alibaba.schedulerx.shade.javassist.bytecode.ConstantAttribute;
import com.alibaba.schedulerx.shade.javassist.bytecode.DeprecatedAttribute;
import com.alibaba.schedulerx.shade.javassist.bytecode.EnclosingMethodAttribute;
import com.alibaba.schedulerx.shade.javassist.bytecode.ExceptionsAttribute;
import com.alibaba.schedulerx.shade.javassist.bytecode.InnerClassesAttribute;
import com.alibaba.schedulerx.shade.javassist.bytecode.LineNumberAttribute;
import com.alibaba.schedulerx.shade.javassist.bytecode.LocalVariableAttribute;
import com.alibaba.schedulerx.shade.javassist.bytecode.LocalVariableTypeAttribute;
import com.alibaba.schedulerx.shade.javassist.bytecode.ParameterAnnotationsAttribute;
import com.alibaba.schedulerx.shade.javassist.bytecode.SignatureAttribute;
import com.alibaba.schedulerx.shade.javassist.bytecode.SourceFileAttribute;
import com.alibaba.schedulerx.shade.javassist.bytecode.StackMap;
import com.alibaba.schedulerx.shade.javassist.bytecode.StackMapTable;
import com.alibaba.schedulerx.shade.javassist.bytecode.SyntheticAttribute;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;

public class AttributeInfo {
    protected ConstPool constPool;
    int name;
    byte[] info;

    protected AttributeInfo(ConstPool cp, int attrname, byte[] attrinfo) {
        this.constPool = cp;
        this.name = attrname;
        this.info = attrinfo;
    }

    protected AttributeInfo(ConstPool cp, String attrname) {
        this(cp, attrname, (byte[])null);
    }

    public AttributeInfo(ConstPool cp, String attrname, byte[] attrinfo) {
        this(cp, cp.addUtf8Info(attrname), attrinfo);
    }

    protected AttributeInfo(ConstPool cp, int n, DataInputStream in2) throws IOException {
        this.constPool = cp;
        this.name = n;
        int len2 = in2.readInt();
        this.info = new byte[len2];
        if (len2 > 0) {
            in2.readFully(this.info);
        }
    }

    static AttributeInfo read(ConstPool cp, DataInputStream in2) throws IOException {
        int name = in2.readUnsignedShort();
        String nameStr = cp.getUtf8Info(name);
        if (nameStr.charAt(0) < 'L') {
            if (nameStr.equals("AnnotationDefault")) {
                return new AnnotationDefaultAttribute(cp, name, in2);
            }
            if (nameStr.equals("BootstrapMethods")) {
                return new BootstrapMethodsAttribute(cp, name, in2);
            }
            if (nameStr.equals("Code")) {
                return new CodeAttribute(cp, name, in2);
            }
            if (nameStr.equals("ConstantValue")) {
                return new ConstantAttribute(cp, name, in2);
            }
            if (nameStr.equals("Deprecated")) {
                return new DeprecatedAttribute(cp, name, in2);
            }
            if (nameStr.equals("EnclosingMethod")) {
                return new EnclosingMethodAttribute(cp, name, in2);
            }
            if (nameStr.equals("Exceptions")) {
                return new ExceptionsAttribute(cp, name, in2);
            }
            if (nameStr.equals("InnerClasses")) {
                return new InnerClassesAttribute(cp, name, in2);
            }
        } else {
            if (nameStr.equals("LineNumberTable")) {
                return new LineNumberAttribute(cp, name, in2);
            }
            if (nameStr.equals("LocalVariableTable")) {
                return new LocalVariableAttribute(cp, name, in2);
            }
            if (nameStr.equals("LocalVariableTypeTable")) {
                return new LocalVariableTypeAttribute(cp, name, in2);
            }
            if (nameStr.equals("RuntimeVisibleAnnotations") || nameStr.equals("RuntimeInvisibleAnnotations")) {
                return new AnnotationsAttribute(cp, name, in2);
            }
            if (nameStr.equals("RuntimeVisibleParameterAnnotations") || nameStr.equals("RuntimeInvisibleParameterAnnotations")) {
                return new ParameterAnnotationsAttribute(cp, name, in2);
            }
            if (nameStr.equals("Signature")) {
                return new SignatureAttribute(cp, name, in2);
            }
            if (nameStr.equals("SourceFile")) {
                return new SourceFileAttribute(cp, name, in2);
            }
            if (nameStr.equals("Synthetic")) {
                return new SyntheticAttribute(cp, name, in2);
            }
            if (nameStr.equals("StackMap")) {
                return new StackMap(cp, name, in2);
            }
            if (nameStr.equals("StackMapTable")) {
                return new StackMapTable(cp, name, in2);
            }
        }
        return new AttributeInfo(cp, name, in2);
    }

    public String getName() {
        return this.constPool.getUtf8Info(this.name);
    }

    public ConstPool getConstPool() {
        return this.constPool;
    }

    public int length() {
        return this.info.length + 6;
    }

    public byte[] get() {
        return this.info;
    }

    public void set(byte[] newinfo) {
        this.info = newinfo;
    }

    public AttributeInfo copy(ConstPool newCp, Map classnames) {
        int s2 = this.info.length;
        byte[] srcInfo = this.info;
        byte[] newInfo = new byte[s2];
        for (int i = 0; i < s2; ++i) {
            newInfo[i] = srcInfo[i];
        }
        return new AttributeInfo(newCp, this.getName(), newInfo);
    }

    void write(DataOutputStream out) throws IOException {
        out.writeShort(this.name);
        out.writeInt(this.info.length);
        if (this.info.length > 0) {
            out.write(this.info);
        }
    }

    static int getLength(ArrayList list) {
        int size2 = 0;
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            AttributeInfo attr = (AttributeInfo)list.get(i);
            size2 += attr.length();
        }
        return size2;
    }

    static AttributeInfo lookup(ArrayList list, String name) {
        if (list == null) {
            return null;
        }
        ListIterator iterator2 = list.listIterator();
        while (iterator2.hasNext()) {
            AttributeInfo ai = (AttributeInfo)iterator2.next();
            if (!ai.getName().equals(name)) continue;
            return ai;
        }
        return null;
    }

    static synchronized void remove(ArrayList list, String name) {
        if (list == null) {
            return;
        }
        ListIterator iterator2 = list.listIterator();
        while (iterator2.hasNext()) {
            AttributeInfo ai = (AttributeInfo)iterator2.next();
            if (!ai.getName().equals(name)) continue;
            iterator2.remove();
        }
    }

    static void writeAll(ArrayList list, DataOutputStream out) throws IOException {
        if (list == null) {
            return;
        }
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            AttributeInfo attr = (AttributeInfo)list.get(i);
            attr.write(out);
        }
    }

    static ArrayList copyAll(ArrayList list, ConstPool cp) {
        if (list == null) {
            return null;
        }
        ArrayList<AttributeInfo> newList = new ArrayList<AttributeInfo>();
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            AttributeInfo attr = (AttributeInfo)list.get(i);
            newList.add(attr.copy(cp, null));
        }
        return newList;
    }

    void renameClass(String oldname, String newname) {
    }

    void renameClass(Map classnames) {
    }

    static void renameClass(List attributes, String oldname, String newname) {
        for (AttributeInfo ai : attributes) {
            ai.renameClass(oldname, newname);
        }
    }

    static void renameClass(List attributes, Map classnames) {
        for (AttributeInfo ai : attributes) {
            ai.renameClass(classnames);
        }
    }

    void getRefClasses(Map classnames) {
    }

    static void getRefClasses(List attributes, Map classnames) {
        for (AttributeInfo ai : attributes) {
            ai.getRefClasses(classnames);
        }
    }
}

