/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.shade.hsf.hessian.io;

import com.alibaba.schedulerx.shade.hsf.hessian.io.AbstractHessianInput;
import com.alibaba.schedulerx.shade.hsf.hessian.io.AbstractMapDeserializer;
import com.alibaba.schedulerx.shade.hsf.hessian.io.IOExceptionWrapper;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;

public class MapDeserializer
extends AbstractMapDeserializer {
    private Class<?> _type;
    private Constructor<?> _ctor;

    public MapDeserializer(Class<?> type) {
        if (type == null) {
            type = HashMap.class;
        }
        this._type = type;
        Constructor<?>[] ctors = type.getConstructors();
        for (int i = 0; i < ctors.length; ++i) {
            if (ctors[i].getParameterTypes().length != 0) continue;
            this._ctor = ctors[i];
        }
        if (this._ctor == null) {
            try {
                this._ctor = HashMap.class.getConstructor(new Class[0]);
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        }
    }

    @Override
    public Class<?> getType() {
        if (this._type != null) {
            return this._type;
        }
        return HashMap.class;
    }

    @Override
    public Object readMap(AbstractHessianInput in2) throws IOException {
        Map<Object, Object> map2;
        if (this._type == null) {
            map2 = new HashMap<Object, Object>();
        } else if (this._type.equals(Map.class)) {
            map2 = new HashMap();
        } else if (this._type.equals(SortedMap.class)) {
            map2 = new TreeMap();
        } else {
            try {
                map2 = (Map)this._ctor.newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new IOExceptionWrapper(e);
            }
        }
        in2.addRef(map2);
        while (!in2.isEnd()) {
            map2.put(in2.readObject(), in2.readObject());
        }
        in2.readEnd();
        return map2;
    }

    @Override
    public Object readObject(AbstractHessianInput in2, Object[] fields) throws IOException {
        String[] fieldNames = (String[])fields;
        Map map2 = this.createMap();
        int ref = in2.addRef(map2);
        for (int i = 0; i < fieldNames.length; ++i) {
            String name = fieldNames[i];
            map2.put(name, in2.readObject());
        }
        return map2;
    }

    private Map createMap() throws IOException {
        if (this._type == null) {
            return new HashMap();
        }
        if (this._type.equals(Map.class)) {
            return new HashMap();
        }
        if (this._type.equals(SortedMap.class)) {
            return new TreeMap();
        }
        try {
            return (Map)this._ctor.newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new IOExceptionWrapper(e);
        }
    }
}

