/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.shade.com.google.gson.internal.bind;

import com.alibaba.schedulerx.shade.com.google.gson.Gson;
import com.alibaba.schedulerx.shade.com.google.gson.JsonSyntaxException;
import com.alibaba.schedulerx.shade.com.google.gson.TypeAdapter;
import com.alibaba.schedulerx.shade.com.google.gson.TypeAdapterFactory;
import com.alibaba.schedulerx.shade.com.google.gson.reflect.TypeToken;
import com.alibaba.schedulerx.shade.com.google.gson.stream.JsonReader;
import com.alibaba.schedulerx.shade.com.google.gson.stream.JsonToken;
import com.alibaba.schedulerx.shade.com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.sql.Time;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public final class TimeTypeAdapter
extends TypeAdapter<Time> {
    public static final TypeAdapterFactory FACTORY = new TypeAdapterFactory(){

        @Override
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> typeToken) {
            return typeToken.getRawType() == Time.class ? new TimeTypeAdapter() : null;
        }
    };
    private final DateFormat format = new SimpleDateFormat("hh:mm:ss a");

    @Override
    public synchronized Time read(JsonReader in2) throws IOException {
        if (in2.peek() == JsonToken.NULL) {
            in2.nextNull();
            return null;
        }
        try {
            Date date = this.format.parse(in2.nextString());
            return new Time(date.getTime());
        }
        catch (ParseException e) {
            throw new JsonSyntaxException(e);
        }
    }

    @Override
    public synchronized void write(JsonWriter out, Time value2) throws IOException {
        out.value(value2 == null ? null : this.format.format(value2));
    }
}

