/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.worker.util;

import com.alibaba.schedulerx.worker.log.LogFactory;
import com.alibaba.schedulerx.worker.log.Logger;
import java.io.File;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;

public class SystemManagementUtil {
    private static final Logger LOGGER = LogFactory.getLogger(SystemManagementUtil.class);

    public static String getPid() {
        String name = ManagementFactory.getRuntimeMXBean().getName();
        return name.split("@")[0];
    }

    public static float getUsedMemoryPercent() {
        MemoryMXBean memoryMXBean = ManagementFactory.getMemoryMXBean();
        MemoryUsage memoryUsage = memoryMXBean.getHeapMemoryUsage();
        long totalMemorySize = memoryUsage.getMax();
        long usedMemorySize = memoryUsage.getUsed();
        float usedRatio = (float)usedMemorySize / (float)totalMemorySize;
        LOGGER.debug("totalMemorySize:{} MB, usedMemorySize:{} MB, used rate:{}", totalMemorySize / 0x100000L, usedMemorySize / 0x100000L, Float.valueOf(usedRatio));
        return usedRatio;
    }

    public static float getUserDiskSpacePercent() {
        File[] files = File.listRoots();
        if (files == null) {
            return 0.0f;
        }
        long freeSpace = 0L;
        long totalSpace = 0L;
        float usedRation = 0.0f;
        for (File file : files) {
            freeSpace += file.getFreeSpace();
            totalSpace += file.getTotalSpace();
        }
        long usedSpace = totalSpace - freeSpace;
        if (totalSpace != 0L) {
            usedRation = (float)usedSpace / (float)totalSpace;
        }
        LOGGER.debug("totalSpace:{} MB, usedSpace:{} MB, used rate:{}", totalSpace / 0x100000L, usedSpace / 0x100000L, Float.valueOf(usedRation));
        return usedRation;
    }

    public static void main(String[] args) {
        long start = System.currentTimeMillis();
        System.out.println("pid=" + SystemManagementUtil.getPid() + ", cost=" + (System.currentTimeMillis() - start) + "ms");
        System.out.println(SystemManagementUtil.getUserDiskSpacePercent());
    }
}

