/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.worker.processor.demo;

import com.alibaba.schedulerx.shade.com.google.common.collect.Lists;
import com.alibaba.schedulerx.worker.domain.JobContext;
import com.alibaba.schedulerx.worker.processor.MapReduceJobProcessor;
import com.alibaba.schedulerx.worker.processor.ProcessResult;
import java.util.ArrayList;
import org.springframework.stereotype.Component;

@Component
public class TestMapReduceJobProcessor
extends MapReduceJobProcessor {
    @Override
    public ProcessResult process(JobContext context) throws Exception {
        String taskName = context.getTaskName();
        int dispatchNum = 10;
        if (context.getJobParameters() != null) {
            dispatchNum = Integer.valueOf(context.getJobParameters());
        }
        if (this.isRootTask(context)) {
            System.out.println("start root task");
            ArrayList<String> msgList = Lists.newArrayList();
            for (int i = 0; i <= dispatchNum; ++i) {
                msgList.add("msg_" + i);
            }
            this.map(msgList, "Level1Dispatch");
            return new ProcessResult(true, "root task result");
        }
        if (taskName.equals("Level1Dispatch")) {
            String task = (String)context.getTask();
            System.out.println("taskId:" + context.getTaskId() + ", task:" + task);
            Thread.sleep(2000L);
            return new ProcessResult(true, task);
        }
        return new ProcessResult(false);
    }

    @Override
    public ProcessResult reduce(JobContext context) throws Exception {
        return new ProcessResult(true, "TestMapReduceJobProcessor.reduce");
    }
}

