/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.worker.processor;

import com.alibaba.schedulerx.shade.com.google.common.io.Files;
import com.alibaba.schedulerx.shade.org.apache.commons.lang.StringUtils;
import com.alibaba.schedulerx.worker.domain.JobContext;
import com.alibaba.schedulerx.worker.processor.ShellProcessor;
import java.io.File;
import java.io.IOException;

public class GoProcessor
extends ShellProcessor {
    public static final String GO_SCRIPT_PREFIX = System.getProperties().getProperty("user.home") + "/script/go/";
    private String fileName;

    @Override
    public void preProcess(JobContext context) throws Exception {
        super.preProcess(context);
        File dir = new File(GO_SCRIPT_PREFIX);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        this.fileName = this.writeGoScript(context);
    }

    @Override
    protected String[] getContent(JobContext context) {
        String[] parameters = StringUtils.isNotEmpty(context.getShardingParameter()) ? new String[]{String.valueOf(context.getShardingId()), context.getShardingParameter()} : (StringUtils.isNotEmpty(context.getInstanceParameters()) ? context.getInstanceParameters().trim().split(" ") : context.getJobParameters().trim().split(" "));
        String[] contents = new String[3 + parameters.length];
        contents[0] = "go";
        contents[1] = "run";
        contents[2] = this.fileName;
        for (int i = 0; i < parameters.length; ++i) {
            contents[3 + i] = parameters[i];
        }
        return contents;
    }

    private String writeGoScript(JobContext context) throws IOException {
        long jobId = context.getJobId();
        String fileName = GO_SCRIPT_PREFIX + "go_" + jobId + ".go";
        Files.write(context.getContent().getBytes(), new File(fileName));
        return fileName;
    }
}

