/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.worker.master.handler;

import com.alibaba.schedulerx.common.domain.InstanceStatus;
import com.alibaba.schedulerx.common.domain.JobInstanceInfo;
import com.alibaba.schedulerx.common.util.IdUtil;
import com.alibaba.schedulerx.protocol.Worker;
import com.alibaba.schedulerx.shade.org.apache.commons.lang.StringUtils;
import com.alibaba.schedulerx.worker.SchedulerxWorker;
import com.alibaba.schedulerx.worker.log.LogFactory;
import com.alibaba.schedulerx.worker.log.Logger;
import com.alibaba.schedulerx.worker.logcollector.ClientLoggerMessage;
import com.alibaba.schedulerx.worker.logcollector.LogCollector;
import com.alibaba.schedulerx.worker.logcollector.LogCollectorFactory;
import com.alibaba.schedulerx.worker.master.TaskMaster;
import com.alibaba.schedulerx.worker.master.handler.UpdateInstanceStatusHandler;
import com.alibaba.schedulerx.worker.processor.ProcessResult;

public class CommonUpdateInstanceStatusHandler
extends UpdateInstanceStatusHandler {
    private LogCollector logCollector = LogCollectorFactory.get();
    private static final Logger LOGGER = LogFactory.getLogger(CommonUpdateInstanceStatusHandler.class);

    CommonUpdateInstanceStatusHandler(TaskMaster taskMaster, JobInstanceInfo jobInstanceInfo) {
        super(taskMaster, jobInstanceInfo);
    }

    @Override
    public void handle(long serialNum, InstanceStatus instanceStatus, String result) throws Exception {
        String uniqueId = IdUtil.getUniqueIdWithoutTask(this.jobInstanceInfo.getJobId(), this.jobInstanceInfo.getJobInstanceId());
        if (!this.taskMaster.getInstanceStatus().equals((Object)instanceStatus)) {
            this.taskMaster.setInstanceStatus(instanceStatus);
            if (instanceStatus.isFinish()) {
                String progress;
                ProcessResult postResult = this.taskMaster.postFinish(this.jobInstanceInfo.getJobInstanceId());
                if (postResult != null) {
                    if (instanceStatus.equals((Object)InstanceStatus.SUCCESS) && postResult.getStatus().equals((Object)InstanceStatus.FAILED)) {
                        instanceStatus = InstanceStatus.FAILED;
                    }
                    if (postResult.getResult() != null) {
                        result = postResult.getResult();
                    }
                }
                Worker.WorkerReportJobInstanceStatusRequest.Builder builder = Worker.WorkerReportJobInstanceStatusRequest.newBuilder().setJobId(this.jobInstanceInfo.getJobId()).setJobInstanceId(this.jobInstanceInfo.getJobInstanceId()).setStatus(instanceStatus.getValue()).setGroupId(this.jobInstanceInfo.getGroupId());
                if (result != null) {
                    builder.setResult(result);
                }
                if (!StringUtils.isEmpty(progress = this.taskMaster.getJobInstanceProgress())) {
                    builder.setProgress(progress);
                }
                SchedulerxWorker.AtLeastDeliveryRoutingActor.tell((Object)builder.build(), null);
                LOGGER.info("report jobInstance={}, status={} to AtLeastDeliveryRoutingActor", new Object[]{this.jobInstanceInfo.getJobInstanceId(), instanceStatus});
                this.taskMaster.destroyContainerPool();
                this.masterPool.get(this.jobInstanceInfo.getJobInstanceId()).stop();
                this.masterPool.remove(this.jobInstanceInfo.getJobInstanceId());
                this.logCollector.collect(uniqueId, ClientLoggerMessage.appendMessage("[TaskMaster-updateTaskStatus]instance finish status is ", instanceStatus.getEnDesc()));
                LOGGER.info("uniqueId: {} is finished, remove from MasterPool.", uniqueId);
            }
        }
    }
}

