/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.worker.batch;

import com.alibaba.schedulerx.protocol.Worker;
import com.alibaba.schedulerx.worker.batch.BaseReqHandler;
import com.alibaba.schedulerx.worker.batch.ReqQueue;
import com.alibaba.schedulerx.worker.log.LogFactory;
import com.alibaba.schedulerx.worker.log.Logger;
import com.alibaba.schedulerx.worker.master.MapTaskMaster;
import java.util.List;

public class TMStatusReqHandler<T>
extends BaseReqHandler<T> {
    private static final Logger LOGGER = LogFactory.getLogger(TMStatusReqHandler.class);

    @Override
    public void process(long jobInstanceId, List<T> reqs, String workerAddr) {
        List<Worker.ContainerReportTaskStatusRequest> statues = reqs;
        long startTime = System.currentTimeMillis();
        ((MapTaskMaster)this.taskMasterPool.get(jobInstanceId)).batchUpdateTaskStatues(statues);
        LOGGER.info("jobInstanceId={}, batch update status cost:{}ms, size:{}", jobInstanceId, System.currentTimeMillis() - startTime, statues.size());
    }

    public TMStatusReqHandler(long jobInstanceId, int coreBatchThreadNum, int maxBatchThreadNum, int batchSize, ReqQueue<T> queue) {
        super(jobInstanceId, coreBatchThreadNum, maxBatchThreadNum, batchSize, queue, "TM-Batch-Statuses-Process-Thread-", "TM-Batch-Statues-Retrieve-Thread-");
        this.defaultSleepMs = 100L;
    }

    private class BatchStatuesUpdateRunnable
    implements Runnable {
        private long jobInstanceId;
        private List<Worker.ContainerReportTaskStatusRequest> statues;

        BatchStatuesUpdateRunnable(long jobInstanceId, List<Worker.ContainerReportTaskStatusRequest> reqs) {
            this.jobInstanceId = jobInstanceId;
            this.statues = reqs;
        }

        @Override
        public void run() {
            try {
                long startTime = System.currentTimeMillis();
                ((MapTaskMaster)TMStatusReqHandler.this.taskMasterPool.get(this.jobInstanceId)).batchUpdateTaskStatues(this.statues);
                LOGGER.info("jobInstanceId={}, batch update status cost:{}ms, size:{}", this.jobInstanceId, System.currentTimeMillis() - startTime, this.statues.size());
            }
            catch (Throwable e) {
                LOGGER.error(e);
            }
            finally {
                TMStatusReqHandler.this.activeRunnableNum.decrementAndGet();
            }
        }
    }
}

