/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.shade.org.h2.value;

import com.alibaba.schedulerx.shade.org.h2.message.DbException;
import com.alibaba.schedulerx.shade.org.h2.util.MathUtils;
import com.alibaba.schedulerx.shade.org.h2.value.CompareMode;
import com.alibaba.schedulerx.shade.org.h2.value.Value;
import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.SQLException;

public class ValueDecimal
extends Value {
    public static final Object ZERO = new ValueDecimal(BigDecimal.ZERO);
    public static final Object ONE = new ValueDecimal(BigDecimal.ONE);
    static final int DEFAULT_PRECISION = 65535;
    static final int DEFAULT_SCALE = Short.MAX_VALUE;
    static final int DEFAULT_DISPLAY_SIZE = 65535;
    private static final int DIVIDE_SCALE_ADD = 25;
    private static final int BIG_DECIMAL_SCALE_MAX = 100000;
    private final BigDecimal value;
    private String valueString;
    private int precision;

    private ValueDecimal(BigDecimal bigDecimal) {
        if (bigDecimal == null) {
            throw new IllegalArgumentException("null");
        }
        if (!bigDecimal.getClass().equals(BigDecimal.class)) {
            throw DbException.get(90125, BigDecimal.class.getName(), bigDecimal.getClass().getName());
        }
        this.value = bigDecimal;
    }

    @Override
    public Value add(Value value) {
        ValueDecimal valueDecimal = (ValueDecimal)value;
        return ValueDecimal.get(this.value.add(valueDecimal.value));
    }

    @Override
    public Value subtract(Value value) {
        ValueDecimal valueDecimal = (ValueDecimal)value;
        return ValueDecimal.get(this.value.subtract(valueDecimal.value));
    }

    @Override
    public Value negate() {
        return ValueDecimal.get(this.value.negate());
    }

    @Override
    public Value multiply(Value value) {
        ValueDecimal valueDecimal = (ValueDecimal)value;
        return ValueDecimal.get(this.value.multiply(valueDecimal.value));
    }

    @Override
    public Value divide(Value value) {
        ValueDecimal valueDecimal = (ValueDecimal)value;
        if (valueDecimal.value.signum() == 0) {
            throw DbException.get(22012, this.getSQL());
        }
        BigDecimal bigDecimal = this.value.divide(valueDecimal.value, this.value.scale() + 25, 5);
        if (bigDecimal.signum() == 0) {
            bigDecimal = BigDecimal.ZERO;
        } else if (bigDecimal.scale() > 0 && !bigDecimal.unscaledValue().testBit(0)) {
            bigDecimal = bigDecimal.stripTrailingZeros();
        }
        return ValueDecimal.get(bigDecimal);
    }

    @Override
    public ValueDecimal modulus(Value value) {
        ValueDecimal valueDecimal = (ValueDecimal)value;
        if (valueDecimal.value.signum() == 0) {
            throw DbException.get(22012, this.getSQL());
        }
        BigDecimal bigDecimal = this.value.remainder(valueDecimal.value);
        return ValueDecimal.get(bigDecimal);
    }

    @Override
    public String getSQL() {
        return this.getString();
    }

    @Override
    public int getType() {
        return 6;
    }

    @Override
    protected int compareSecure(Value value, CompareMode compareMode) {
        ValueDecimal valueDecimal = (ValueDecimal)value;
        return this.value.compareTo(valueDecimal.value);
    }

    @Override
    public int getSignum() {
        return this.value.signum();
    }

    @Override
    public BigDecimal getBigDecimal() {
        return this.value;
    }

    @Override
    public String getString() {
        if (this.valueString == null) {
            String string = this.value.toPlainString();
            this.valueString = string.length() < 40 ? string : this.value.toString();
        }
        return this.valueString;
    }

    @Override
    public long getPrecision() {
        if (this.precision == 0) {
            this.precision = this.value.precision();
        }
        return this.precision;
    }

    @Override
    public boolean checkPrecision(long l) {
        if (l == 65535L) {
            return true;
        }
        return this.getPrecision() <= l;
    }

    @Override
    public int getScale() {
        return this.value.scale();
    }

    @Override
    public int hashCode() {
        return this.value.hashCode();
    }

    @Override
    public Object getObject() {
        return this.value;
    }

    @Override
    public void set(PreparedStatement preparedStatement, int n) throws SQLException {
        preparedStatement.setBigDecimal(n, this.value);
    }

    @Override
    public Value convertScale(boolean bl, int n) {
        if (this.value.scale() == n) {
            return this;
        }
        if ((bl || n >= Short.MAX_VALUE) && this.value.scale() < n) {
            return this;
        }
        BigDecimal bigDecimal = ValueDecimal.setScale(this.value, n);
        return ValueDecimal.get(bigDecimal);
    }

    @Override
    public Value convertPrecision(long l, boolean bl) {
        if (this.getPrecision() <= l) {
            return this;
        }
        if (bl) {
            return ValueDecimal.get(BigDecimal.valueOf(this.value.doubleValue()));
        }
        throw DbException.get(22003, Long.toString(l));
    }

    public static ValueDecimal get(BigDecimal bigDecimal) {
        if (BigDecimal.ZERO.equals(bigDecimal)) {
            return (ValueDecimal)ZERO;
        }
        if (BigDecimal.ONE.equals(bigDecimal)) {
            return (ValueDecimal)ONE;
        }
        return (ValueDecimal)Value.cache(new ValueDecimal(bigDecimal));
    }

    @Override
    public int getDisplaySize() {
        return MathUtils.convertLongToInt(this.getPrecision() + 2L);
    }

    @Override
    public boolean equals(Object object) {
        return object instanceof ValueDecimal && this.value.equals(((ValueDecimal)object).value);
    }

    @Override
    public int getMemory() {
        return this.value.precision() + 120;
    }

    public static BigDecimal setScale(BigDecimal bigDecimal, int n) {
        if (n > 100000 || n < -100000) {
            throw DbException.getInvalidValueException("scale", n);
        }
        return bigDecimal.setScale(n, 4);
    }
}

