/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.shade.org.h2.mvstore;

import com.alibaba.schedulerx.shade.org.h2.mvstore.DataUtils;
import java.util.Arrays;
import java.util.Iterator;

public class ConcurrentArrayList<K> {
    K[] array = new Object[0];

    public K peekFirst() {
        K[] KArray = this.array;
        return KArray.length == 0 ? null : (K)KArray[0];
    }

    public K peekLast() {
        K[] KArray = this.array;
        int n = KArray.length;
        return n == 0 ? null : (K)KArray[n - 1];
    }

    public synchronized void add(K k) {
        if (k == null) {
            throw DataUtils.newIllegalStateException(3, "adding null value to list", new Object[0]);
        }
        int n = this.array.length;
        this.array = Arrays.copyOf(this.array, n + 1);
        this.array[n] = k;
    }

    public synchronized boolean removeFirst(K k) {
        if (this.peekFirst() != k) {
            return false;
        }
        int n = this.array.length;
        Object[] objectArray = new Object[n - 1];
        System.arraycopy(this.array, 1, objectArray, 0, n - 1);
        this.array = objectArray;
        return true;
    }

    public synchronized boolean removeLast(K k) {
        if (this.peekLast() != k) {
            return false;
        }
        this.array = Arrays.copyOf(this.array, this.array.length - 1);
        return true;
    }

    public Iterator<K> iterator() {
        return new Iterator<K>(){
            K[] a;
            int index;
            {
                this.a = ConcurrentArrayList.this.array;
            }

            @Override
            public boolean hasNext() {
                return this.index < this.a.length;
            }

            @Override
            public K next() {
                return this.a[this.index++];
            }

            @Override
            public void remove() {
                throw DataUtils.newUnsupportedOperationException("remove");
            }
        };
    }
}

