/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.shade.org.h2.expression;

import com.alibaba.schedulerx.shade.org.h2.command.Command;
import com.alibaba.schedulerx.shade.org.h2.command.Parser;
import com.alibaba.schedulerx.shade.org.h2.engine.Constants;
import com.alibaba.schedulerx.shade.org.h2.engine.Database;
import com.alibaba.schedulerx.shade.org.h2.engine.Mode;
import com.alibaba.schedulerx.shade.org.h2.engine.Session;
import com.alibaba.schedulerx.shade.org.h2.expression.Expression;
import com.alibaba.schedulerx.shade.org.h2.expression.ExpressionColumn;
import com.alibaba.schedulerx.shade.org.h2.expression.ExpressionVisitor;
import com.alibaba.schedulerx.shade.org.h2.expression.FunctionCall;
import com.alibaba.schedulerx.shade.org.h2.expression.FunctionInfo;
import com.alibaba.schedulerx.shade.org.h2.expression.SequenceValue;
import com.alibaba.schedulerx.shade.org.h2.expression.TableFunction;
import com.alibaba.schedulerx.shade.org.h2.expression.ValueExpression;
import com.alibaba.schedulerx.shade.org.h2.expression.Variable;
import com.alibaba.schedulerx.shade.org.h2.message.DbException;
import com.alibaba.schedulerx.shade.org.h2.schema.Schema;
import com.alibaba.schedulerx.shade.org.h2.schema.Sequence;
import com.alibaba.schedulerx.shade.org.h2.security.BlockCipher;
import com.alibaba.schedulerx.shade.org.h2.security.CipherFactory;
import com.alibaba.schedulerx.shade.org.h2.security.SHA256;
import com.alibaba.schedulerx.shade.org.h2.store.fs.FileUtils;
import com.alibaba.schedulerx.shade.org.h2.table.Column;
import com.alibaba.schedulerx.shade.org.h2.table.ColumnResolver;
import com.alibaba.schedulerx.shade.org.h2.table.LinkSchema;
import com.alibaba.schedulerx.shade.org.h2.table.Table;
import com.alibaba.schedulerx.shade.org.h2.table.TableFilter;
import com.alibaba.schedulerx.shade.org.h2.tools.CompressTool;
import com.alibaba.schedulerx.shade.org.h2.tools.Csv;
import com.alibaba.schedulerx.shade.org.h2.util.DateTimeFunctions;
import com.alibaba.schedulerx.shade.org.h2.util.DateTimeUtils;
import com.alibaba.schedulerx.shade.org.h2.util.IOUtils;
import com.alibaba.schedulerx.shade.org.h2.util.JdbcUtils;
import com.alibaba.schedulerx.shade.org.h2.util.MathUtils;
import com.alibaba.schedulerx.shade.org.h2.util.New;
import com.alibaba.schedulerx.shade.org.h2.util.StatementBuilder;
import com.alibaba.schedulerx.shade.org.h2.util.StringUtils;
import com.alibaba.schedulerx.shade.org.h2.util.ToChar;
import com.alibaba.schedulerx.shade.org.h2.util.ToDateParser;
import com.alibaba.schedulerx.shade.org.h2.util.Utils;
import com.alibaba.schedulerx.shade.org.h2.value.DataType;
import com.alibaba.schedulerx.shade.org.h2.value.Value;
import com.alibaba.schedulerx.shade.org.h2.value.ValueArray;
import com.alibaba.schedulerx.shade.org.h2.value.ValueBoolean;
import com.alibaba.schedulerx.shade.org.h2.value.ValueBytes;
import com.alibaba.schedulerx.shade.org.h2.value.ValueDate;
import com.alibaba.schedulerx.shade.org.h2.value.ValueDouble;
import com.alibaba.schedulerx.shade.org.h2.value.ValueInt;
import com.alibaba.schedulerx.shade.org.h2.value.ValueLong;
import com.alibaba.schedulerx.shade.org.h2.value.ValueNull;
import com.alibaba.schedulerx.shade.org.h2.value.ValueResultSet;
import com.alibaba.schedulerx.shade.org.h2.value.ValueString;
import com.alibaba.schedulerx.shade.org.h2.value.ValueTime;
import com.alibaba.schedulerx.shade.org.h2.value.ValueTimestamp;
import com.alibaba.schedulerx.shade.org.h2.value.ValueTimestampTimeZone;
import com.alibaba.schedulerx.shade.org.h2.value.ValueUuid;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class Function
extends Expression
implements FunctionCall {
    public static final int ABS = 0;
    public static final int ACOS = 1;
    public static final int ASIN = 2;
    public static final int ATAN = 3;
    public static final int ATAN2 = 4;
    public static final int BITAND = 5;
    public static final int BITOR = 6;
    public static final int BITXOR = 7;
    public static final int CEILING = 8;
    public static final int COS = 9;
    public static final int COT = 10;
    public static final int DEGREES = 11;
    public static final int EXP = 12;
    public static final int FLOOR = 13;
    public static final int LOG = 14;
    public static final int LOG10 = 15;
    public static final int MOD = 16;
    public static final int PI = 17;
    public static final int POWER = 18;
    public static final int RADIANS = 19;
    public static final int RAND = 20;
    public static final int ROUND = 21;
    public static final int ROUNDMAGIC = 22;
    public static final int SIGN = 23;
    public static final int SIN = 24;
    public static final int SQRT = 25;
    public static final int TAN = 26;
    public static final int TRUNCATE = 27;
    public static final int SECURE_RAND = 28;
    public static final int HASH = 29;
    public static final int ENCRYPT = 30;
    public static final int DECRYPT = 31;
    public static final int COMPRESS = 32;
    public static final int EXPAND = 33;
    public static final int ZERO = 34;
    public static final int RANDOM_UUID = 35;
    public static final int COSH = 36;
    public static final int SINH = 37;
    public static final int TANH = 38;
    public static final int LN = 39;
    public static final int BITGET = 40;
    public static final int ASCII = 50;
    public static final int BIT_LENGTH = 51;
    public static final int CHAR = 52;
    public static final int CHAR_LENGTH = 53;
    public static final int CONCAT = 54;
    public static final int DIFFERENCE = 55;
    public static final int HEXTORAW = 56;
    public static final int INSERT = 57;
    public static final int INSTR = 58;
    public static final int LCASE = 59;
    public static final int LEFT = 60;
    public static final int LENGTH = 61;
    public static final int LOCATE = 62;
    public static final int LTRIM = 63;
    public static final int OCTET_LENGTH = 64;
    public static final int RAWTOHEX = 65;
    public static final int REPEAT = 66;
    public static final int REPLACE = 67;
    public static final int RIGHT = 68;
    public static final int RTRIM = 69;
    public static final int SOUNDEX = 70;
    public static final int SPACE = 71;
    public static final int SUBSTR = 72;
    public static final int SUBSTRING = 73;
    public static final int UCASE = 74;
    public static final int LOWER = 75;
    public static final int UPPER = 76;
    public static final int POSITION = 77;
    public static final int TRIM = 78;
    public static final int STRINGENCODE = 79;
    public static final int STRINGDECODE = 80;
    public static final int STRINGTOUTF8 = 81;
    public static final int UTF8TOSTRING = 82;
    public static final int XMLATTR = 83;
    public static final int XMLNODE = 84;
    public static final int XMLCOMMENT = 85;
    public static final int XMLCDATA = 86;
    public static final int XMLSTARTDOC = 87;
    public static final int XMLTEXT = 88;
    public static final int REGEXP_REPLACE = 89;
    public static final int RPAD = 90;
    public static final int LPAD = 91;
    public static final int CONCAT_WS = 92;
    public static final int TO_CHAR = 93;
    public static final int TRANSLATE = 94;
    public static final int ORA_HASH = 95;
    public static final int TO_DATE = 96;
    public static final int TO_TIMESTAMP = 97;
    public static final int ADD_MONTHS = 98;
    public static final int TO_TIMESTAMP_TZ = 99;
    public static final int CURDATE = 100;
    public static final int CURTIME = 101;
    public static final int DATE_ADD = 102;
    public static final int DATE_DIFF = 103;
    public static final int DAY_NAME = 104;
    public static final int DAY_OF_MONTH = 105;
    public static final int DAY_OF_WEEK = 106;
    public static final int DAY_OF_YEAR = 107;
    public static final int HOUR = 108;
    public static final int MINUTE = 109;
    public static final int MONTH = 110;
    public static final int MONTH_NAME = 111;
    public static final int NOW = 112;
    public static final int QUARTER = 113;
    public static final int SECOND = 114;
    public static final int WEEK = 115;
    public static final int YEAR = 116;
    public static final int CURRENT_DATE = 117;
    public static final int CURRENT_TIME = 118;
    public static final int CURRENT_TIMESTAMP = 119;
    public static final int EXTRACT = 120;
    public static final int FORMATDATETIME = 121;
    public static final int PARSEDATETIME = 122;
    public static final int ISO_YEAR = 123;
    public static final int ISO_WEEK = 124;
    public static final int ISO_DAY_OF_WEEK = 125;
    public static final int DATE_TRUNC = 132;
    public static final int MILLISECOND = 126;
    public static final int EPOCH = 127;
    public static final int MICROSECOND = 128;
    public static final int NANOSECOND = 129;
    public static final int TIMEZONE_HOUR = 130;
    public static final int TIMEZONE_MINUTE = 131;
    public static final int DECADE = 132;
    public static final int CENTURY = 133;
    public static final int MILLENNIUM = 134;
    public static final int DATABASE = 150;
    public static final int USER = 151;
    public static final int CURRENT_USER = 152;
    public static final int IDENTITY = 153;
    public static final int SCOPE_IDENTITY = 154;
    public static final int AUTOCOMMIT = 155;
    public static final int READONLY = 156;
    public static final int DATABASE_PATH = 157;
    public static final int LOCK_TIMEOUT = 158;
    public static final int DISK_SPACE_USED = 159;
    public static final int SIGNAL = 160;
    private static final Pattern SIGNAL_PATTERN = Pattern.compile("[0-9A-Z]{5}");
    public static final int IFNULL = 200;
    public static final int CASEWHEN = 201;
    public static final int CONVERT = 202;
    public static final int CAST = 203;
    public static final int COALESCE = 204;
    public static final int NULLIF = 205;
    public static final int CASE = 206;
    public static final int NEXTVAL = 207;
    public static final int CURRVAL = 208;
    public static final int ARRAY_GET = 209;
    public static final int CSVREAD = 210;
    public static final int CSVWRITE = 211;
    public static final int MEMORY_FREE = 212;
    public static final int MEMORY_USED = 213;
    public static final int LOCK_MODE = 214;
    public static final int SCHEMA = 215;
    public static final int SESSION_ID = 216;
    public static final int ARRAY_LENGTH = 217;
    public static final int LINK_SCHEMA = 218;
    public static final int GREATEST = 219;
    public static final int LEAST = 220;
    public static final int CANCEL_SESSION = 221;
    public static final int SET = 222;
    public static final int TABLE = 223;
    public static final int TABLE_DISTINCT = 224;
    public static final int FILE_READ = 225;
    public static final int TRANSACTION_ID = 226;
    public static final int TRUNCATE_VALUE = 227;
    public static final int NVL2 = 228;
    public static final int DECODE = 229;
    public static final int ARRAY_CONTAINS = 230;
    public static final int FILE_WRITE = 232;
    public static final int REGEXP_LIKE = 240;
    public static final int VALUES = 250;
    public static final int H2VERSION = 231;
    public static final int ROW_NUMBER = 300;
    private static final int VAR_ARGS = -1;
    private static final long PRECISION_UNKNOWN = -1L;
    private static final HashMap<String, FunctionInfo> FUNCTIONS = new HashMap();
    private static final char[] SOUNDEX_INDEX = new char[128];
    protected Expression[] args;
    private final FunctionInfo info;
    private ArrayList<Expression> varArgs;
    private int dataType;
    private int scale;
    private long precision = -1L;
    private int displaySize;
    private final Database database;

    protected Function(Database database, FunctionInfo functionInfo) {
        this.database = database;
        this.info = functionInfo;
        if (functionInfo.parameterCount == -1) {
            this.varArgs = New.arrayList();
        } else {
            this.args = new Expression[functionInfo.parameterCount];
        }
    }

    private static void addFunction(String string, int n, int n2, int n3, boolean bl, boolean bl2, boolean bl3) {
        FunctionInfo functionInfo = new FunctionInfo();
        functionInfo.name = string;
        functionInfo.type = n;
        functionInfo.parameterCount = n2;
        functionInfo.returnDataType = n3;
        functionInfo.nullIfParameterIsNull = bl;
        functionInfo.deterministic = bl2;
        functionInfo.bufferResultSetToLocalTemp = bl3;
        FUNCTIONS.put(string, functionInfo);
    }

    private static void addFunctionNotDeterministic(String string, int n, int n2, int n3) {
        Function.addFunction(string, n, n2, n3, true, false, true);
    }

    private static void addFunction(String string, int n, int n2, int n3) {
        Function.addFunction(string, n, n2, n3, true, true, true);
    }

    private static void addFunctionWithNull(String string, int n, int n2, int n3) {
        Function.addFunction(string, n, n2, n3, false, true, true);
    }

    private static FunctionInfo getFunctionInfo(String string) {
        return FUNCTIONS.get(string);
    }

    public static Function getFunction(Database database, String string) {
        FunctionInfo functionInfo;
        if (!database.getSettings().databaseToUpper) {
            string = StringUtils.toUpperEnglish(string);
        }
        if ((functionInfo = Function.getFunctionInfo(string)) == null) {
            return null;
        }
        switch (functionInfo.type) {
            case 223: 
            case 224: {
                return new TableFunction(database, functionInfo, Long.MAX_VALUE);
            }
        }
        return new Function(database, functionInfo);
    }

    public void setParameter(int n, Expression expression) {
        if (this.varArgs != null) {
            this.varArgs.add(expression);
        } else {
            if (n >= this.args.length) {
                throw DbException.get(7001, this.info.name, "" + this.args.length);
            }
            this.args[n] = expression;
        }
    }

    @Override
    public Value getValue(Session session) {
        return this.getValueWithArgs(session, this.args);
    }

    /*
     * Enabled aggressive block sorting
     */
    private Value getSimpleValue(Session session, Value value, Expression[] expressionArray, Value[] valueArray) {
        Expression expression;
        block109: {
            int n;
            int n2;
            switch (this.info.type) {
                case 0: {
                    return value.getSignum() >= 0 ? value : value.negate();
                }
                case 1: {
                    return ValueDouble.get(Math.acos(value.getDouble()));
                }
                case 2: {
                    return ValueDouble.get(Math.asin(value.getDouble()));
                }
                case 3: {
                    return ValueDouble.get(Math.atan(value.getDouble()));
                }
                case 8: {
                    return ValueDouble.get(Math.ceil(value.getDouble()));
                }
                case 9: {
                    return ValueDouble.get(Math.cos(value.getDouble()));
                }
                case 36: {
                    return ValueDouble.get(Math.cosh(value.getDouble()));
                }
                case 10: {
                    double d = Math.tan(value.getDouble());
                    if (d != 0.0) return ValueDouble.get(1.0 / d);
                    throw DbException.get(22012, this.getSQL());
                }
                case 11: {
                    return ValueDouble.get(Math.toDegrees(value.getDouble()));
                }
                case 12: {
                    return ValueDouble.get(Math.exp(value.getDouble()));
                }
                case 13: {
                    return ValueDouble.get(Math.floor(value.getDouble()));
                }
                case 39: {
                    return ValueDouble.get(Math.log(value.getDouble()));
                }
                case 14: {
                    if (!this.database.getMode().logIsLogBase10) return ValueDouble.get(Math.log(value.getDouble()));
                    return ValueDouble.get(Math.log10(value.getDouble()));
                }
                case 15: {
                    return ValueDouble.get(Math.log10(value.getDouble()));
                }
                case 17: {
                    return ValueDouble.get(Math.PI);
                }
                case 19: {
                    return ValueDouble.get(Math.toRadians(value.getDouble()));
                }
                case 20: {
                    if (value == null) return ValueDouble.get(session.getRandom().nextDouble());
                    session.getRandom().setSeed(value.getInt());
                    return ValueDouble.get(session.getRandom().nextDouble());
                }
                case 22: {
                    return ValueDouble.get(Function.roundMagic(value.getDouble()));
                }
                case 23: {
                    return ValueInt.get(value.getSignum());
                }
                case 24: {
                    return ValueDouble.get(Math.sin(value.getDouble()));
                }
                case 37: {
                    return ValueDouble.get(Math.sinh(value.getDouble()));
                }
                case 25: {
                    return ValueDouble.get(Math.sqrt(value.getDouble()));
                }
                case 26: {
                    return ValueDouble.get(Math.tan(value.getDouble()));
                }
                case 38: {
                    return ValueDouble.get(Math.tanh(value.getDouble()));
                }
                case 28: {
                    return ValueBytes.getNoCopy(MathUtils.secureRandomBytes(value.getInt()));
                }
                case 33: {
                    return ValueBytes.getNoCopy(CompressTool.getInstance().expand(value.getBytesNoCopy()));
                }
                case 34: {
                    return ValueInt.get(0);
                }
                case 35: {
                    return ValueUuid.getNewRandom();
                }
                case 50: {
                    String string = value.getString();
                    if (string.length() != 0) return ValueInt.get(string.charAt(0));
                    return ValueNull.INSTANCE;
                }
                case 51: {
                    return ValueLong.get(16L * Function.length(value));
                }
                case 52: {
                    return ValueString.get(String.valueOf((char)value.getInt()), this.database.getMode().treatEmptyStringsAsNull);
                }
                case 53: 
                case 61: {
                    return ValueLong.get(Function.length(value));
                }
                case 64: {
                    return ValueLong.get(2L * Function.length(value));
                }
                case 54: 
                case 92: {
                    Value value2 = ValueNull.INSTANCE;
                    int n3 = 0;
                    String string = "";
                    if (this.info.type == 92) {
                        n3 = 1;
                        string = Function.getNullOrValue(session, expressionArray, valueArray, 0).getString();
                    }
                    int n4 = n3;
                    while (true) {
                        if (n4 >= expressionArray.length) {
                            if (this.info.type != 92) return value2;
                            if (string == null) return value2;
                            if (value2 != ValueNull.INSTANCE) return value2;
                            return ValueString.get("", this.database.getMode().treatEmptyStringsAsNull);
                        }
                        Value value3 = Function.getNullOrValue(session, expressionArray, valueArray, n4);
                        if (value3 != ValueNull.INSTANCE) {
                            if (value2 == ValueNull.INSTANCE) {
                                value2 = value3;
                            } else {
                                String string2 = value3.getString();
                                if (!StringUtils.isNullOrEmpty(string) && !StringUtils.isNullOrEmpty(string2)) {
                                    string2 = string + string2;
                                }
                                value2 = ValueString.get(value2.getString() + string2, this.database.getMode().treatEmptyStringsAsNull);
                            }
                        }
                        ++n4;
                    }
                }
                case 56: {
                    return ValueString.get(Function.hexToRaw(value.getString()), this.database.getMode().treatEmptyStringsAsNull);
                }
                case 59: 
                case 75: {
                    return ValueString.get(value.getString().toLowerCase(), this.database.getMode().treatEmptyStringsAsNull);
                }
                case 65: {
                    return ValueString.get(Function.rawToHex(value.getString()), this.database.getMode().treatEmptyStringsAsNull);
                }
                case 70: {
                    return ValueString.get(Function.getSoundex(value.getString()), this.database.getMode().treatEmptyStringsAsNull);
                }
                case 71: {
                    int n5 = Math.max(0, value.getInt());
                    char[] cArray = new char[n5];
                    int n6 = n5 - 1;
                    while (true) {
                        if (n6 < 0) {
                            return ValueString.get(new String(cArray), this.database.getMode().treatEmptyStringsAsNull);
                        }
                        cArray[n6] = 32;
                        --n6;
                    }
                }
                case 74: 
                case 76: {
                    return ValueString.get(value.getString().toUpperCase(), this.database.getMode().treatEmptyStringsAsNull);
                }
                case 79: {
                    return ValueString.get(StringUtils.javaEncode(value.getString()), this.database.getMode().treatEmptyStringsAsNull);
                }
                case 80: {
                    return ValueString.get(StringUtils.javaDecode(value.getString()), this.database.getMode().treatEmptyStringsAsNull);
                }
                case 81: {
                    return ValueBytes.getNoCopy(value.getString().getBytes(StandardCharsets.UTF_8));
                }
                case 82: {
                    return ValueString.get(new String(value.getBytesNoCopy(), StandardCharsets.UTF_8), this.database.getMode().treatEmptyStringsAsNull);
                }
                case 85: {
                    return ValueString.get(StringUtils.xmlComment(value.getString()), this.database.getMode().treatEmptyStringsAsNull);
                }
                case 86: {
                    return ValueString.get(StringUtils.xmlCData(value.getString()), this.database.getMode().treatEmptyStringsAsNull);
                }
                case 87: {
                    return ValueString.get(StringUtils.xmlStartDoc(), this.database.getMode().treatEmptyStringsAsNull);
                }
                case 104: {
                    int n7 = DateTimeUtils.getSundayDayOfWeek(DateTimeUtils.dateAndTimeFromValue(value)[0]);
                    return ValueString.get(DateTimeFunctions.getMonthsAndWeeks(1)[n7], this.database.getMode().treatEmptyStringsAsNull);
                }
                case 105: 
                case 106: 
                case 107: 
                case 108: 
                case 109: 
                case 110: 
                case 113: 
                case 114: 
                case 115: 
                case 116: 
                case 123: 
                case 124: 
                case 125: {
                    return ValueInt.get(DateTimeFunctions.getIntDatePart(value, this.info.type));
                }
                case 111: {
                    int n8 = DateTimeUtils.monthFromDateValue(DateTimeUtils.dateAndTimeFromValue(value)[0]);
                    return ValueString.get(DateTimeFunctions.getMonthsAndWeeks(0)[n8 - 1], this.database.getMode().treatEmptyStringsAsNull);
                }
                case 100: 
                case 117: {
                    long l = session.getTransactionStart();
                    return ValueDate.fromMillis(l);
                }
                case 101: 
                case 118: {
                    long l = session.getTransactionStart();
                    return ValueTime.fromMillis(l);
                }
                case 112: 
                case 119: {
                    long l = session.getTransactionStart();
                    ValueTimestamp valueTimestamp = ValueTimestamp.fromMillis(l);
                    if (value == null) return valueTimestamp;
                    Mode mode = this.database.getMode();
                    valueTimestamp = (ValueTimestamp)valueTimestamp.convertScale(mode.convertOnlyToSmallerScale, value.getInt());
                    return valueTimestamp;
                }
                case 150: {
                    return ValueString.get(this.database.getShortName(), this.database.getMode().treatEmptyStringsAsNull);
                }
                case 151: 
                case 152: {
                    return ValueString.get(session.getUser().getName(), this.database.getMode().treatEmptyStringsAsNull);
                }
                case 153: {
                    return session.getLastIdentity();
                }
                case 154: {
                    return session.getLastScopeIdentity();
                }
                case 155: {
                    return ValueBoolean.get(session.getAutoCommit());
                }
                case 156: {
                    return ValueBoolean.get(this.database.isReadOnly());
                }
                case 157: {
                    String string = this.database.getDatabasePath();
                    return string == null ? ValueNull.INSTANCE : ValueString.get(string, this.database.getMode().treatEmptyStringsAsNull);
                }
                case 158: {
                    return ValueInt.get(session.getLockTimeout());
                }
                case 159: {
                    return ValueLong.get(Function.getDiskSpaceUsed(session, value));
                }
                case 202: 
                case 203: {
                    value = value.convertTo(this.dataType);
                    Mode mode = this.database.getMode();
                    value = value.convertScale(mode.convertOnlyToSmallerScale, this.scale);
                    return value = value.convertPrecision(this.getPrecision(), false);
                }
                case 212: {
                    session.getUser().checkAdmin();
                    return ValueInt.get(Utils.getMemoryFree());
                }
                case 213: {
                    session.getUser().checkAdmin();
                    return ValueInt.get(Utils.getMemoryUsed());
                }
                case 214: {
                    return ValueInt.get(this.database.getLockMode());
                }
                case 215: {
                    return ValueString.get(session.getCurrentSchemaName(), this.database.getMode().treatEmptyStringsAsNull);
                }
                case 216: {
                    return ValueInt.get(session.getId());
                }
                case 200: {
                    Value value2 = value;
                    if (value != ValueNull.INSTANCE) return this.convertResult(value2);
                    value2 = Function.getNullOrValue(session, expressionArray, valueArray, 1);
                    return this.convertResult(value2);
                }
                case 201: {
                    Value value4 = !value.getBoolean() ? Function.getNullOrValue(session, expressionArray, valueArray, 2) : Function.getNullOrValue(session, expressionArray, valueArray, 1);
                    return value4.convertTo(this.dataType);
                }
                case 229: {
                    int n9 = -1;
                    int n10 = expressionArray.length - 1;
                    for (int i = 1; i < n10; i += 2) {
                        if (!this.database.areEqual(value, Function.getNullOrValue(session, expressionArray, valueArray, i))) continue;
                        n9 = i + 1;
                        break;
                    }
                    if (n9 < 0 && expressionArray.length % 2 == 0) {
                        n9 = expressionArray.length - 1;
                    }
                    ValueNull valueNull = n9 < 0 ? ValueNull.INSTANCE : Function.getNullOrValue(session, expressionArray, valueArray, n9);
                    return valueNull.convertTo(this.dataType);
                }
                case 228: {
                    Value value5 = value == ValueNull.INSTANCE ? Function.getNullOrValue(session, expressionArray, valueArray, 2) : Function.getNullOrValue(session, expressionArray, valueArray, 1);
                    return value5.convertTo(this.dataType);
                }
                case 204: {
                    Value value2 = value;
                    int n11 = 0;
                    while (n11 < expressionArray.length) {
                        Value value6 = Function.getNullOrValue(session, expressionArray, valueArray, n11);
                        if (value6 != ValueNull.INSTANCE) {
                            return value6.convertTo(this.dataType);
                        }
                        ++n11;
                    }
                    return value2;
                }
                case 219: 
                case 220: {
                    Value value2 = ValueNull.INSTANCE;
                    int n12 = 0;
                    while (n12 < expressionArray.length) {
                        Value value7 = Function.getNullOrValue(session, expressionArray, valueArray, n12);
                        if (value7 != ValueNull.INSTANCE) {
                            value7 = value7.convertTo(this.dataType);
                            if (value2 == ValueNull.INSTANCE) {
                                value2 = value7;
                            } else {
                                int n13 = this.database.compareTypeSafe(value2, value7);
                                if (this.info.type == 219 && n13 < 0) {
                                    value2 = value7;
                                } else if (this.info.type == 220 && n13 > 0) {
                                    value2 = value7;
                                }
                            }
                        }
                        ++n12;
                    }
                    return value2;
                }
                case 206: {
                    expression = null;
                    if (value == null) {
                        n2 = expressionArray.length - 1;
                        break;
                    }
                    if (value == ValueNull.INSTANCE) break block109;
                    int n14 = expressionArray.length - 1;
                    for (n = 1; n < n14; n += 2) {
                        Value value8 = expressionArray[n].getValue(session);
                        if (!this.database.areEqual(value, value8)) continue;
                        expression = expressionArray[n + 1];
                        break block109;
                    }
                    break block109;
                }
                case 209: {
                    if (value.getType() != 17) {
                        return ValueNull.INSTANCE;
                    }
                    Value value9 = Function.getNullOrValue(session, expressionArray, valueArray, 1);
                    int n15 = value9.getInt();
                    Value[] valueArray2 = ((ValueArray)value).getList();
                    if (n15 < 1) return ValueNull.INSTANCE;
                    if (n15 > valueArray2.length) return ValueNull.INSTANCE;
                    return valueArray2[n15 - 1];
                }
                case 217: {
                    if (value.getType() != 17) return ValueNull.INSTANCE;
                    Value[] valueArray3 = ((ValueArray)value).getList();
                    return ValueInt.get(valueArray3.length);
                }
                case 230: {
                    Value[] valueArray4;
                    Value value2 = ValueBoolean.FALSE;
                    if (value.getType() != 17) return value2;
                    Value value10 = Function.getNullOrValue(session, expressionArray, valueArray, 1);
                    Value[] valueArray5 = valueArray4 = ((ValueArray)value).getList();
                    int n16 = valueArray5.length;
                    int n17 = 0;
                    while (n17 < n16) {
                        Value value11 = valueArray5[n17];
                        if (value11.equals(value10)) {
                            return ValueBoolean.TRUE;
                        }
                        ++n17;
                    }
                    return value2;
                }
                case 221: {
                    return ValueBoolean.get(Function.cancelStatement(session, value.getInt()));
                }
                case 226: {
                    return session.getTransactionId();
                }
                default: {
                    return null;
                }
            }
            for (n = 1; n < n2; n += 2) {
                Value value12 = expressionArray[n].getValue(session);
                if (!value12.getBoolean()) continue;
                expression = expressionArray[n + 1];
                break;
            }
        }
        if (expression == null && expressionArray.length % 2 == 0) {
            expression = expressionArray[expressionArray.length - 1];
        }
        ValueNull valueNull = expression == null ? ValueNull.INSTANCE : expression.getValue(session);
        return valueNull.convertTo(this.dataType);
    }

    private Value convertResult(Value value) {
        return value.convertTo(this.dataType);
    }

    private static boolean cancelStatement(Session session, int n) {
        Session[] sessionArray;
        session.getUser().checkAdmin();
        for (Session session2 : sessionArray = session.getDatabase().getSessions(false)) {
            if (session2.getId() != n) continue;
            Command command = session2.getCurrentCommand();
            if (command == null) {
                return false;
            }
            command.cancel();
            return true;
        }
        return false;
    }

    private static long getDiskSpaceUsed(Session session, Value value) {
        Parser parser = new Parser(session);
        String string = value.getString();
        Table table = parser.parseTableName(string);
        return table.getDiskSpaceUsed();
    }

    private static Value getNullOrValue(Session session, Expression[] expressionArray, Value[] valueArray, int n) {
        if (n >= expressionArray.length) {
            return null;
        }
        Value value = valueArray[n];
        if (value == null) {
            Expression expression = expressionArray[n];
            if (expression == null) {
                return null;
            }
            value = valueArray[n] = expression.getValue(session);
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private Value getValueWithArgs(Session var1_1, Expression[] var2_2) {
        var3_3 = new Value[var2_2.length];
        if (this.info.nullIfParameterIsNull) {
            for (var4_4 = 0; var4_4 < var2_2.length; ++var4_4) {
                var5_6 = var2_2[var4_4];
                var6_7 = var5_6.getValue(var1_1);
                if (var6_7 == ValueNull.INSTANCE) {
                    return ValueNull.INSTANCE;
                }
                var3_3[var4_4] = var6_7;
            }
        }
        if ((var5_6 = this.getSimpleValue(var1_1, var4_5 = Function.getNullOrValue(var1_1, var2_2, var3_3, 0), var2_2, var3_3)) != null) {
            return var5_6;
        }
        var6_7 = Function.getNullOrValue(var1_1, var2_2, var3_3, 1);
        var7_8 = Function.getNullOrValue(var1_1, var2_2, var3_3, 2);
        var8_9 = Function.getNullOrValue(var1_1, var2_2, var3_3, 3);
        var9_10 = Function.getNullOrValue(var1_1, var2_2, var3_3, 4);
        var10_11 = Function.getNullOrValue(var1_1, var2_2, var3_3, 5);
        block11 : switch (this.info.type) {
            case 4: {
                var11_12 = ValueDouble.get(Math.atan2(var4_5.getDouble(), var6_7.getDouble()));
                break;
            }
            case 5: {
                var11_12 = ValueLong.get(var4_5.getLong() & var6_7.getLong());
                break;
            }
            case 40: {
                var11_12 = ValueBoolean.get((var4_5.getLong() & 1L << var6_7.getInt()) != 0L);
                break;
            }
            case 6: {
                var11_12 = ValueLong.get(var4_5.getLong() | var6_7.getLong());
                break;
            }
            case 7: {
                var11_12 = ValueLong.get(var4_5.getLong() ^ var6_7.getLong());
                break;
            }
            case 16: {
                var12_13 = var6_7.getLong();
                if (var12_13 == 0L) {
                    throw DbException.get(22012, this.getSQL());
                }
                var11_12 = ValueLong.get(var4_5.getLong() % var12_13);
                break;
            }
            case 18: {
                var11_12 = ValueDouble.get(Math.pow(var4_5.getDouble(), var6_7.getDouble()));
                break;
            }
            case 21: {
                var12_14 = var6_7 == null ? 1.0 : Math.pow(10.0, var6_7.getDouble());
                var14_39 = var4_5.getDouble() * var12_14;
                var16_52 = var14_39 > 0.0 ? 1 : -1;
                var11_12 = ValueDouble.get((double)Math.round(Math.abs(var14_39)) / var12_14 * (double)var16_52);
                break;
            }
            case 27: {
                if (var4_5.getType() == 11) {
                    var11_12 = ValueTimestamp.fromDateValueAndNanos(((ValueTimestamp)var4_5).getDateValue(), 0L);
                    break;
                }
                if (var4_5.getType() == 10) {
                    var11_12 = ValueTimestamp.fromDateValueAndNanos(((ValueDate)var4_5).getDateValue(), 0L);
                    break;
                }
                if (var4_5.getType() == 24) {
                    var12_15 = (ValueTimestampTimeZone)var4_5;
                    var11_12 = ValueTimestampTimeZone.fromDateValueAndNanos(var12_15.getDateValue(), 0L, var12_15.getTimeZoneOffsetMins());
                    break;
                }
                if (var4_5.getType() == 13) {
                    var12_16 = ValueTimestamp.parse(var4_5.getString(), var1_1.getDatabase().getMode());
                    var11_12 = ValueTimestamp.fromDateValueAndNanos(var12_16.getDateValue(), 0L);
                    break;
                }
                var12_17 = var4_5.getDouble();
                var14_40 = var6_7 == null ? 0 : var6_7.getInt();
                var15_64 = Math.pow(10.0, var14_40);
                var17_70 = var12_17 * var15_64;
                var11_12 = ValueDouble.get((var12_17 < 0.0 ? Math.ceil(var17_70) : Math.floor(var17_70)) / var15_64);
                break;
            }
            case 29: {
                var11_12 = ValueBytes.getNoCopy(Function.getHash(var4_5.getString(), var6_7.getBytesNoCopy(), var7_8.getInt()));
                break;
            }
            case 30: {
                var11_12 = ValueBytes.getNoCopy(Function.encrypt(var4_5.getString(), var6_7.getBytesNoCopy(), var7_8.getBytesNoCopy()));
                break;
            }
            case 31: {
                var11_12 = ValueBytes.getNoCopy(Function.decrypt(var4_5.getString(), var6_7.getBytesNoCopy(), var7_8.getBytesNoCopy()));
                break;
            }
            case 32: {
                var12_18 = null;
                if (var6_7 != null) {
                    var12_18 = var6_7.getString();
                }
                var11_12 = ValueBytes.getNoCopy(CompressTool.getInstance().compress(var4_5.getBytesNoCopy(), var12_18));
                break;
            }
            case 55: {
                var11_12 = ValueInt.get(Function.getDifference(var4_5.getString(), var6_7.getString()));
                break;
            }
            case 57: {
                if (var6_7 == ValueNull.INSTANCE || var7_8 == ValueNull.INSTANCE) {
                    var11_12 = var6_7;
                    break;
                }
                var11_12 = ValueString.get(Function.insert(var4_5.getString(), var6_7.getInt(), var7_8.getInt(), var8_9.getString()), this.database.getMode().treatEmptyStringsAsNull);
                break;
            }
            case 60: {
                var11_12 = ValueString.get(Function.left(var4_5.getString(), var6_7.getInt()), this.database.getMode().treatEmptyStringsAsNull);
                break;
            }
            case 62: {
                var12_19 = var7_8 == null ? 0 : var7_8.getInt();
                var11_12 = ValueInt.get(Function.locate(var4_5.getString(), var6_7.getString(), var12_19));
                break;
            }
            case 58: {
                var12_20 = var7_8 == null ? 0 : var7_8.getInt();
                var11_12 = ValueInt.get(Function.locate(var6_7.getString(), var4_5.getString(), var12_20));
                break;
            }
            case 66: {
                var12_21 = Math.max(0, var6_7.getInt());
                var11_12 = ValueString.get(Function.repeat(var4_5.getString(), var12_21), this.database.getMode().treatEmptyStringsAsNull);
                break;
            }
            case 67: {
                if (var4_5 == ValueNull.INSTANCE || var6_7 == ValueNull.INSTANCE || var7_8 == ValueNull.INSTANCE && this.database.getMode().getEnum() != Mode.ModeEnum.Oracle) {
                    var11_12 = ValueNull.INSTANCE;
                    break;
                }
                var12_22 = var4_5.getString();
                var13_75 = var6_7.getString();
                v0 = var14_41 = var7_8 == null ? "" : var7_8.getString();
                if (var14_41 == null) {
                    var14_41 = "";
                }
                var11_12 = ValueString.get(StringUtils.replaceAll(var12_22, var13_75, var14_41), this.database.getMode().treatEmptyStringsAsNull);
                break;
            }
            case 68: {
                var11_12 = ValueString.get(Function.right(var4_5.getString(), var6_7.getInt()), this.database.getMode().treatEmptyStringsAsNull);
                break;
            }
            case 63: {
                var11_12 = ValueString.get(StringUtils.trim(var4_5.getString(), true, false, var6_7 == null ? " " : var6_7.getString()), this.database.getMode().treatEmptyStringsAsNull);
                break;
            }
            case 78: {
                var11_12 = ValueString.get(StringUtils.trim(var4_5.getString(), true, true, var6_7 == null ? " " : var6_7.getString()), this.database.getMode().treatEmptyStringsAsNull);
                break;
            }
            case 69: {
                var11_12 = ValueString.get(StringUtils.trim(var4_5.getString(), false, true, var6_7 == null ? " " : var6_7.getString()), this.database.getMode().treatEmptyStringsAsNull);
                break;
            }
            case 72: 
            case 73: {
                var12_23 = var4_5.getString();
                var13_76 = var6_7.getInt();
                if (var13_76 < 0) {
                    var13_76 = var12_23.length() + var13_76 + 1;
                }
                var14_42 = var7_8 == null ? var12_23.length() : var7_8.getInt();
                var11_12 = ValueString.get(Function.substring(var12_23, var13_76, var14_42), this.database.getMode().treatEmptyStringsAsNull);
                break;
            }
            case 77: {
                var11_12 = ValueInt.get(Function.locate(var4_5.getString(), var6_7.getString(), 0));
                break;
            }
            case 83: {
                var11_12 = ValueString.get(StringUtils.xmlAttr(var4_5.getString(), var6_7.getString()), this.database.getMode().treatEmptyStringsAsNull);
                break;
            }
            case 84: {
                v1 = var6_7 == null ? null : (var12_24 = var6_7 == ValueNull.INSTANCE ? null : var6_7.getString());
                var13_77 = var7_8 == null ? null : (var7_8 == ValueNull.INSTANCE ? null : var7_8.getString());
                var14_43 = var8_9 == null ? true : var8_9.getBoolean();
                var11_12 = ValueString.get(StringUtils.xmlNode(var4_5.getString(), var12_24, var13_77, var14_43), this.database.getMode().treatEmptyStringsAsNull);
                break;
            }
            case 89: {
                var12_25 = var6_7.getString();
                var13_78 = var7_8.getString();
                if (this.database.getMode().regexpReplaceBackslashReferences && (var13_78.indexOf(92) >= 0 || var13_78.indexOf(36) >= 0)) {
                    var14_44 = new StringBuilder();
                    for (var15_65 = 0; var15_65 < var13_78.length(); ++var15_65) {
                        var16_53 = var13_78.charAt(var15_65);
                        if (var16_53 == '$') {
                            var14_44.append('\\');
                        } else if (var16_53 == '\\' && ++var15_65 < var13_78.length()) {
                            var16_53 = var13_78.charAt(var15_65);
                            var14_44.append((char)(var16_53 >= '0' && var16_53 <= '9' ? 36 : 92));
                        }
                        var14_44.append(var16_53);
                    }
                    var13_78 = var14_44.toString();
                }
                var14_44 = var8_9 == null || var8_9.getString() == null ? "" : var8_9.getString();
                var15_65 = Function.makeRegexpFlags((String)var14_44);
                try {
                    var11_12 = ValueString.get(Pattern.compile(var12_25, var15_65).matcher(var4_5.getString()).replaceAll(var13_78), this.database.getMode().treatEmptyStringsAsNull);
                    break;
                }
                catch (StringIndexOutOfBoundsException var16_54) {
                    throw DbException.get(22025, var16_54, new String[]{var13_78});
                }
                catch (PatternSyntaxException var16_55) {
                    throw DbException.get(22025, var16_55, new String[]{var12_25});
                }
                catch (IllegalArgumentException var16_56) {
                    throw DbException.get(22025, var16_56, new String[]{var13_78});
                }
            }
            case 90: {
                var11_12 = ValueString.get(StringUtils.pad(var4_5.getString(), var6_7.getInt(), var7_8 == null ? null : var7_8.getString(), true), this.database.getMode().treatEmptyStringsAsNull);
                break;
            }
            case 91: {
                var11_12 = ValueString.get(StringUtils.pad(var4_5.getString(), var6_7.getInt(), var7_8 == null ? null : var7_8.getString(), false), this.database.getMode().treatEmptyStringsAsNull);
                break;
            }
            case 95: {
                var11_12 = ValueLong.get(Function.oraHash(var4_5.getString(), var6_7 == null ? null : Integer.valueOf(var6_7.getInt()), var7_8 == null ? null : Integer.valueOf(var7_8.getInt())).intValue());
                break;
            }
            case 93: {
                switch (var4_5.getType()) {
                    case 9: 
                    case 10: 
                    case 11: 
                    case 24: {
                        var11_12 = ValueString.get(ToChar.toCharDateTime(var4_5, var6_7 == null ? null : var6_7.getString(), var7_8 == null ? null : var7_8.getString()), this.database.getMode().treatEmptyStringsAsNull);
                        break block11;
                    }
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: {
                        var11_12 = ValueString.get(ToChar.toChar(var4_5.getBigDecimal(), var6_7 == null ? null : var6_7.getString(), var7_8 == null ? null : var7_8.getString()), this.database.getMode().treatEmptyStringsAsNull);
                        break block11;
                    }
                }
                var11_12 = ValueString.get(var4_5.getString(), this.database.getMode().treatEmptyStringsAsNull);
                break;
            }
            case 96: {
                var11_12 = ToDateParser.toDate(var4_5.getString(), var6_7 == null ? null : var6_7.getString());
                break;
            }
            case 97: {
                var11_12 = ToDateParser.toTimestamp(var4_5.getString(), var6_7 == null ? null : var6_7.getString());
                break;
            }
            case 98: {
                var11_12 = DateTimeFunctions.dateadd("MONTH", var6_7.getInt(), var4_5);
                break;
            }
            case 99: {
                var11_12 = ToDateParser.toTimestampTz(var4_5.getString(), var6_7 == null ? null : var6_7.getString());
                break;
            }
            case 94: {
                var12_26 = var6_7.getString();
                var13_79 = var7_8.getString();
                var11_12 = ValueString.get(Function.translate(var4_5.getString(), var12_26, var13_79), this.database.getMode().treatEmptyStringsAsNull);
                break;
            }
            case 231: {
                var11_12 = ValueString.get(Constants.getVersion(), this.database.getMode().treatEmptyStringsAsNull);
                break;
            }
            case 102: {
                var11_12 = DateTimeFunctions.dateadd(var4_5.getString(), var6_7.getLong(), var7_8);
                break;
            }
            case 103: {
                var11_12 = ValueLong.get(DateTimeFunctions.datediff(var4_5.getString(), var6_7, var7_8));
                break;
            }
            case 132: {
                var11_12 = DateTimeFunctions.truncateDate(var4_5.getString(), var6_7);
                break;
            }
            case 120: {
                var11_12 = DateTimeFunctions.extract(var4_5.getString(), var6_7);
                break;
            }
            case 121: {
                if (var4_5 == ValueNull.INSTANCE || var6_7 == ValueNull.INSTANCE) {
                    var11_12 = ValueNull.INSTANCE;
                    break;
                }
                v2 = var7_8 == null ? null : (var12_27 = var7_8 == ValueNull.INSTANCE ? null : var7_8.getString());
                v3 = var8_9 == null ? null : (var13_80 = var8_9 == ValueNull.INSTANCE ? null : var8_9.getString());
                if (var4_5 instanceof ValueTimestampTimeZone) {
                    var13_80 = DateTimeUtils.timeZoneNameFromOffsetMins(((ValueTimestampTimeZone)var4_5).getTimeZoneOffsetMins());
                }
                var11_12 = ValueString.get(DateTimeFunctions.formatDateTime(var4_5.getTimestamp(), var6_7.getString(), var12_27, var13_80), this.database.getMode().treatEmptyStringsAsNull);
                break;
            }
            case 122: {
                if (var4_5 == ValueNull.INSTANCE || var6_7 == ValueNull.INSTANCE) {
                    var11_12 = ValueNull.INSTANCE;
                    break;
                }
                v4 = var7_8 == null ? null : (var12_28 = var7_8 == ValueNull.INSTANCE ? null : var7_8.getString());
                var13_81 = var8_9 == null ? null : (var8_9 == ValueNull.INSTANCE ? null : var8_9.getString());
                var14_45 = DateTimeFunctions.parseDateTime(var4_5.getString(), var6_7.getString(), var12_28, var13_81);
                var11_12 = ValueTimestamp.fromMillis(var14_45.getTime());
                break;
            }
            case 205: {
                var11_12 = this.database.areEqual(var4_5, var6_7) != false ? ValueNull.INSTANCE : var4_5;
                break;
            }
            case 207: {
                var12_29 = this.getSequence(var1_1, var4_5, var6_7);
                var13_82 = new SequenceValue(var12_29);
                var11_12 = var13_82.getValue(var1_1);
                break;
            }
            case 208: {
                var12_30 = this.getSequence(var1_1, var4_5, var6_7);
                var11_12 = ValueLong.get(var12_30.getCurrentValue());
                break;
            }
            case 210: {
                var12_31 = var4_5.getString();
                var13_83 = var6_7 == null ? null : var6_7.getString();
                var14_46 = new Csv();
                var15_66 = var7_8 == null ? null : var7_8.getString();
                var16_57 = null;
                if (var15_66 != null && var15_66.indexOf(61) >= 0) {
                    var16_57 = var14_46.setOptions(var15_66);
                } else {
                    var16_57 = var15_66;
                    var17_71 = var8_9 == null ? null : var8_9.getString();
                    var18_91 = var9_10 == null ? null : var9_10.getString();
                    var19_93 = var10_11 == null ? null : var10_11.getString();
                    var20_96 = Function.getNullOrValue(var1_1, var2_2, var3_3, 6);
                    var21_98 = var20_96 == null ? null : var20_96.getString();
                    Function.setCsvDelimiterEscape(var14_46, var17_71, (String)var18_91, var19_93);
                    var14_46.setNullString(var21_98);
                }
                var17_72 = var14_46.getFieldSeparatorRead();
                var18_91 = StringUtils.arraySplit(var13_83, var17_72, true);
                try {
                    var11_12 = ValueResultSet.get(var14_46.read(var12_31, var18_91, var16_57));
                    break;
                }
                catch (SQLException var19_94) {
                    throw DbException.convert(var19_94);
                }
            }
            case 218: {
                var1_1.getUser().checkAdmin();
                var12_32 = var1_1.createConnection(false);
                var13_84 = LinkSchema.linkSchema(var12_32, var4_5.getString(), var6_7.getString(), var7_8.getString(), var8_9.getString(), var9_10.getString(), var10_11.getString());
                var11_12 = ValueResultSet.get(var13_84);
                break;
            }
            case 211: {
                var1_1.getUser().checkAdmin();
                var12_33 = var1_1.createConnection(false);
                var13_85 = new Csv();
                var14_47 = var7_8 == null ? null : var7_8.getString();
                var15_67 = null;
                if (var14_47 != null && var14_47.indexOf(61) >= 0) {
                    var15_67 = var13_85.setOptions(var14_47);
                } else {
                    var15_67 = var14_47;
                    var16_58 = var8_9 == null ? null : var8_9.getString();
                    var17_73 = var9_10 == null ? null : var9_10.getString();
                    var18_92 = var10_11 == null ? null : var10_11.getString();
                    var19_95 = Function.getNullOrValue(var1_1, var2_2, var3_3, 6);
                    var20_97 = var19_95 == null ? null : var19_95.getString();
                    var21_99 = Function.getNullOrValue(var1_1, var2_2, var3_3, 7);
                    var22_100 = var21_99 == null ? null : var21_99.getString();
                    Function.setCsvDelimiterEscape(var13_85, var16_58, var17_73, var18_92);
                    var13_85.setNullString(var20_97);
                    if (var22_100 != null) {
                        var13_85.setLineSeparator(var22_100);
                    }
                }
                try {
                    var16_59 = var13_85.write(var12_33, var4_5.getString(), var6_7.getString(), var15_67);
                    var11_12 = ValueInt.get(var16_59);
                    break;
                }
                catch (SQLException var16_60) {
                    throw DbException.convert(var16_60);
                }
            }
            case 222: {
                var12_34 = (Variable)var2_2[0];
                var1_1.setVariable(var12_34.getName(), var6_7);
                var11_12 = var6_7;
                break;
            }
            case 225: {
                var1_1.getUser().checkAdmin();
                var12_35 = var4_5.getString();
                var13_86 = var2_2.length == 1;
                try {
                    var14_48 = FileUtils.size(var12_35);
                    var16_61 = FileUtils.newInputStream(var12_35);
                    try {
                        if (var13_86) {
                            var11_12 = this.database.getLobStorage().createBlob(var16_61, var14_48);
                        } else {
                            var17_74 = var6_7 == ValueNull.INSTANCE ? new InputStreamReader(var16_61) : new InputStreamReader(var16_61, var6_7.getString());
                            var11_12 = this.database.getLobStorage().createClob(var17_74, var14_48);
                        }
                    }
                    finally {
                        IOUtils.closeSilently(var16_61);
                    }
                    var1_1.addTemporaryLob(var11_12);
                    break;
                }
                catch (IOException var14_49) {
                    throw DbException.convertIOException(var14_49, var12_35);
                }
            }
            case 232: {
                var1_1.getUser().checkAdmin();
                var11_12 = ValueNull.INSTANCE;
                var12_36 = var6_7.getString();
                try {
                    var13_87 = new FileOutputStream(var12_36);
                    var14_50 = var4_5.getInputStream();
                    var15_68 = null;
                    var11_12 = ValueLong.get(IOUtils.copyAndClose(var14_50, var13_87));
                    if (var14_50 == null) break;
                    if (var15_68 == null) ** GOTO lbl364
                    try {
                        var14_50.close();
                    }
                    catch (Throwable var16_62) {
                        var15_68.addSuppressed(var16_62);
                    }
                    break;
lbl364:
                    // 1 sources

                    var14_50.close();
                    ** break;
                    catch (Throwable var16_63) {
                        try {
                            var15_68 = var16_63;
                            throw var16_63;
                        }
                        catch (Throwable var24_102) {
                            if (var14_50 != null) {
                                if (var15_68 != null) {
                                    try {
                                        var14_50.close();
                                    }
                                    catch (Throwable var25_103) {
                                        var15_68.addSuppressed(var25_103);
                                    }
                                } else {
                                    var14_50.close();
                                }
                            }
                            throw var24_102;
lbl381:
                            // 1 sources

                            break;
                        }
                    }
                }
                catch (IOException var13_88) {
                    throw DbException.convertIOException(var13_88, var12_36);
                }
            }
            case 227: {
                var11_12 = var4_5.convertPrecision(var6_7.getLong(), var7_8.getBoolean());
                break;
            }
            case 88: {
                if (var6_7 == null) {
                    var11_12 = ValueString.get(StringUtils.xmlText(var4_5.getString()), this.database.getMode().treatEmptyStringsAsNull);
                    break;
                }
                var11_12 = ValueString.get(StringUtils.xmlText(var4_5.getString(), var6_7.getBoolean()), this.database.getMode().treatEmptyStringsAsNull);
                break;
            }
            case 240: {
                var12_37 = var6_7.getString();
                var13_89 = var7_8 == null || var7_8.getString() == null ? "" : var7_8.getString();
                var14_51 = Function.makeRegexpFlags(var13_89);
                try {
                    var11_12 = ValueBoolean.get(Pattern.compile(var12_37, var14_51).matcher(var4_5.getString()).find());
                    break;
                }
                catch (PatternSyntaxException var15_69) {
                    throw DbException.get(22025, var15_69, new String[]{var12_37});
                }
            }
            case 250: {
                var11_12 = var1_1.getVariable(var2_2[0].getSchemaName() + "." + var2_2[0].getTableName() + "." + var2_2[0].getColumnName());
                break;
            }
            case 160: {
                var12_38 = var4_5.getString();
                if (var12_38.startsWith("00") || !Function.SIGNAL_PATTERN.matcher(var12_38).matches()) {
                    throw DbException.getInvalidValueException("SQLSTATE", var12_38);
                }
                var13_90 = var6_7.getString();
                throw DbException.fromUser(var12_38, var13_90);
            }
            default: {
                throw DbException.throwInternalError("type=" + this.info.type);
            }
        }
        return var11_12;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Sequence getSequence(Session session, Value value, Value value2) {
        Object object;
        String string;
        Object object2;
        Object object3;
        if (value2 == null) {
            object3 = new Parser(session);
            object2 = value.getString();
            Expression expression = ((Parser)object3).parseExpression((String)object2);
            if (!(expression instanceof ExpressionColumn)) throw DbException.getSyntaxError((String)object2, 1);
            ExpressionColumn expressionColumn = (ExpressionColumn)expression;
            string = expressionColumn.getOriginalTableAliasName();
            if (string == null) {
                string = session.getCurrentSchemaName();
                object = object2;
            } else {
                object = expressionColumn.getColumnName();
            }
        } else {
            string = value.getString();
            object = value2.getString();
        }
        if ((object3 = this.database.findSchema(string)) == null) {
            string = StringUtils.toUpperEnglish(string);
            object3 = this.database.getSchema(string);
        }
        if ((object2 = ((Schema)object3).findSequence((String)object)) != null) return object2;
        object = StringUtils.toUpperEnglish((String)object);
        return ((Schema)object3).getSequence((String)object);
    }

    private static long length(Value value) {
        switch (value.getType()) {
            case 12: 
            case 15: 
            case 16: 
            case 19: {
                return value.getPrecision();
            }
        }
        return value.getString().length();
    }

    private static byte[] getPaddedArrayCopy(byte[] byArray, int n) {
        int n2 = MathUtils.roundUpInt(byArray.length, n);
        return Utils.copyBytes(byArray, n2);
    }

    private static byte[] decrypt(String string, byte[] byArray, byte[] byArray2) {
        BlockCipher blockCipher = CipherFactory.getBlockCipher(string);
        byte[] byArray3 = Function.getPaddedArrayCopy(byArray, blockCipher.getKeyLength());
        blockCipher.setKey(byArray3);
        byte[] byArray4 = Function.getPaddedArrayCopy(byArray2, 16);
        blockCipher.decrypt(byArray4, 0, byArray4.length);
        return byArray4;
    }

    private static byte[] encrypt(String string, byte[] byArray, byte[] byArray2) {
        BlockCipher blockCipher = CipherFactory.getBlockCipher(string);
        byte[] byArray3 = Function.getPaddedArrayCopy(byArray, blockCipher.getKeyLength());
        blockCipher.setKey(byArray3);
        byte[] byArray4 = Function.getPaddedArrayCopy(byArray2, 16);
        blockCipher.encrypt(byArray4, 0, byArray4.length);
        return byArray4;
    }

    private static byte[] getHash(String string, byte[] byArray, int n) {
        if (!"SHA256".equalsIgnoreCase(string)) {
            throw DbException.getInvalidValueException("algorithm", string);
        }
        for (int i = 0; i < n; ++i) {
            byArray = SHA256.getHash(byArray, false);
        }
        return byArray;
    }

    private static String substring(String string, int n, int n2) {
        int n3 = string.length();
        if (--n < 0) {
            n = 0;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        int n4 = n = n > n3 ? n3 : n;
        if (n + n2 > n3) {
            n2 = n3 - n;
        }
        return string.substring(n, n + n2);
    }

    private static String repeat(String string, int n) {
        StringBuilder stringBuilder = new StringBuilder(string.length() * n);
        while (n-- > 0) {
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    private static String rawToHex(String string) {
        int n = string.length();
        StringBuilder stringBuilder = new StringBuilder(4 * n);
        for (int i = 0; i < n; ++i) {
            String string2 = Integer.toHexString(string.charAt(i) & 0xFFFF);
            for (int j = string2.length(); j < 4; ++j) {
                stringBuilder.append('0');
            }
            stringBuilder.append(string2);
        }
        return stringBuilder.toString();
    }

    private static int locate(String string, String string2, int n) {
        if (n < 0) {
            int n2 = string2.length() + n;
            return string2.lastIndexOf(string, n2) + 1;
        }
        int n3 = n == 0 ? 0 : n - 1;
        return string2.indexOf(string, n3) + 1;
    }

    private static String right(String string, int n) {
        if (n < 0) {
            n = 0;
        } else if (n > string.length()) {
            n = string.length();
        }
        return string.substring(string.length() - n);
    }

    private static String left(String string, int n) {
        if (n < 0) {
            n = 0;
        } else if (n > string.length()) {
            n = string.length();
        }
        return string.substring(0, n);
    }

    private static String insert(String string, int n, int n2, String string2) {
        if (string == null) {
            return string2;
        }
        if (string2 == null) {
            return string;
        }
        int n3 = string.length();
        int n4 = string2.length();
        if (--n < 0 || n2 <= 0 || n4 == 0 || n > n3) {
            return string;
        }
        if (n + n2 > n3) {
            n2 = n3 - n;
        }
        return string.substring(0, n) + string2 + string.substring(n + n2);
    }

    private static String hexToRaw(String string) {
        int n = string.length();
        if (n % 4 != 0) {
            throw DbException.get(22018, string);
        }
        StringBuilder stringBuilder = new StringBuilder(n / 4);
        for (int i = 0; i < n; i += 4) {
            try {
                char c = (char)Integer.parseInt(string.substring(i, i + 4), 16);
                stringBuilder.append(c);
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                throw DbException.get(22018, string);
            }
        }
        return stringBuilder.toString();
    }

    private static int getDifference(String string, String string2) {
        string = Function.getSoundex(string);
        string2 = Function.getSoundex(string2);
        int n = 0;
        for (int i = 0; i < 4; ++i) {
            if (string.charAt(i) != string2.charAt(i)) continue;
            ++n;
        }
        return n;
    }

    private static String translate(String string, String string2, String string3) {
        if (StringUtils.isNullOrEmpty(string) || StringUtils.isNullOrEmpty(string2)) {
            return string;
        }
        StringBuilder stringBuilder = null;
        int n = string3 == null ? 0 : string3.length();
        int n2 = string.length();
        for (int i = 0; i < n2; ++i) {
            char c = string.charAt(i);
            int n3 = string2.indexOf(c);
            if (n3 >= 0) {
                if (stringBuilder == null) {
                    stringBuilder = new StringBuilder(n2);
                    if (i > 0) {
                        stringBuilder.append(string, 0, i);
                    }
                }
                if (n3 < n) {
                    c = string3.charAt(n3);
                }
            }
            if (stringBuilder == null) continue;
            stringBuilder.append(c);
        }
        return stringBuilder == null ? string : stringBuilder.toString();
    }

    private static double roundMagic(double d) {
        if (d < 1.0E-13 && d > -1.0E-13) {
            return 0.0;
        }
        if (d > 1.0E12 || d < -1.0E12) {
            return d;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(d);
        if (stringBuilder.toString().indexOf(69) >= 0) {
            return d;
        }
        int n = stringBuilder.length();
        if (n < 16) {
            return d;
        }
        if (stringBuilder.toString().indexOf(46) > n - 3) {
            return d;
        }
        stringBuilder.delete(n - 2, n);
        char c = stringBuilder.charAt((n -= 2) - 2);
        char c2 = stringBuilder.charAt(n - 3);
        char c3 = stringBuilder.charAt(n - 4);
        if (c == '0' && c2 == '0' && c3 == '0') {
            stringBuilder.setCharAt(n - 1, '0');
        } else if (c == '9' && c2 == '9' && c3 == '9') {
            stringBuilder.setCharAt(n - 1, '9');
            stringBuilder.append('9');
            stringBuilder.append('9');
            stringBuilder.append('9');
        }
        return Double.parseDouble(stringBuilder.toString());
    }

    private static String getSoundex(String string) {
        int n = string.length();
        char[] cArray = new char[]{'0', '0', '0', '0'};
        char c = '0';
        int n2 = 0;
        for (int i = 0; i < n && n2 < 4; ++i) {
            char c2;
            char c3 = string.charAt(i);
            char c4 = c2 = c3 > SOUNDEX_INDEX.length ? (char)'\u0000' : SOUNDEX_INDEX[c3];
            if (c2 == '\u0000') continue;
            if (n2 == 0) {
                cArray[n2++] = c3;
                c = c2;
                continue;
            }
            if (c2 <= '6') {
                if (c2 == c) continue;
                cArray[n2++] = c2;
                c = c2;
                continue;
            }
            if (c2 != '7') continue;
            c = c2;
        }
        return new String(cArray);
    }

    private static Integer oraHash(String string, Integer n, Integer n2) {
        int n3 = string.hashCode();
        if (n2 != null && n2 != 0) {
            n3 *= n2 * 17;
        }
        if (n != null && n > 0) {
            n3 %= n.intValue();
        }
        return n3;
    }

    private static int makeRegexpFlags(String string) {
        int n = 64;
        if (string != null) {
            block6: for (int i = 0; i < string.length(); ++i) {
                switch (string.charAt(i)) {
                    case 'i': {
                        n |= 2;
                        continue block6;
                    }
                    case 'c': {
                        n &= 0xFFFFFFFD;
                        continue block6;
                    }
                    case 'n': {
                        n |= 0x20;
                        continue block6;
                    }
                    case 'm': {
                        n |= 8;
                        continue block6;
                    }
                    default: {
                        throw DbException.get(90008, string);
                    }
                }
            }
        }
        return n;
    }

    @Override
    public int getType() {
        return this.dataType;
    }

    @Override
    public void mapColumns(ColumnResolver columnResolver, int n) {
        for (Expression expression : this.args) {
            if (expression == null) continue;
            expression.mapColumns(columnResolver, n);
        }
    }

    protected void checkParameterCount(int n) {
        boolean bl;
        int n2 = 0;
        int n3 = Integer.MAX_VALUE;
        switch (this.info.type) {
            case 204: 
            case 210: 
            case 219: 
            case 220: {
                n2 = 1;
                break;
            }
            case 20: 
            case 112: 
            case 119: {
                n3 = 1;
                break;
            }
            case 21: 
            case 27: 
            case 32: 
            case 63: 
            case 69: 
            case 78: 
            case 88: 
            case 97: 
            case 99: 
            case 225: {
                n2 = 1;
                n3 = 2;
                break;
            }
            case 132: {
                n2 = 2;
                n3 = 2;
                break;
            }
            case 93: 
            case 96: {
                n2 = 1;
                n3 = 3;
                break;
            }
            case 95: {
                n2 = 1;
                n3 = 3;
                break;
            }
            case 58: 
            case 62: 
            case 67: 
            case 72: 
            case 73: 
            case 90: 
            case 91: {
                n2 = 2;
                n3 = 3;
                break;
            }
            case 54: 
            case 92: 
            case 211: {
                n2 = 2;
                break;
            }
            case 84: {
                n2 = 1;
                n3 = 4;
                break;
            }
            case 121: 
            case 122: {
                n2 = 2;
                n3 = 4;
                break;
            }
            case 207: 
            case 208: {
                n2 = 1;
                n3 = 2;
                break;
            }
            case 206: 
            case 229: {
                n2 = 3;
                break;
            }
            case 89: {
                n2 = 3;
                n3 = 4;
                break;
            }
            case 240: {
                n2 = 2;
                n3 = 3;
                break;
            }
            default: {
                DbException.throwInternalError("type=" + this.info.type);
            }
        }
        boolean bl2 = bl = n >= n2 && n <= n3;
        if (!bl) {
            throw DbException.get(7001, this.info.name, n2 + ".." + n3);
        }
    }

    public void doneWithParameters() {
        if (this.info.parameterCount == -1) {
            this.checkParameterCount(this.varArgs.size());
            this.args = this.varArgs.toArray(new Expression[0]);
            this.varArgs = null;
        } else {
            int n = this.args.length;
            if (n > 0 && this.args[n - 1] == null) {
                throw DbException.get(7001, this.info.name, "" + n);
            }
        }
    }

    public void setDataType(Column column) {
        this.dataType = column.getType();
        this.precision = column.getPrecision();
        this.displaySize = column.getDisplaySize();
        this.scale = column.getScale();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Expression optimize(Session session) {
        int n;
        long l;
        int n2;
        int n3;
        boolean bl = this.info.deterministic;
        for (n3 = 0; n3 < this.args.length; ++n3) {
            Expression expression = this.args[n3];
            if (expression == null) continue;
            this.args[n3] = expression = expression.optimize(session);
            if (expression.isConstant()) continue;
            bl = false;
        }
        Expression expression = this.args.length < 1 ? null : this.args[0];
        switch (this.info.type) {
            case 200: 
            case 204: 
            case 205: 
            case 219: 
            case 220: {
                n3 = -1;
                n2 = 0;
                l = 0L;
                n = 0;
                for (Expression expression2 : this.args) {
                    int n4;
                    if (expression2 == ValueExpression.getNull() || (n4 = expression2.getType()) == -1 || n4 == 0) continue;
                    n3 = Value.getHigherOrder(n3, n4);
                    n2 = Math.max(n2, expression2.getScale());
                    l = Math.max(l, expression2.getPrecision());
                    n = Math.max(n, expression2.getDisplaySize());
                }
                if (n3 != -1) break;
                n3 = 13;
                n2 = 0;
                l = Integer.MAX_VALUE;
                n = Integer.MAX_VALUE;
                break;
            }
            case 206: 
            case 229: {
                Expression expression5;
                void expression3;
                n3 = -1;
                n2 = 0;
                l = 0L;
                n = 0;
                int i = 2;
                int n5 = this.args.length;
                while (expression3 < n5) {
                    int n6;
                    Expression expression4 = this.args[expression3];
                    if (expression4 != ValueExpression.getNull() && (n6 = expression4.getType()) != -1 && n6 != 0) {
                        n3 = Value.getHigherOrder(n3, n6);
                        n2 = Math.max(n2, expression4.getScale());
                        l = Math.max(l, expression4.getPrecision());
                        n = Math.max(n, expression4.getDisplaySize());
                    }
                    expression3 += 2;
                }
                if (this.args.length % 2 == 0 && (expression5 = this.args[this.args.length - 1]) != ValueExpression.getNull() && (n5 = expression5.getType()) != -1 && n5 != 0) {
                    n3 = Value.getHigherOrder(n3, n5);
                    n2 = Math.max(n2, expression5.getScale());
                    l = Math.max(l, expression5.getPrecision());
                    n = Math.max(n, expression5.getDisplaySize());
                }
                if (n3 != -1) break;
                n3 = 13;
                n2 = 0;
                l = Integer.MAX_VALUE;
                n = Integer.MAX_VALUE;
                break;
            }
            case 201: {
                n3 = Value.getHigherOrder(this.args[1].getType(), this.args[2].getType());
                l = Math.max(this.args[1].getPrecision(), this.args[2].getPrecision());
                n = Math.max(this.args[1].getDisplaySize(), this.args[2].getDisplaySize());
                n2 = Math.max(this.args[1].getScale(), this.args[2].getScale());
                break;
            }
            case 228: {
                switch (this.args[1].getType()) {
                    case 13: 
                    case 14: 
                    case 16: 
                    case 21: {
                        n3 = this.args[1].getType();
                        break;
                    }
                    default: {
                        n3 = Value.getHigherOrder(this.args[1].getType(), this.args[2].getType());
                    }
                }
                l = Math.max(this.args[1].getPrecision(), this.args[2].getPrecision());
                n = Math.max(this.args[1].getDisplaySize(), this.args[2].getDisplaySize());
                n2 = Math.max(this.args[1].getScale(), this.args[2].getScale());
                break;
            }
            case 202: 
            case 203: 
            case 227: {
                n3 = this.dataType;
                l = this.precision;
                n2 = this.scale;
                n = this.displaySize;
                break;
            }
            case 27: {
                n3 = expression.getType();
                n2 = expression.getScale();
                l = expression.getPrecision();
                n = expression.getDisplaySize();
                if (n3 == 0) {
                    n3 = 4;
                    l = 10L;
                    n = 11;
                    n2 = 0;
                    break;
                }
                if (n3 != 11) break;
                n3 = 10;
                l = 10L;
                n2 = 0;
                n = 10;
                break;
            }
            case 0: 
            case 13: 
            case 21: {
                n3 = expression.getType();
                n2 = expression.getScale();
                l = expression.getPrecision();
                n = expression.getDisplaySize();
                if (n3 != 0) break;
                n3 = 4;
                l = 10L;
                n = 11;
                n2 = 0;
                break;
            }
            case 222: {
                Expression dataType = this.args[1];
                n3 = dataType.getType();
                l = dataType.getPrecision();
                n2 = dataType.getScale();
                n = dataType.getDisplaySize();
                if (expression instanceof Variable) break;
                throw DbException.get(90137, expression.getSQL());
            }
            case 225: {
                n3 = this.args.length == 1 ? 15 : 16;
                l = Integer.MAX_VALUE;
                n2 = 0;
                n = Integer.MAX_VALUE;
                break;
            }
            case 72: 
            case 73: {
                n3 = this.info.returnDataType;
                l = this.args[0].getPrecision();
                n2 = 0;
                if (this.args[1].isConstant()) {
                    l -= this.args[1].getValue(session).getLong() - 1L;
                }
                if (this.args.length == 3 && this.args[2].isConstant()) {
                    l = Math.min(l, this.args[2].getValue(session).getLong());
                }
                l = Math.max(0L, l);
                n = MathUtils.convertLongToInt(l);
                break;
            }
            default: {
                n3 = this.info.returnDataType;
                DataType dataType = DataType.getDataType(n3);
                l = -1L;
                n = 0;
                n2 = dataType.defaultScale;
            }
        }
        this.dataType = n3;
        this.precision = l;
        this.scale = n2;
        this.displaySize = n;
        if (bl) {
            Value value = this.getValue(session);
            if (value == ValueNull.INSTANCE && (this.info.type == 203 || this.info.type == 202)) {
                return this;
            }
            return ValueExpression.get(value);
        }
        return this;
    }

    @Override
    public void setEvaluatable(TableFilter tableFilter, boolean bl) {
        for (Expression expression : this.args) {
            if (expression == null) continue;
            expression.setEvaluatable(tableFilter, bl);
        }
    }

    @Override
    public int getScale() {
        return this.scale;
    }

    @Override
    public long getPrecision() {
        if (this.precision == -1L) {
            this.calculatePrecisionAndDisplaySize();
        }
        return this.precision;
    }

    @Override
    public int getDisplaySize() {
        if (this.precision == -1L) {
            this.calculatePrecisionAndDisplaySize();
        }
        return this.displaySize;
    }

    private void calculatePrecisionAndDisplaySize() {
        switch (this.info.type) {
            case 30: 
            case 31: {
                this.precision = this.args[2].getPrecision();
                this.displaySize = this.args[2].getDisplaySize();
                break;
            }
            case 32: {
                this.precision = this.args[0].getPrecision();
                this.displaySize = this.args[0].getDisplaySize();
                break;
            }
            case 52: {
                this.precision = 1L;
                this.displaySize = 1;
                break;
            }
            case 54: {
                this.precision = 0L;
                this.displaySize = 0;
                for (Expression expression : this.args) {
                    this.precision += expression.getPrecision();
                    this.displaySize = MathUtils.convertLongToInt((long)this.displaySize + (long)expression.getDisplaySize());
                    if (this.precision >= 0L) continue;
                    this.precision = Long.MAX_VALUE;
                }
                break;
            }
            case 56: {
                this.precision = (this.args[0].getPrecision() + 3L) / 4L;
                this.displaySize = MathUtils.convertLongToInt(this.precision);
                break;
            }
            case 27: 
            case 59: 
            case 63: 
            case 68: 
            case 69: 
            case 74: 
            case 75: 
            case 76: 
            case 78: 
            case 80: 
            case 82: {
                this.precision = this.args[0].getPrecision();
                this.displaySize = this.args[0].getDisplaySize();
                break;
            }
            case 65: {
                this.precision = this.args[0].getPrecision() * 4L;
                this.displaySize = MathUtils.convertLongToInt(this.precision);
                break;
            }
            case 70: {
                this.precision = 4L;
                this.displaySize = (int)this.precision;
                break;
            }
            case 104: 
            case 111: {
                this.precision = 20L;
                this.displaySize = (int)this.precision;
                break;
            }
            default: {
                DataType dataType = DataType.getDataType(this.dataType);
                this.precision = dataType.defaultPrecision;
                this.displaySize = dataType.defaultDisplaySize;
            }
        }
    }

    @Override
    public String getSQL() {
        StatementBuilder statementBuilder = new StatementBuilder(this.info.name);
        if (this.info.type == 206) {
            if (this.args[0] != null) {
                statementBuilder.append(" ").append(this.args[0].getSQL());
            }
            int n = this.args.length - 1;
            for (int i = 1; i < n; i += 2) {
                statementBuilder.append(" WHEN ").append(this.args[i].getSQL());
                statementBuilder.append(" THEN ").append(this.args[i + 1].getSQL());
            }
            if (this.args.length % 2 == 0) {
                statementBuilder.append(" ELSE ").append(this.args[this.args.length - 1].getSQL());
            }
            return statementBuilder.append(" END").toString();
        }
        statementBuilder.append('(');
        switch (this.info.type) {
            case 203: {
                statementBuilder.append(this.args[0].getSQL()).append(" AS ").append(new Column(null, this.dataType, this.precision, this.scale, this.displaySize).getCreateSQL());
                break;
            }
            case 202: {
                if (this.database.getMode().swapConvertFunctionParameters) {
                    statementBuilder.append(new Column(null, this.dataType, this.precision, this.scale, this.displaySize).getCreateSQL()).append(',').append(this.args[0].getSQL());
                    break;
                }
                statementBuilder.append(this.args[0].getSQL()).append(',').append(new Column(null, this.dataType, this.precision, this.scale, this.displaySize).getCreateSQL());
                break;
            }
            case 120: {
                ValueString valueString = (ValueString)((ValueExpression)this.args[0]).getValue(null);
                statementBuilder.append(valueString.getString()).append(" FROM ").append(this.args[1].getSQL());
                break;
            }
            default: {
                for (Expression expression : this.args) {
                    statementBuilder.appendExceptFirst(", ");
                    statementBuilder.append(expression.getSQL());
                }
            }
        }
        return statementBuilder.append(')').toString();
    }

    @Override
    public void updateAggregate(Session session) {
        for (Expression expression : this.args) {
            if (expression == null) continue;
            expression.updateAggregate(session);
        }
    }

    public int getFunctionType() {
        return this.info.type;
    }

    @Override
    public String getName() {
        return this.info.name;
    }

    @Override
    public ValueResultSet getValueForColumnList(Session session, Expression[] expressionArray) {
        switch (this.info.type) {
            case 210: {
                ValueResultSet valueResultSet;
                ResultSet resultSet;
                String[] stringArray;
                String string = expressionArray[0].getValue(session).getString();
                if (string == null) {
                    throw DbException.get(90012, "fileName");
                }
                String string2 = expressionArray.length < 2 ? null : expressionArray[1].getValue(session).getString();
                Csv csv = new Csv();
                String string3 = expressionArray.length < 3 ? null : expressionArray[2].getValue(session).getString();
                String string4 = null;
                if (string3 != null && string3.indexOf(61) >= 0) {
                    string4 = csv.setOptions(string3);
                } else {
                    string4 = string3;
                    String string5 = expressionArray.length < 4 ? null : expressionArray[3].getValue(session).getString();
                    stringArray = expressionArray.length < 5 ? null : expressionArray[4].getValue(session).getString();
                    resultSet = expressionArray.length < 6 ? null : expressionArray[5].getValue(session).getString();
                    Function.setCsvDelimiterEscape(csv, string5, (String)stringArray, (String)((Object)resultSet));
                }
                char c = csv.getFieldSeparatorRead();
                stringArray = StringUtils.arraySplit(string2, c, true);
                resultSet = null;
                try {
                    resultSet = csv.read(string, stringArray, string4);
                    valueResultSet = ValueResultSet.getCopy(resultSet, 0);
                }
                catch (SQLException sQLException) {
                    throw DbException.convert(sQLException);
                }
                finally {
                    csv.close();
                    JdbcUtils.closeSilently(resultSet);
                }
                return valueResultSet;
            }
        }
        return (ValueResultSet)this.getValueWithArgs(session, expressionArray);
    }

    private static void setCsvDelimiterEscape(Csv csv, String string, String string2, String string3) {
        char c;
        if (string != null) {
            csv.setFieldSeparatorWrite(string);
            if (string.length() > 0) {
                c = string.charAt(0);
                csv.setFieldSeparatorRead(c);
            }
        }
        if (string2 != null) {
            c = string2.length() == 0 ? (char)'\u0000' : string2.charAt(0);
            csv.setFieldDelimiter(c);
        }
        if (string3 != null) {
            c = string3.length() == 0 ? (char)'\u0000' : string3.charAt(0);
            csv.setEscapeCharacter(c);
        }
    }

    @Override
    public Expression[] getArgs() {
        return this.args;
    }

    @Override
    public boolean isEverything(ExpressionVisitor expressionVisitor) {
        for (Expression expression : this.args) {
            if (expression == null || expression.isEverything(expressionVisitor)) continue;
            return false;
        }
        switch (expressionVisitor.getType()) {
            case 2: 
            case 5: 
            case 8: {
                return this.info.deterministic;
            }
            case 0: 
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 9: {
                return true;
            }
        }
        throw DbException.throwInternalError("type=" + expressionVisitor.getType());
    }

    @Override
    public int getCost() {
        int n = 3;
        for (Expression expression : this.args) {
            if (expression == null) continue;
            n += expression.getCost();
        }
        return n;
    }

    @Override
    public boolean isDeterministic() {
        return this.info.deterministic;
    }

    @Override
    public boolean isBufferResultSetToLocalTemp() {
        return this.info.bufferResultSetToLocalTemp;
    }

    static {
        String string = "7AEIOUY8HW1BFPV2CGJKQSXZ3DT4L5MN6R";
        char c = '\u0000';
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c2 = string.charAt(i);
            if (c2 < '9') {
                c = c2;
                continue;
            }
            Function.SOUNDEX_INDEX[c2] = c;
            Function.SOUNDEX_INDEX[Character.toLowerCase((char)c2)] = c;
        }
        Function.addFunction("ABS", 0, 1, 0);
        Function.addFunction("ACOS", 1, 1, 7);
        Function.addFunction("ASIN", 2, 1, 7);
        Function.addFunction("ATAN", 3, 1, 7);
        Function.addFunction("ATAN2", 4, 2, 7);
        Function.addFunction("BITAND", 5, 2, 5);
        Function.addFunction("BITGET", 40, 2, 1);
        Function.addFunction("BITOR", 6, 2, 5);
        Function.addFunction("BITXOR", 7, 2, 5);
        Function.addFunction("CEILING", 8, 1, 7);
        Function.addFunction("CEIL", 8, 1, 7);
        Function.addFunction("COS", 9, 1, 7);
        Function.addFunction("COSH", 36, 1, 7);
        Function.addFunction("COT", 10, 1, 7);
        Function.addFunction("DEGREES", 11, 1, 7);
        Function.addFunction("EXP", 12, 1, 7);
        Function.addFunction("FLOOR", 13, 1, 7);
        Function.addFunction("LOG", 14, 1, 7);
        Function.addFunction("LN", 39, 1, 7);
        Function.addFunction("LOG10", 15, 1, 7);
        Function.addFunction("MOD", 16, 2, 5);
        Function.addFunction("PI", 17, 0, 7);
        Function.addFunction("POWER", 18, 2, 7);
        Function.addFunction("RADIANS", 19, 1, 7);
        Function.addFunctionNotDeterministic("RAND", 20, -1, 7);
        Function.addFunctionNotDeterministic("RANDOM", 20, -1, 7);
        Function.addFunction("ROUND", 21, -1, 7);
        Function.addFunction("ROUNDMAGIC", 22, 1, 7);
        Function.addFunction("SIGN", 23, 1, 4);
        Function.addFunction("SIN", 24, 1, 7);
        Function.addFunction("SINH", 37, 1, 7);
        Function.addFunction("SQRT", 25, 1, 7);
        Function.addFunction("TAN", 26, 1, 7);
        Function.addFunction("TANH", 38, 1, 7);
        Function.addFunction("TRUNCATE", 27, -1, 0);
        Function.addFunction("TRUNC", 27, -1, 0);
        Function.addFunction("HASH", 29, 3, 12);
        Function.addFunction("ENCRYPT", 30, 3, 12);
        Function.addFunction("DECRYPT", 31, 3, 12);
        Function.addFunctionNotDeterministic("SECURE_RAND", 28, 1, 12);
        Function.addFunction("COMPRESS", 32, -1, 12);
        Function.addFunction("EXPAND", 33, 1, 12);
        Function.addFunction("ZERO", 34, 0, 4);
        Function.addFunctionNotDeterministic("RANDOM_UUID", 35, 0, 20);
        Function.addFunctionNotDeterministic("SYS_GUID", 35, 0, 20);
        Function.addFunctionNotDeterministic("UUID", 35, 0, 20);
        Function.addFunction("ASCII", 50, 1, 4);
        Function.addFunction("BIT_LENGTH", 51, 1, 5);
        Function.addFunction("CHAR", 52, 1, 13);
        Function.addFunction("CHR", 52, 1, 13);
        Function.addFunction("CHAR_LENGTH", 53, 1, 4);
        Function.addFunction("CHARACTER_LENGTH", 53, 1, 4);
        Function.addFunctionWithNull("CONCAT", 54, -1, 13);
        Function.addFunctionWithNull("CONCAT_WS", 92, -1, 13);
        Function.addFunction("DIFFERENCE", 55, 2, 4);
        Function.addFunction("HEXTORAW", 56, 1, 13);
        Function.addFunctionWithNull("INSERT", 57, 4, 13);
        Function.addFunction("LCASE", 59, 1, 13);
        Function.addFunction("LEFT", 60, 2, 13);
        Function.addFunction("LENGTH", 61, 1, 5);
        Function.addFunction("LOCATE", 62, -1, 4);
        Function.addFunction("CHARINDEX", 62, -1, 4);
        Function.addFunction("POSITION", 62, 2, 4);
        Function.addFunction("INSTR", 58, -1, 4);
        Function.addFunction("LTRIM", 63, -1, 13);
        Function.addFunction("OCTET_LENGTH", 64, 1, 5);
        Function.addFunction("RAWTOHEX", 65, 1, 13);
        Function.addFunction("REPEAT", 66, 2, 13);
        Function.addFunction("REPLACE", 67, -1, 13, false, true, true);
        Function.addFunction("RIGHT", 68, 2, 13);
        Function.addFunction("RTRIM", 69, -1, 13);
        Function.addFunction("SOUNDEX", 70, 1, 13);
        Function.addFunction("SPACE", 71, 1, 13);
        Function.addFunction("SUBSTR", 72, -1, 13);
        Function.addFunction("SUBSTRING", 73, -1, 13);
        Function.addFunction("UCASE", 74, 1, 13);
        Function.addFunction("LOWER", 75, 1, 13);
        Function.addFunction("UPPER", 76, 1, 13);
        Function.addFunction("POSITION", 77, 2, 4);
        Function.addFunction("TRIM", 78, -1, 13);
        Function.addFunction("STRINGENCODE", 79, 1, 13);
        Function.addFunction("STRINGDECODE", 80, 1, 13);
        Function.addFunction("STRINGTOUTF8", 81, 1, 12);
        Function.addFunction("UTF8TOSTRING", 82, 1, 13);
        Function.addFunction("XMLATTR", 83, 2, 13);
        Function.addFunctionWithNull("XMLNODE", 84, -1, 13);
        Function.addFunction("XMLCOMMENT", 85, 1, 13);
        Function.addFunction("XMLCDATA", 86, 1, 13);
        Function.addFunction("XMLSTARTDOC", 87, 0, 13);
        Function.addFunction("XMLTEXT", 88, -1, 13);
        Function.addFunction("REGEXP_REPLACE", 89, -1, 13);
        Function.addFunction("RPAD", 90, -1, 13);
        Function.addFunction("LPAD", 91, -1, 13);
        Function.addFunction("TO_CHAR", 93, -1, 13);
        Function.addFunction("ORA_HASH", 95, -1, 4);
        Function.addFunction("TRANSLATE", 94, 3, 13);
        Function.addFunction("REGEXP_LIKE", 240, -1, 1);
        Function.addFunctionNotDeterministic("CURRENT_DATE", 117, 0, 10);
        Function.addFunctionNotDeterministic("CURDATE", 100, 0, 10);
        Function.addFunctionNotDeterministic("TODAY", 117, 0, 10);
        Function.addFunction("TO_DATE", 96, -1, 11);
        Function.addFunction("TO_TIMESTAMP", 97, -1, 11);
        Function.addFunction("ADD_MONTHS", 98, 2, 11);
        Function.addFunction("TO_TIMESTAMP_TZ", 99, -1, 24);
        Function.addFunctionNotDeterministic("GETDATE", 100, 0, 10);
        Function.addFunctionNotDeterministic("CURRENT_TIME", 118, 0, 9);
        Function.addFunctionNotDeterministic("SYSTIME", 118, 0, 9);
        Function.addFunctionNotDeterministic("CURTIME", 101, 0, 9);
        Function.addFunctionNotDeterministic("CURRENT_TIMESTAMP", 119, -1, 11);
        Function.addFunctionNotDeterministic("SYSDATE", 119, -1, 11);
        Function.addFunctionNotDeterministic("SYSTIMESTAMP", 119, -1, 11);
        Function.addFunctionNotDeterministic("NOW", 112, -1, 11);
        Function.addFunction("DATEADD", 102, 3, 11);
        Function.addFunction("TIMESTAMPADD", 102, 3, 11);
        Function.addFunction("DATEDIFF", 103, 3, 5);
        Function.addFunction("TIMESTAMPDIFF", 103, 3, 5);
        Function.addFunction("DAYNAME", 104, 1, 13);
        Function.addFunction("DAYNAME", 104, 1, 13);
        Function.addFunction("DAY", 105, 1, 4);
        Function.addFunction("DAY_OF_MONTH", 105, 1, 4);
        Function.addFunction("DAY_OF_WEEK", 106, 1, 4);
        Function.addFunction("DAY_OF_YEAR", 107, 1, 4);
        Function.addFunction("DAYOFMONTH", 105, 1, 4);
        Function.addFunction("DAYOFWEEK", 106, 1, 4);
        Function.addFunction("DAYOFYEAR", 107, 1, 4);
        Function.addFunction("HOUR", 108, 1, 4);
        Function.addFunction("MINUTE", 109, 1, 4);
        Function.addFunction("MONTH", 110, 1, 4);
        Function.addFunction("MONTHNAME", 111, 1, 13);
        Function.addFunction("QUARTER", 113, 1, 4);
        Function.addFunction("SECOND", 114, 1, 4);
        Function.addFunction("WEEK", 115, 1, 4);
        Function.addFunction("YEAR", 116, 1, 4);
        Function.addFunction("EXTRACT", 120, 2, 4);
        Function.addFunctionWithNull("FORMATDATETIME", 121, -1, 13);
        Function.addFunctionWithNull("PARSEDATETIME", 122, -1, 11);
        Function.addFunction("ISO_YEAR", 123, 1, 4);
        Function.addFunction("ISO_WEEK", 124, 1, 4);
        Function.addFunction("ISO_DAY_OF_WEEK", 125, 1, 4);
        Function.addFunction("DATE_TRUNC", 132, 2, 0);
        Function.addFunctionNotDeterministic("DATABASE", 150, 0, 13);
        Function.addFunctionNotDeterministic("USER", 151, 0, 13);
        Function.addFunctionNotDeterministic("CURRENT_USER", 152, 0, 13);
        Function.addFunctionNotDeterministic("IDENTITY", 153, 0, 5);
        Function.addFunctionNotDeterministic("SCOPE_IDENTITY", 154, 0, 5);
        Function.addFunctionNotDeterministic("IDENTITY_VAL_LOCAL", 153, 0, 5);
        Function.addFunctionNotDeterministic("LAST_INSERT_ID", 153, 0, 5);
        Function.addFunctionNotDeterministic("LASTVAL", 153, 0, 5);
        Function.addFunctionNotDeterministic("AUTOCOMMIT", 155, 0, 1);
        Function.addFunctionNotDeterministic("READONLY", 156, 0, 1);
        Function.addFunction("DATABASE_PATH", 157, 0, 13);
        Function.addFunctionNotDeterministic("LOCK_TIMEOUT", 158, 0, 4);
        Function.addFunctionWithNull("IFNULL", 200, 2, 0);
        Function.addFunctionWithNull("ISNULL", 200, 2, 0);
        Function.addFunctionWithNull("CASEWHEN", 201, 3, 0);
        Function.addFunctionWithNull("CONVERT", 202, 1, 0);
        Function.addFunctionWithNull("CAST", 203, 1, 0);
        Function.addFunctionWithNull("TRUNCATE_VALUE", 227, 3, 0);
        Function.addFunctionWithNull("COALESCE", 204, -1, 0);
        Function.addFunctionWithNull("NVL", 204, -1, 0);
        Function.addFunctionWithNull("NVL2", 228, 3, 0);
        Function.addFunctionWithNull("NULLIF", 205, 2, 0);
        Function.addFunctionWithNull("CASE", 206, -1, 0);
        Function.addFunctionNotDeterministic("NEXTVAL", 207, -1, 5);
        Function.addFunctionNotDeterministic("CURRVAL", 208, -1, 5);
        Function.addFunction("ARRAY_GET", 209, 2, 13);
        Function.addFunction("ARRAY_CONTAINS", 230, 2, 1, false, true, true);
        Function.addFunction("CSVREAD", 210, -1, 18, false, false, false);
        Function.addFunction("CSVWRITE", 211, -1, 4, false, false, true);
        Function.addFunctionNotDeterministic("MEMORY_FREE", 212, 0, 4);
        Function.addFunctionNotDeterministic("MEMORY_USED", 213, 0, 4);
        Function.addFunctionNotDeterministic("LOCK_MODE", 214, 0, 4);
        Function.addFunctionNotDeterministic("SCHEMA", 215, 0, 13);
        Function.addFunctionNotDeterministic("SESSION_ID", 216, 0, 4);
        Function.addFunction("ARRAY_LENGTH", 217, 1, 4);
        Function.addFunctionNotDeterministic("LINK_SCHEMA", 218, 6, 18);
        Function.addFunctionWithNull("LEAST", 220, -1, 0);
        Function.addFunctionWithNull("GREATEST", 219, -1, 0);
        Function.addFunctionNotDeterministic("CANCEL_SESSION", 221, 1, 1);
        Function.addFunction("SET", 222, 2, 0, false, false, true);
        Function.addFunction("FILE_READ", 225, -1, 0, false, false, true);
        Function.addFunction("FILE_WRITE", 232, 2, 5, false, false, true);
        Function.addFunctionNotDeterministic("TRANSACTION_ID", 226, 0, 13);
        Function.addFunctionWithNull("DECODE", 229, -1, 0);
        Function.addFunctionNotDeterministic("DISK_SPACE_USED", 159, 1, 5);
        Function.addFunctionWithNull("SIGNAL", 160, 2, 0);
        Function.addFunction("H2VERSION", 231, 0, 13);
        Function.addFunctionWithNull("TABLE", 223, -1, 18);
        Function.addFunctionWithNull("TABLE_DISTINCT", 224, -1, 18);
        Function.addFunctionWithNull("ROW_NUMBER", 300, 0, 5);
        Function.addFunction("VALUES", 250, 1, 0, false, true, false);
    }
}

