/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.shade.org.h2.constraint;

import com.alibaba.schedulerx.shade.org.h2.command.Parser;
import com.alibaba.schedulerx.shade.org.h2.constraint.Constraint;
import com.alibaba.schedulerx.shade.org.h2.engine.Session;
import com.alibaba.schedulerx.shade.org.h2.index.Index;
import com.alibaba.schedulerx.shade.org.h2.result.Row;
import com.alibaba.schedulerx.shade.org.h2.schema.Schema;
import com.alibaba.schedulerx.shade.org.h2.table.Column;
import com.alibaba.schedulerx.shade.org.h2.table.IndexColumn;
import com.alibaba.schedulerx.shade.org.h2.table.Table;
import com.alibaba.schedulerx.shade.org.h2.util.StatementBuilder;
import com.alibaba.schedulerx.shade.org.h2.util.StringUtils;
import java.util.HashSet;

public class ConstraintUnique
extends Constraint {
    private Index index;
    private boolean indexOwner;
    private IndexColumn[] columns;
    private final boolean primaryKey;

    public ConstraintUnique(Schema schema, int n, String string, Table table, boolean bl) {
        super(schema, n, string, table);
        this.primaryKey = bl;
    }

    @Override
    public Constraint.Type getConstraintType() {
        return this.primaryKey ? Constraint.Type.PRIMARY_KEY : Constraint.Type.UNIQUE;
    }

    @Override
    public String getCreateSQLForCopy(Table table, String string) {
        return this.getCreateSQLForCopy(table, string, true);
    }

    private String getCreateSQLForCopy(Table table, String string, boolean bl) {
        StatementBuilder statementBuilder = new StatementBuilder("ALTER TABLE ");
        statementBuilder.append(table.getSQL()).append(" ADD CONSTRAINT ");
        if (table.isHidden()) {
            statementBuilder.append("IF NOT EXISTS ");
        }
        statementBuilder.append(string);
        if (this.comment != null) {
            statementBuilder.append(" COMMENT ").append(StringUtils.quoteStringSQL(this.comment));
        }
        statementBuilder.append(' ').append(this.getConstraintType().getSqlName()).append('(');
        for (IndexColumn indexColumn : this.columns) {
            statementBuilder.appendExceptFirst(", ");
            statementBuilder.append(Parser.quoteIdentifier(indexColumn.column.getName()));
        }
        statementBuilder.append(')');
        if (bl && this.indexOwner && table == this.table) {
            statementBuilder.append(" INDEX ").append(this.index.getSQL());
        }
        return statementBuilder.toString();
    }

    @Override
    public String getCreateSQLWithoutIndexes() {
        return this.getCreateSQLForCopy(this.table, this.getSQL(), false);
    }

    @Override
    public String getCreateSQL() {
        return this.getCreateSQLForCopy(this.table, this.getSQL());
    }

    public void setColumns(IndexColumn[] indexColumnArray) {
        this.columns = indexColumnArray;
    }

    public IndexColumn[] getColumns() {
        return this.columns;
    }

    public void setIndex(Index index, boolean bl) {
        this.index = index;
        this.indexOwner = bl;
    }

    @Override
    public void removeChildrenAndResources(Session session) {
        this.table.removeConstraint(this);
        if (this.indexOwner) {
            this.table.removeIndexOrTransferOwnership(session, this.index);
        }
        this.database.removeMeta(session, this.getId());
        this.index = null;
        this.columns = null;
        this.table = null;
        this.invalidate();
    }

    @Override
    public void checkRow(Session session, Table table, Row row, Row row2) {
    }

    @Override
    public boolean usesIndex(Index index) {
        return index == this.index;
    }

    @Override
    public void setIndexOwner(Index index) {
        this.indexOwner = true;
    }

    @Override
    public HashSet<Column> getReferencedColumns(Table table) {
        HashSet<Column> hashSet = new HashSet<Column>();
        for (IndexColumn indexColumn : this.columns) {
            hashSet.add(indexColumn.column);
        }
        return hashSet;
    }

    @Override
    public boolean isBefore() {
        return true;
    }

    @Override
    public void checkExistingData(Session session) {
    }

    @Override
    public Index getUniqueIndex() {
        return this.index;
    }

    @Override
    public void rebuild() {
    }
}

