/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.shade.org.h2.command.dml;

import com.alibaba.schedulerx.shade.org.h2.command.Command;
import com.alibaba.schedulerx.shade.org.h2.command.Prepared;
import com.alibaba.schedulerx.shade.org.h2.command.dml.Query;
import com.alibaba.schedulerx.shade.org.h2.engine.GeneratedKeys;
import com.alibaba.schedulerx.shade.org.h2.engine.Session;
import com.alibaba.schedulerx.shade.org.h2.expression.Expression;
import com.alibaba.schedulerx.shade.org.h2.expression.Parameter;
import com.alibaba.schedulerx.shade.org.h2.expression.SequenceValue;
import com.alibaba.schedulerx.shade.org.h2.index.Index;
import com.alibaba.schedulerx.shade.org.h2.message.DbException;
import com.alibaba.schedulerx.shade.org.h2.result.ResultInterface;
import com.alibaba.schedulerx.shade.org.h2.result.Row;
import com.alibaba.schedulerx.shade.org.h2.table.Column;
import com.alibaba.schedulerx.shade.org.h2.table.Table;
import com.alibaba.schedulerx.shade.org.h2.table.TableFilter;
import com.alibaba.schedulerx.shade.org.h2.util.New;
import com.alibaba.schedulerx.shade.org.h2.util.StatementBuilder;
import com.alibaba.schedulerx.shade.org.h2.value.Value;
import java.util.ArrayList;

public class Merge
extends Prepared {
    private Table targetTable;
    private TableFilter targetTableFilter;
    private Column[] columns;
    private Column[] keys;
    private final ArrayList<Expression[]> valuesExpressionList = New.arrayList();
    private Query query;
    private Prepared update;

    public Merge(Session session) {
        super(session);
    }

    @Override
    public void setCommand(Command command) {
        super.setCommand(command);
        if (this.query != null) {
            this.query.setCommand(command);
        }
    }

    public void setTargetTable(Table table) {
        this.targetTable = table;
    }

    public void setColumns(Column[] columnArray) {
        this.columns = columnArray;
    }

    public void setKeys(Column[] columnArray) {
        this.keys = columnArray;
    }

    public void setQuery(Query query) {
        this.query = query;
    }

    public void addRow(Expression[] expressionArray) {
        this.valuesExpressionList.add(expressionArray);
    }

    @Override
    public int update() {
        int n;
        this.session.getUser().checkRight(this.targetTable, 4);
        this.session.getUser().checkRight(this.targetTable, 8);
        this.setCurrentRowNumber(0);
        GeneratedKeys generatedKeys = this.session.getGeneratedKeys();
        if (!this.valuesExpressionList.isEmpty()) {
            n = 0;
            generatedKeys.initialize(this.targetTable);
            int n2 = this.valuesExpressionList.size();
            for (int i = 0; i < n2; ++i) {
                this.setCurrentRowNumber(i + 1);
                generatedKeys.nextRow();
                Expression[] expressionArray = this.valuesExpressionList.get(i);
                Row row = this.targetTable.getTemplateRow();
                int n3 = this.columns.length;
                for (int j = 0; j < n3; ++j) {
                    Column column = this.columns[j];
                    int n4 = column.getColumnId();
                    Expression expression = expressionArray[j];
                    if (expression == null) continue;
                    try {
                        Value value = column.convert(expression.getValue(this.session));
                        row.setValue(n4, value);
                        if (!(expression instanceof SequenceValue)) continue;
                        generatedKeys.add(column);
                        continue;
                    }
                    catch (DbException dbException) {
                        throw this.setRow(dbException, n, Merge.getSQL(expressionArray));
                    }
                }
                this.merge(row);
                ++n;
            }
        } else {
            this.query.setNeverLazy(true);
            ResultInterface resultInterface = this.query.query(0);
            n = 0;
            this.targetTable.fire(this.session, 3, true);
            this.targetTable.lock(this.session, true, false);
            while (resultInterface.next()) {
                generatedKeys.nextRow();
                Value[] valueArray = resultInterface.currentRow();
                Row row = this.targetTable.getTemplateRow();
                this.setCurrentRowNumber(++n);
                for (int i = 0; i < this.columns.length; ++i) {
                    Column column = this.columns[i];
                    int n5 = column.getColumnId();
                    try {
                        Value value = column.convert(valueArray[i]);
                        row.setValue(n5, value);
                        continue;
                    }
                    catch (DbException dbException) {
                        throw this.setRow(dbException, n, Merge.getSQL(valueArray));
                    }
                }
                this.merge(row);
            }
            resultInterface.close();
            this.targetTable.fire(this.session, 3, false);
        }
        return n;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void merge(Row row) {
        Column[] columnArray;
        Object object;
        Column column;
        int n;
        ArrayList<Parameter> arrayList = this.update.getParameters();
        for (n = 0; n < this.columns.length; ++n) {
            column = this.columns[n];
            object = row.getValue(column.getColumnId());
            columnArray = arrayList.get(n);
            columnArray.setValue((Value)object);
        }
        for (n = 0; n < this.keys.length; ++n) {
            column = this.keys[n];
            object = row.getValue(column.getColumnId());
            if (object == null) {
                throw DbException.get(90081, column.getSQL());
            }
            columnArray = arrayList.get(this.columns.length + n);
            columnArray.setValue((Value)object);
        }
        n = this.update.update();
        if (n == 0) {
            try {
                this.targetTable.validateConvertUpdateSequence(this.session, row);
                boolean bl = this.targetTable.fireBeforeRow(this.session, null, row);
                if (bl) return;
                this.targetTable.lock(this.session, true, false);
                this.targetTable.addRow(this.session, row);
                this.session.getGeneratedKeys().confirmRow(row);
                this.session.log(this.targetTable, (short)0, row);
                this.targetTable.fireAfterRow(this.session, null, row, false);
                return;
            }
            catch (DbException dbException) {
                if (dbException.getErrorCode() != 23505 || (object = (Index)dbException.getSource()) == null) throw dbException;
                columnArray = object.getColumns();
                boolean bl = true;
                if (columnArray.length <= this.keys.length) {
                    for (int i = 0; i < columnArray.length; ++i) {
                        if (columnArray[i] == this.keys[i]) continue;
                        bl = false;
                        break;
                    }
                }
                if (!bl) throw dbException;
                throw DbException.get(90131, this.targetTable.getName());
            }
        } else {
            if (n == 1) return;
            throw DbException.get(23505, this.targetTable.getSQL());
        }
    }

    @Override
    public String getPlanSQL() {
        StatementBuilder statementBuilder = new StatementBuilder("MERGE INTO ");
        statementBuilder.append(this.targetTable.getSQL()).append('(');
        for (Column expressionArray : this.columns) {
            statementBuilder.appendExceptFirst(", ");
            statementBuilder.append(expressionArray.getSQL());
        }
        statementBuilder.append(')');
        if (this.keys != null) {
            statementBuilder.append(" KEY(");
            statementBuilder.resetCount();
            for (Column column : this.keys) {
                statementBuilder.appendExceptFirst(", ");
                statementBuilder.append(column.getSQL());
            }
            statementBuilder.append(')');
        }
        statementBuilder.append('\n');
        if (!this.valuesExpressionList.isEmpty()) {
            statementBuilder.append("VALUES ");
            int n = 0;
            for (Expression[] expressionArray : this.valuesExpressionList) {
                if (n++ > 0) {
                    statementBuilder.append(", ");
                }
                statementBuilder.append('(');
                statementBuilder.resetCount();
                for (Expression expression : expressionArray) {
                    statementBuilder.appendExceptFirst(", ");
                    if (expression == null) {
                        statementBuilder.append("DEFAULT");
                        continue;
                    }
                    statementBuilder.append(expression.getSQL());
                }
                statementBuilder.append(')');
            }
        } else {
            statementBuilder.append(this.query.getPlanSQL());
        }
        return statementBuilder.toString();
    }

    @Override
    public void prepare() {
        Object object;
        if (this.columns == null) {
            this.columns = !this.valuesExpressionList.isEmpty() && this.valuesExpressionList.get(0).length == 0 ? new Column[0] : this.targetTable.getColumns();
        }
        if (!this.valuesExpressionList.isEmpty()) {
            for (Expression[] object22 : this.valuesExpressionList) {
                if (object22.length != this.columns.length) {
                    throw DbException.get(21002);
                }
                for (int i = 0; i < object22.length; ++i) {
                    Expression expression = object22[i];
                    if (expression == null) continue;
                    object22[i] = expression.optimize(this.session);
                }
            }
        } else {
            this.query.prepare();
            if (this.query.getColumnCount() != this.columns.length) {
                throw DbException.get(21002);
            }
        }
        if (this.keys == null) {
            object = this.targetTable.getPrimaryKey();
            if (object == null) {
                throw DbException.get(90057, "PRIMARY KEY");
            }
            this.keys = object.getColumns();
        }
        object = new StatementBuilder("UPDATE ");
        ((StatementBuilder)object).append(this.targetTable.getSQL()).append(" SET ");
        for (Column column : this.columns) {
            ((StatementBuilder)object).appendExceptFirst(", ");
            ((StatementBuilder)object).append(column.getSQL()).append("=?");
        }
        ((StatementBuilder)object).append(" WHERE ");
        ((StatementBuilder)object).resetCount();
        for (Column column : this.keys) {
            ((StatementBuilder)object).appendExceptFirst(" AND ");
            ((StatementBuilder)object).append(column.getSQL()).append("=?");
        }
        String string = ((StatementBuilder)object).toString();
        this.update = this.session.prepare(string);
    }

    @Override
    public boolean isTransactional() {
        return true;
    }

    @Override
    public ResultInterface queryMeta() {
        return null;
    }

    @Override
    public int getType() {
        return 62;
    }

    @Override
    public boolean isCacheable() {
        return true;
    }

    public Table getTargetTable() {
        return this.targetTable;
    }

    public TableFilter getTargetTableFilter() {
        return this.targetTableFilter;
    }

    public void setTargetTableFilter(TableFilter tableFilter) {
        this.targetTableFilter = tableFilter;
        this.setTargetTable(tableFilter.getTable());
    }
}

