/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.shade.org.h2.command.ddl;

import com.alibaba.schedulerx.shade.org.h2.command.Prepared;
import com.alibaba.schedulerx.shade.org.h2.command.ddl.DefineCommand;
import com.alibaba.schedulerx.shade.org.h2.engine.Database;
import com.alibaba.schedulerx.shade.org.h2.engine.Session;
import com.alibaba.schedulerx.shade.org.h2.expression.Parameter;
import com.alibaba.schedulerx.shade.org.h2.result.ResultInterface;
import com.alibaba.schedulerx.shade.org.h2.table.Column;
import com.alibaba.schedulerx.shade.org.h2.table.Table;
import com.alibaba.schedulerx.shade.org.h2.table.TableType;
import com.alibaba.schedulerx.shade.org.h2.util.StatementBuilder;
import com.alibaba.schedulerx.shade.org.h2.value.Value;
import com.alibaba.schedulerx.shade.org.h2.value.ValueInt;
import com.alibaba.schedulerx.shade.org.h2.value.ValueNull;
import java.util.ArrayList;

public class Analyze
extends DefineCommand {
    private int sampleRows;
    private Table table;

    public Analyze(Session session) {
        super(session);
        this.sampleRows = session.getDatabase().getSettings().analyzeSample;
    }

    public void setTable(Table table) {
        this.table = table;
    }

    @Override
    public int update() {
        this.session.commit(true);
        this.session.getUser().checkAdmin();
        Database database = this.session.getDatabase();
        if (this.table != null) {
            Analyze.analyzeTable(this.session, this.table, this.sampleRows, true);
        } else {
            for (Table table : database.getAllTablesAndViews(false)) {
                Analyze.analyzeTable(this.session, table, this.sampleRows, true);
            }
        }
        return 0;
    }

    public static void analyzeTable(Session session, Table table, int n, boolean bl) {
        if (table.getTableType() != TableType.TABLE || table.isHidden() || session == null) {
            return;
        }
        if (!bl) {
            if (session.getDatabase().isSysTableLocked()) {
                return;
            }
            if (table.hasSelectTrigger()) {
                return;
            }
        }
        if (table.isTemporary() && !table.isGlobalTemporary() && session.findLocalTempTable(table.getName()) == null) {
            return;
        }
        if (table.isLockedExclusively() && !table.isLockedExclusivelyBy(session)) {
            return;
        }
        if (!session.getUser().hasRight(table, 1)) {
            return;
        }
        if (session.getCancel() != 0L) {
            return;
        }
        Column[] columnArray = table.getColumns();
        if (columnArray.length == 0) {
            return;
        }
        Database database = session.getDatabase();
        StatementBuilder statementBuilder = new StatementBuilder("SELECT ");
        for (Column i : columnArray) {
            statementBuilder.appendExceptFirst(", ");
            int value = i.getType();
            if (value == 15 || value == 16) {
                statementBuilder.append("MAX(NULL)");
                continue;
            }
            statementBuilder.append("SELECTIVITY(").append(i.getSQL()).append(')');
        }
        statementBuilder.append(" FROM ").append(table.getSQL());
        if (n > 0) {
            statementBuilder.append(" LIMIT ? SAMPLE_SIZE ? ");
        }
        String string = statementBuilder.toString();
        Prepared prepared = session.prepare(string);
        if (n > 0) {
            ArrayList<Parameter> resultInterface = prepared.getParameters();
            resultInterface.get(0).setValue(ValueInt.get(1));
            resultInterface.get(1).setValue(ValueInt.get(n));
        }
        ResultInterface resultInterface = prepared.query(0);
        resultInterface.next();
        for (int i = 0; i < columnArray.length; ++i) {
            Value value = resultInterface.currentRow()[i];
            if (value == ValueNull.INSTANCE) continue;
            int n2 = value.getInt();
            columnArray[i].setSelectivity(n2);
        }
        database.updateMeta(session, table);
    }

    public void setTop(int n) {
        this.sampleRows = n;
    }

    @Override
    public int getType() {
        return 21;
    }
}

