/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.shade.net.sf.json.util;

import com.alibaba.schedulerx.shade.net.sf.json.JSONException;
import com.alibaba.schedulerx.shade.net.sf.json.JsonConfig;
import com.alibaba.schedulerx.shade.org.apache.commons.beanutils.PropertyUtils;
import java.lang.reflect.Field;
import java.util.Map;

public abstract class PropertySetStrategy {
    public static final PropertySetStrategy DEFAULT = new DefaultPropertySetStrategy();

    public abstract void setProperty(Object var1, String var2, Object var3) throws JSONException;

    public void setProperty(Object bean, String key, Object value, JsonConfig jsonConfig) throws JSONException {
        this.setProperty(bean, key, value);
    }

    private static final class DefaultPropertySetStrategy
    extends PropertySetStrategy {
        private DefaultPropertySetStrategy() {
        }

        public void setProperty(Object bean, String key, Object value) throws JSONException {
            this.setProperty(bean, key, value, new JsonConfig());
        }

        public void setProperty(Object bean, String key, Object value, JsonConfig jsonConfig) throws JSONException {
            if (bean instanceof Map) {
                ((Map)bean).put(key, value);
            } else if (!jsonConfig.isIgnorePublicFields()) {
                try {
                    Field field = bean.getClass().getField(key);
                    if (field != null) {
                        field.set(bean, value);
                    }
                }
                catch (Exception e) {
                    this._setProperty(bean, key, value);
                }
            } else {
                this._setProperty(bean, key, value);
            }
        }

        private void _setProperty(Object bean, String key, Object value) {
            try {
                PropertyUtils.setSimpleProperty(bean, key, value);
            }
            catch (Exception e) {
                throw new JSONException(e);
            }
        }
    }
}

