/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.shade.com.zaxxer.hikari.util;

import com.alibaba.schedulerx.shade.com.zaxxer.hikari.util.IBagStateListener;
import com.alibaba.schedulerx.shade.com.zaxxer.hikari.util.IConcurrentBagEntry;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.AbstractQueuedLongSynchronizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConcurrentBag<T extends IConcurrentBagEntry> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConcurrentBag.class);
    protected final AbstractQueuedLongSynchronizer synchronizer;
    protected final CopyOnWriteArrayList<T> sharedList = new CopyOnWriteArrayList();
    protected final AtomicLong sequence;
    private final ThreadLocal<ArrayList<WeakReference<IConcurrentBagEntry>>> threadList;
    private final IBagStateListener listener;
    private volatile boolean closed;

    public ConcurrentBag(IBagStateListener listener) {
        this.synchronizer = this.createQueuedSynchronizer();
        this.sequence = new AtomicLong(1L);
        this.listener = listener;
        this.threadList = new ThreadLocal();
    }

    protected AbstractQueuedLongSynchronizer createQueuedSynchronizer() {
        throw new RuntimeException("createQueuedSynchronizer() method must be overridden");
    }

    public T borrow(long timeout, TimeUnit timeUnit) throws InterruptedException {
        if (!this.synchronizer.hasQueuedThreads()) {
            ArrayList<WeakReference<IConcurrentBagEntry>> list = this.threadList.get();
            if (list == null) {
                this.threadList.set(new ArrayList(16));
            } else {
                for (int i = list.size() - 1; i >= 0; --i) {
                    IConcurrentBagEntry bagEntry = (IConcurrentBagEntry)list.remove(i).get();
                    if (bagEntry == null || !bagEntry.state().compareAndSet(0, 1)) continue;
                    return (T)bagEntry;
                }
            }
        }
        timeout = timeUnit.toNanos(timeout);
        Future<Boolean> addItemFuture = null;
        long startScan = System.nanoTime();
        long originTimeout = timeout;
        while (true) {
            long startSeq = this.sequence.get();
            for (IConcurrentBagEntry bagEntry : this.sharedList) {
                if (!bagEntry.state().compareAndSet(0, 1)) continue;
                return (T)bagEntry;
            }
            if (startSeq < this.sequence.get()) continue;
            if (addItemFuture == null || addItemFuture.isDone()) {
                addItemFuture = this.listener.addBagItem();
            }
            if (!this.synchronizer.tryAcquireSharedNanos(startSeq, timeout)) {
                return null;
            }
            long elapsed = System.nanoTime() - startScan;
            timeout = originTimeout - Math.max(elapsed, 100L);
            if (timeout <= 1000L) break;
        }
        return null;
    }

    public void requite(T bagEntry) {
        if (bagEntry.state().compareAndSet(1, 0)) {
            ArrayList<WeakReference<IConcurrentBagEntry>> list = this.threadList.get();
            if (list != null) {
                list.add(new WeakReference<T>(bagEntry));
            }
            this.synchronizer.releaseShared(this.sequence.incrementAndGet());
        } else {
            LOGGER.warn("Attempt to remove an object from the bag that does not exist: {}", (Object)bagEntry.toString());
        }
    }

    public void add(T bagEntry) {
        if (this.closed) {
            LOGGER.info("ConcurrentBag has been closed, ignoring add()");
            throw new IllegalStateException("ConcurrentBag has been closed, ignoring add()");
        }
        this.sharedList.add(bagEntry);
        this.synchronizer.releaseShared(this.sequence.incrementAndGet());
    }

    public boolean remove(T bagEntry) {
        if (!(bagEntry.state().compareAndSet(1, -1) || bagEntry.state().compareAndSet(-2, -1) || this.closed)) {
            LOGGER.warn("Attempt to remove an object from the bag that was not borrowed or reserved: {}", (Object)bagEntry.toString());
            return false;
        }
        boolean removed = this.sharedList.remove(bagEntry);
        if (!removed && !this.closed) {
            LOGGER.warn("Attempt to remove an object from the bag that does not exist: {}", (Object)bagEntry.toString());
        }
        return removed;
    }

    public void close() {
        this.closed = true;
    }

    public List<T> values(int state) {
        ArrayList<IConcurrentBagEntry> list = new ArrayList<IConcurrentBagEntry>(this.sharedList.size());
        if (state == 1 || state == 0) {
            for (IConcurrentBagEntry reference : this.sharedList) {
                if (reference.state().get() != state) continue;
                list.add(reference);
            }
        }
        return list;
    }

    public boolean reserve(T bagEntry) {
        return bagEntry.state().compareAndSet(0, -2);
    }

    public void unreserve(T bagEntry) {
        long checkInSeq = this.sequence.incrementAndGet();
        if (bagEntry.state().compareAndSet(-2, 0)) {
            this.synchronizer.releaseShared(checkInSeq);
        } else {
            LOGGER.warn("Attempt to relinquish an object to the bag that was not reserved: {}", (Object)bagEntry.toString());
        }
    }

    public int getPendingQueue() {
        return this.synchronizer.getQueueLength();
    }

    public int getCount(int state) {
        int count = 0;
        for (IConcurrentBagEntry reference : this.sharedList) {
            if (reference.state().get() != state) continue;
            ++count;
        }
        return count;
    }

    public int size() {
        return this.sharedList.size();
    }

    public void dumpState() {
        for (IConcurrentBagEntry bagEntry : this.sharedList) {
            LOGGER.info(bagEntry.toString());
        }
    }
}

