/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.shade.com.taobao.spas.sdk.common.utils;

import com.alibaba.schedulerx.shade.com.taobao.spas.sdk.common.config.SpasConfigLoader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

public class SpasHttpUtils {
    private static int CONN_TIMEOUT_DEFAULT = 3000;
    private static int READ_TIMEOUT_DEFAULT = 10000;
    private static volatile int connTimeout = CONN_TIMEOUT_DEFAULT;
    private static volatile int readTimeout = READ_TIMEOUT_DEFAULT;
    private static volatile boolean httpsEnabled = false;
    private static volatile boolean clientAuthEnabled = false;
    private static volatile String trustCertPath;
    private static SSLSocketFactory ssf;
    private static HostnameVerifier hv;
    private static Boolean httpsInited;
    private static ConcurrentHashMap<String, Boolean> hosts;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void checkInitHttps() {
        if (httpsInited.booleanValue()) {
            return;
        }
        Boolean bl = httpsInited;
        synchronized (bl) {
            if (httpsInited.booleanValue()) {
                return;
            }
            try {
                TrustManager[] trustManagers = null;
                if (clientAuthEnabled) {
                    File file;
                    Collection<? extends Certificate> certs = null;
                    if (trustCertPath != null && (file = new File(trustCertPath)).exists() && file.isFile() && file.length() > 0L) {
                        CertificateFactory cf = CertificateFactory.getInstance("X.509");
                        FileInputStream caInput = new FileInputStream(trustCertPath);
                        try {
                            certs = cf.generateCertificates(caInput);
                        }
                        catch (CertificateException e) {
                        }
                        finally {
                            ((InputStream)caInput).close();
                        }
                    }
                    if (certs != null && !certs.isEmpty()) {
                        TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                        KeyStore ks = KeyStore.getInstance("JKS");
                        ks.load(null, null);
                        int index = 0;
                        for (X509Certificate x509Certificate : certs) {
                            ks.setCertificateEntry("provided-cert-" + index++, x509Certificate);
                        }
                        tmf.init(ks);
                        trustManagers = tmf.getTrustManagers();
                    }
                } else {
                    trustManagers = new TrustManager[]{new X509TrustManager(){

                        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                        }

                        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                        }

                        public X509Certificate[] getAcceptedIssuers() {
                            return null;
                        }
                    }};
                }
                SSLContext sc = SSLContext.getInstance("TLS");
                sc.init(null, trustManagers, new SecureRandom());
                ssf = sc.getSocketFactory();
                hv = HttpsURLConnection.getDefaultHostnameVerifier();
                HttpsURLConnection.setDefaultHostnameVerifier(new HostnameVerifier(){

                    public boolean verify(String hostname, SSLSession session) {
                        if (SpasHttpUtils.isIPv4(hostname)) {
                            return true;
                        }
                        return hv.verify(hostname, session);
                    }
                });
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            httpsInited = true;
        }
    }

    public static int getConnTimeout() {
        return connTimeout;
    }

    public static void setConnTimeout(int timeout) {
        connTimeout = timeout;
    }

    public static int getReadTimeout() {
        return readTimeout;
    }

    public static void setReadTimeout(int timeout) {
        readTimeout = timeout;
    }

    public static boolean isHttpsEnabled() {
        return httpsEnabled;
    }

    public static void setHttpsEnabled(boolean enabled) {
        httpsEnabled = enabled;
    }

    public static boolean isClientAuthEnabled() {
        return clientAuthEnabled;
    }

    public static void setClientAuthEnabled(boolean enabled) {
        clientAuthEnabled = enabled;
    }

    public static String getTrustCertPath() {
        return trustCertPath;
    }

    public static void setTrustCertPath(String path) {
        trustCertPath = path;
    }

    public static SSLSocketFactory getSSLSocketFactory() {
        SpasHttpUtils.checkInitHttps();
        return ssf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isIPv4(String host) {
        if (host == null || host.isEmpty()) {
            return false;
        }
        Boolean isIp = hosts.get(host);
        if (isIp != null) {
            return isIp;
        }
        try {
            String[] sections = host.split("\\.");
            if (sections.length != 4) {
                isIp = false;
                boolean bl = isIp;
                return bl;
            }
            for (String section : sections) {
                int value = Integer.MAX_VALUE;
                try {
                    value = Integer.parseInt(section);
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
                if (value >= 0 && value <= 256) continue;
                isIp = false;
                boolean bl = isIp;
                return bl;
            }
            isIp = true;
            boolean bl = isIp;
            return bl;
        }
        finally {
            hosts.putIfAbsent(host, isIp);
        }
    }

    static {
        httpsInited = false;
        hosts = new ConcurrentHashMap();
        connTimeout = Integer.valueOf(SpasConfigLoader.getProperty("spas.http.conn.timeout", String.valueOf(CONN_TIMEOUT_DEFAULT)));
        readTimeout = Integer.valueOf(SpasConfigLoader.getProperty("spas.http.read.timeout", String.valueOf(READ_TIMEOUT_DEFAULT)));
        String httpsConfig = SpasConfigLoader.getProperty("spas.https.enable");
        if (httpsConfig == null) {
            httpsConfig = SpasConfigLoader.getProperty("tls.enable");
        }
        httpsEnabled = "Y".equalsIgnoreCase(httpsConfig) || "true".equalsIgnoreCase(httpsConfig);
        clientAuthEnabled = "true".equalsIgnoreCase(SpasConfigLoader.getProperty("tls.client.authServer"));
        trustCertPath = SpasConfigLoader.getProperty("tls.client.trustCertPath");
    }
}

