/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.shade.com.taobao.spas.sdk.common.log;

import com.alibaba.schedulerx.shade.com.taobao.spas.sdk.common.log.SpasLogCode;
import com.alibaba.schedulerx.shade.com.taobao.spas.sdk.common.log.SpasLoggerFactory;
import com.taobao.middleware.logger.Logger;

public class SpasLogger {
    private static Logger logger = SpasLoggerFactory.getLogger(SpasLogger.class);

    public static void info(String s) {
        logger.info(s);
    }

    public static void info(String appName, String s) {
        logger.info(SpasLogger.formatAppName(appName), s);
    }

    public static void warn(String s) {
        logger.warn(s);
    }

    public static void warn(String appName, String s) {
        logger.warn(SpasLogger.formatAppName(appName), s);
    }

    public static void error(String s) {
        logger.error("", s);
    }

    public static void error(String appName, String s) {
        logger.error(SpasLogger.formatAppName(appName), "", s);
    }

    public static void error(String s, Throwable throwable) {
        logger.error("", s, throwable);
    }

    public static void error(String appName, String s, Throwable throwable) {
        logger.error(SpasLogger.formatAppName(appName), "", s, throwable);
    }

    public static void info(SpasLogCode code, String s) {
        logger.info(SpasLogger.formatLogMessage(code, s));
    }

    public static void info(SpasLogCode code, String appName, String s) {
        logger.info(SpasLogger.formatAppName(appName), SpasLogger.formatLogMessage(code, s));
    }

    public static void warn(SpasLogCode code, String s) {
        logger.warn(SpasLogger.formatLogMessage(code, s));
    }

    public static void warn(SpasLogCode code, String appName, String s) {
        logger.warn(SpasLogger.formatAppName(appName), SpasLogger.formatLogMessage(code, s));
    }

    public static void error(SpasLogCode code, String s) {
        logger.error("", SpasLogger.formatLogMessage(code, s));
    }

    public static void error(SpasLogCode code, String appName, String s) {
        logger.error(SpasLogger.formatAppName(appName), "", SpasLogger.formatLogMessage(code, s));
    }

    public static void error(SpasLogCode code, String s, Throwable throwable) {
        logger.error("", SpasLogger.formatLogMessage(code, s), throwable);
    }

    public static void error(SpasLogCode code, String appName, String s, Throwable throwable) {
        logger.error(SpasLogger.formatAppName(appName), "", SpasLogger.formatLogMessage(code, s), throwable);
    }

    private static String formatAppName(String appName) {
        return appName == null ? "" : appName;
    }

    private static String formatLogMessage(SpasLogCode code, String s) {
        return String.format("[SPAS-%04d] %s", code.getValue(), s);
    }
}

