/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.shade.com.aliyun.openservices.log.response;

import com.alibaba.schedulerx.shade.com.aliyun.openservices.log.common.ShipperTask;
import com.alibaba.schedulerx.shade.com.aliyun.openservices.log.common.ShipperTasksStatistic;
import com.alibaba.schedulerx.shade.com.aliyun.openservices.log.response.Response;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class GetShipperTasksResponse
extends Response {
    private static final long serialVersionUID = 4081210336385900737L;
    private int mCount = 0;
    private int mTotal = 0;
    private ShipperTasksStatistic mStatistic = null;
    private List<ShipperTask> mShipperTasks = null;

    public GetShipperTasksResponse(Map<String, String> headers, int count, int total, ShipperTasksStatistic statistic, List<ShipperTask> shipperTasks) {
        super(headers);
        this.mCount = count;
        this.mTotal = total;
        this.mStatistic = statistic;
        this.mShipperTasks = new ArrayList<ShipperTask>(shipperTasks);
    }

    public int GetCountTask() {
        return this.mCount;
    }

    public int GetTotalTask() {
        return this.mTotal;
    }

    public int GetRunningTaskCount() {
        return this.mStatistic.GetRunningTaskCount();
    }

    public int GetSuccessTaskCount() {
        return this.mStatistic.GetSuccessTaskCount();
    }

    public int GetFailTaskCount() {
        return this.mStatistic.GetFailTaskCount();
    }

    public List<ShipperTask> GetShipperTasks() {
        return new ArrayList<ShipperTask>(this.mShipperTasks);
    }

    public List<String> GetSuccessTaskIds() {
        return this.GetTaskIds("success");
    }

    public List<String> GetFailTaskIds() {
        return this.GetTaskIds("fail");
    }

    public List<String> GetRunningTaskIds() {
        return this.GetTaskIds("running");
    }

    private List<String> GetTaskIds(String status) {
        ArrayList<String> res = new ArrayList<String>();
        for (ShipperTask task : this.mShipperTasks) {
            if (!task.GetTaskStatus().equals(status)) continue;
            res.add(task.GetTaskId());
        }
        return res;
    }
}

