/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.shade.com.aliyun.openservices.log.common;

import com.alibaba.fastjson.annotation.JSONField;
import com.alibaba.schedulerx.shade.com.aliyun.openservices.log.common.DashboardBasedJobConfiguration;
import com.alibaba.schedulerx.shade.com.aliyun.openservices.log.common.DingTalkNotification;
import com.alibaba.schedulerx.shade.com.aliyun.openservices.log.common.EmailNotification;
import com.alibaba.schedulerx.shade.com.aliyun.openservices.log.common.Notification;
import com.alibaba.schedulerx.shade.com.aliyun.openservices.log.common.NotificationType;
import com.alibaba.schedulerx.shade.com.aliyun.openservices.log.util.JsonUtils;
import com.alibaba.schedulerx.shade.net.sf.json.JSONObject;

public class ReportConfiguration
extends DashboardBasedJobConfiguration {
    @JSONField
    private boolean enableWatermark;
    @JSONField
    private boolean allowAnonymousAccess;
    @JSONField
    private String language;

    public boolean getEnableWatermark() {
        return this.enableWatermark;
    }

    public void setEnableWatermark(boolean enableWatermark) {
        this.enableWatermark = enableWatermark;
    }

    public boolean getAllowAnonymousAccess() {
        return this.allowAnonymousAccess;
    }

    public void setAllowAnonymousAccess(boolean allowAnonymousAccess) {
        this.allowAnonymousAccess = allowAnonymousAccess;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    @Override
    Notification makeQualifiedNotification(NotificationType type) {
        switch (type) {
            case DING_TALK: {
                return new DingTalkNotification();
            }
            case EMAIL: {
                return new EmailNotification();
            }
        }
        throw new IllegalArgumentException("Unimplemented report notification type: " + (Object)((Object)type));
    }

    @Override
    public void deserialize(JSONObject value) {
        super.deserialize(value);
        this.enableWatermark = JsonUtils.readBool(value, "enableWatermark", false);
        this.allowAnonymousAccess = JsonUtils.readBool(value, "allowAnonymousAccess", false);
        this.language = JsonUtils.readOptionalString(value, "language");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReportConfiguration that = (ReportConfiguration)o;
        if (this.getEnableWatermark() != that.getEnableWatermark()) {
            return false;
        }
        if (this.getAllowAnonymousAccess() != that.getAllowAnonymousAccess()) {
            return false;
        }
        return this.getLanguage() != null ? this.getLanguage().equals(that.getLanguage()) : that.getLanguage() == null;
    }

    public int hashCode() {
        int result = this.getEnableWatermark() ? 1 : 0;
        result = 31 * result + (this.getAllowAnonymousAccess() ? 1 : 0);
        result = 31 * result + (this.getLanguage() != null ? this.getLanguage().hashCode() : 0);
        return result;
    }

    public String toString() {
        return "ReportConfiguration{enableWatermark=" + this.enableWatermark + ", allowAnonymousAccess=" + this.allowAnonymousAccess + ", language='" + this.language + '\'' + '}';
    }
}

