/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.sdk.http;

import com.alibaba.fastjson.JSON;
import com.alibaba.schedulerx.common.domain.JSONResult;
import com.alibaba.schedulerx.common.domain.enums.ResponseCodeEnum;
import com.alibaba.schedulerx.common.exception.BaseBizException;
import com.alibaba.schedulerx.common.sdk.common.SchedulerXResult;
import com.alibaba.schedulerx.common.sdk.request.BaseRequest;
import com.alibaba.schedulerx.common.sdk.response.BaseResponse;
import com.alibaba.schedulerx.common.util.ExceptionUtil;
import com.alibaba.schedulerx.shade.com.mashape.unirest.http.HttpResponse;
import com.alibaba.schedulerx.shade.com.mashape.unirest.http.JsonNode;
import com.alibaba.schedulerx.shade.com.mashape.unirest.http.Unirest;
import com.alibaba.schedulerx.shade.com.mashape.unirest.request.HttpRequestWithBody;
import com.alibaba.schedulerx.shade.org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import com.alibaba.schedulerx.shade.org.apache.http.impl.client.CloseableHttpClient;
import com.alibaba.schedulerx.shade.org.apache.http.impl.client.HttpClients;
import com.alibaba.schedulerx.worker.log.LogFactory;
import com.alibaba.schedulerx.worker.log.Logger;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.Map;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public class HttpClientUtil {
    private static final Logger logger = LogFactory.getLogger("openapi");

    public static <T extends BaseResponse> SchedulerXResult<T> getResponse(BaseRequest<T> request, String domain, Map<String, String> headers) {
        SchedulerXResult<BaseResponse> result;
        block5: {
            result = new SchedulerXResult<BaseResponse>();
            try {
                String url = domain + request.getUrlPath();
                HttpResponse<JsonNode> jsonResponse = ((HttpRequestWithBody)Unirest.post(url).headers((Map)headers)).fields(request.getParameterMap()).asJson();
                if (jsonResponse != null) {
                    JSONResult jsonResult = (JSONResult)JSON.parseObject((String)jsonResponse.getBody().toString(), JSONResult.class);
                    result = new SchedulerXResult(jsonResult);
                    if (jsonResult.isSuccess()) {
                        BaseResponse resp = (BaseResponse)JSON.parseObject((String)JSON.toJSONString((Object)jsonResult.getData()), request.getResponseClass());
                        result.setData(resp);
                        logger.info("getResponse success response: " + jsonResult.getData());
                    } else {
                        logger.error("getResponse fail response: " + jsonResult);
                    }
                    break block5;
                }
                throw new BaseBizException(ResponseCodeEnum.SYSTEM_ERROR.getCode(), "response is null.");
            }
            catch (Throwable e) {
                logger.error("getResponse error, request: " + request, e);
                result.setCode(-10000);
                result.setMessage(ExceptionUtil.getMessage(e));
            }
        }
        return result;
    }

    static {
        try {
            TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }

                @Override
                public void checkClientTrusted(X509Certificate[] certs, String authType) {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] certs, String authType) {
                }
            }};
            SSLContext sslcontext = SSLContext.getInstance("SSL");
            sslcontext.init(null, trustAllCerts, new SecureRandom());
            HttpsURLConnection.setDefaultSSLSocketFactory(sslcontext.getSocketFactory());
            SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(sslcontext);
            CloseableHttpClient httpclient = HttpClients.custom().setSSLSocketFactory(sslsf).build();
            Unirest.setHttpClient(httpclient);
        }
        catch (Throwable e) {
            logger.error("SSL init error.", e);
        }
    }
}

