/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.common.domain.enums;

import com.alibaba.schedulerx.shade.com.google.common.collect.Maps;
import com.alibaba.schedulerx.shade.org.apache.commons.lang.StringUtils;
import java.util.Map;

public enum EnvTypeEnum {
    OXS("OXS", "\u963f\u91cc\u4e91OXS"),
    ALIBABA("ALIBABA", "\u96c6\u56e2"),
    UNKNOWN("UNKNOWN", "\u672a\u77e5\u73af\u5883");

    private final String code;
    private final String cnDesc;
    private static Map<String, EnvTypeEnum> CACHE;

    private EnvTypeEnum(String code, String cnDesc) {
        this.code = code;
        this.cnDesc = cnDesc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EnvTypeEnum getByCode(String code) {
        if (CACHE.isEmpty()) {
            Map<String, EnvTypeEnum> map = CACHE;
            synchronized (map) {
                if (CACHE.isEmpty()) {
                    for (EnvTypeEnum value : EnvTypeEnum.values()) {
                        CACHE.put(value.code, value);
                    }
                }
            }
        }
        return CACHE.get(StringUtils.upperCase(code));
    }

    public String getCode() {
        return this.code;
    }

    public String getCnDesc() {
        return this.cnDesc;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("{code=").append(this.code);
        builder.append(",cnDesc=").append(this.cnDesc);
        builder.append("}");
        return builder.toString();
    }

    static {
        CACHE = Maps.newHashMap();
    }
}

