/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.oss.common.auth;

import com.aliyun.oss.common.auth.BasicCredentials;
import com.aliyun.oss.common.auth.Credentials;
import com.aliyun.oss.common.auth.CredentialsProvider;
import com.aliyun.oss.common.utils.LogUtils;
import com.aliyuncs.AcsRequest;
import com.aliyuncs.DefaultAcsClient;
import com.aliyuncs.auth.AlibabaCloudCredentials;
import com.aliyuncs.auth.AlibabaCloudCredentialsProvider;
import com.aliyuncs.auth.StaticCredentialsProvider;
import com.aliyuncs.auth.sts.AssumeRoleRequest;
import com.aliyuncs.auth.sts.AssumeRoleResponse;
import com.aliyuncs.exceptions.ClientException;
import com.aliyuncs.profile.IClientProfile;

public class STSAssumeRoleSessionCredentialsProvider
implements CredentialsProvider {
    private DefaultAcsClient ramClient;
    private String roleArn;
    private String roleSessionName;
    private BasicCredentials credentials;
    private long expiredDurationSeconds = 3600L;
    private double expiredFactor = 0.8;

    public STSAssumeRoleSessionCredentialsProvider(AlibabaCloudCredentials longLivedCredentials, String roleArn, IClientProfile clientProfile) {
        this((AlibabaCloudCredentialsProvider)new StaticCredentialsProvider(longLivedCredentials), roleArn, clientProfile);
    }

    public STSAssumeRoleSessionCredentialsProvider(AlibabaCloudCredentialsProvider longLivedCredentialsProvider, String roleArn, IClientProfile clientProfile) {
        if (roleArn == null) {
            throw new NullPointerException("You must specify a value for roleArn.");
        }
        this.roleArn = roleArn;
        this.roleSessionName = STSAssumeRoleSessionCredentialsProvider.getNewRoleSessionName();
        this.ramClient = new DefaultAcsClient(clientProfile, longLivedCredentialsProvider);
    }

    public STSAssumeRoleSessionCredentialsProvider withRoleSessionName(String roleSessionName) {
        this.roleSessionName = roleSessionName;
        return this;
    }

    public STSAssumeRoleSessionCredentialsProvider withExpiredFactor(double expiredFactor) {
        this.expiredFactor = expiredFactor;
        return this;
    }

    public STSAssumeRoleSessionCredentialsProvider withExpiredDuration(long expiredDurationSeconds) {
        if (expiredDurationSeconds < 900L || expiredDurationSeconds > 3600L) {
            throw new IllegalArgumentException("Assume Role session duration should be in the range of 15min - 1hour");
        }
        this.expiredDurationSeconds = expiredDurationSeconds;
        return this;
    }

    public static String getNewRoleSessionName() {
        return "aliyun-java-sdk-" + System.currentTimeMillis();
    }

    @Override
    public void setCredentials(Credentials creds) {
    }

    @Override
    public Credentials getCredentials() {
        if (this.credentials == null || this.credentials.willSoonExpire()) {
            this.credentials = this.getNewSessionCredentials();
        }
        return this.credentials;
    }

    private BasicCredentials getNewSessionCredentials() {
        AssumeRoleRequest assumeRoleRequest = new AssumeRoleRequest();
        assumeRoleRequest.setRoleArn(this.roleArn);
        assumeRoleRequest.setRoleSessionName(this.roleSessionName);
        assumeRoleRequest.setDurationSeconds(Long.valueOf(this.expiredDurationSeconds));
        AssumeRoleResponse response = null;
        try {
            response = (AssumeRoleResponse)this.ramClient.getAcsResponse((AcsRequest)assumeRoleRequest);
        }
        catch (ClientException e) {
            LogUtils.logException("RamClient.getAcsResponse Exception:", e);
            return null;
        }
        return new BasicCredentials(response.getCredentials().getAccessKeyId(), response.getCredentials().getAccessKeySecret(), response.getCredentials().getSecurityToken(), this.expiredDurationSeconds).withExpiredFactor(this.expiredFactor);
    }
}

