/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.oss.model;

import com.aliyun.oss.common.utils.RangeSpec;
import com.aliyun.oss.event.ProgressListener;
import com.aliyun.oss.model.GetObjectRequest;
import com.aliyun.oss.model.InputSerialization;
import com.aliyun.oss.model.OutputSerialization;
import com.aliyun.oss.model.SelectContentFormat;
import java.security.InvalidParameterException;

public class SelectObjectRequest
extends GetObjectRequest {
    private static final String LINE_RANGE_PREFIX = "line-range=";
    private static final String SPLIT_RANGE_PREFIX = "split-range=";
    private String expression;
    private boolean skipPartialDataRecord = false;
    private long maxSkippedRecordsAllowed = 0L;
    private ExpressionType expressionType = ExpressionType.SQL;
    private InputSerialization inputSerialization = new InputSerialization();
    private OutputSerialization outputSerialization = new OutputSerialization();
    private ProgressListener selectProgressListener;
    private long[] lineRange;
    private long[] splitRange;

    public SelectObjectRequest(String bucketName, String key) {
        super(bucketName, key);
        this.setProcess("csv/select");
    }

    public long[] getLineRange() {
        return this.lineRange;
    }

    public void setLineRange(long startLine, long endLine) {
        this.lineRange = new long[]{startLine, endLine};
    }

    public SelectObjectRequest withLineRange(long startLine, long endLine) {
        this.setLineRange(startLine, endLine);
        return this;
    }

    public long[] getSplitRange() {
        return this.splitRange;
    }

    public void setSplitRange(long startSplit, long endSplit) {
        this.splitRange = new long[]{startSplit, endSplit};
    }

    public SelectObjectRequest withSplitRange(long startSplit, long endSplit) {
        this.setSplitRange(startSplit, endSplit);
        return this;
    }

    @Override
    public long[] getRange() {
        return null;
    }

    @Override
    public void setRange(long start, long end) throws InvalidParameterException {
        throw new InvalidParameterException("Select object does not support byte range now.");
    }

    public String lineRangeToString(long[] range) {
        return this.rangeToString(LINE_RANGE_PREFIX, range);
    }

    public String splitRangeToString(long[] range) {
        return this.rangeToString(SPLIT_RANGE_PREFIX, range);
    }

    public String rangeToString(String rangePrefix, long[] range) {
        RangeSpec rangeSpec = RangeSpec.parse(range);
        switch (rangeSpec.getType()) {
            case NORMAL_RANGE: {
                return String.format("%s%d-%d", rangePrefix, rangeSpec.getStart(), rangeSpec.getEnd());
            }
            case START_TO: {
                return String.format("%s%d-", rangePrefix, rangeSpec.getStart());
            }
            case TO_END: {
                return String.format("%s-%d", rangePrefix, rangeSpec.getEnd());
            }
        }
        return null;
    }

    public String getExpression() {
        return this.expression;
    }

    public void setExpression(String expression) {
        this.expression = expression;
    }

    public SelectObjectRequest withExpression(String expression) {
        this.setExpression(expression);
        return this;
    }

    public boolean isSkipPartialDataRecord() {
        return this.skipPartialDataRecord;
    }

    public void setSkipPartialDataRecord(boolean skipPartialDataRecord) {
        this.skipPartialDataRecord = skipPartialDataRecord;
    }

    public SelectObjectRequest withSkipPartialDataRecord(boolean skipPartialDataRecord) {
        this.setSkipPartialDataRecord(skipPartialDataRecord);
        return this;
    }

    public long getMaxSkippedRecordsAllowed() {
        return this.maxSkippedRecordsAllowed;
    }

    public void setMaxSkippedRecordsAllowed(long maxSkippedRecordsAllowed) {
        this.maxSkippedRecordsAllowed = maxSkippedRecordsAllowed;
    }

    public SelectObjectRequest withMaxSkippedRecordsAllowed(long maxSkippedRecordsAllowed) {
        this.setMaxSkippedRecordsAllowed(maxSkippedRecordsAllowed);
        return this;
    }

    public ExpressionType getExpressionType() {
        return this.expressionType;
    }

    public InputSerialization getInputSerialization() {
        return this.inputSerialization;
    }

    public void setInputSerialization(InputSerialization inputSerialization) {
        if (inputSerialization.getSelectContentFormat() == SelectContentFormat.CSV) {
            this.setProcess("csv/select");
        } else {
            this.setProcess("json/select");
        }
        this.inputSerialization = inputSerialization;
    }

    public SelectObjectRequest withInputSerialization(InputSerialization inputSerialization) {
        this.setInputSerialization(inputSerialization);
        return this;
    }

    public OutputSerialization getOutputSerialization() {
        return this.outputSerialization;
    }

    public void setOutputSerialization(OutputSerialization outputSerialization) {
        this.outputSerialization = outputSerialization;
    }

    public SelectObjectRequest withOutputSerialization(OutputSerialization outputSerialization) {
        this.setOutputSerialization(outputSerialization);
        return this;
    }

    public ProgressListener getSelectProgressListener() {
        return this.selectProgressListener;
    }

    public void setSelectProgressListener(ProgressListener selectProgressListener) {
        this.selectProgressListener = selectProgressListener;
    }

    public SelectObjectRequest withSelectProgressListener(ProgressListener selectProgressListener) {
        this.setSelectProgressListener(selectProgressListener);
        return this;
    }

    public static enum ExpressionType {
        SQL;

    }
}

