/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.oss.common.comm.async;

import com.aliyun.oss.ClientException;
import com.aliyun.oss.common.comm.async.AsyncPostProcess;
import com.aliyun.oss.common.comm.async.CallbackImpl;
import com.aliyun.oss.common.utils.CRC64;
import com.aliyun.oss.common.utils.IOUtils;
import com.aliyun.oss.common.utils.LogUtils;
import com.aliyun.oss.internal.OSSUtils;
import com.aliyun.oss.model.OSSObject;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.CheckedInputStream;

public class AsyncGetOperationToFilePostProcess
extends AsyncPostProcess<OSSObject> {
    private File file;

    public AsyncGetOperationToFilePostProcess(File file) {
        this.file = file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void postProcess(OSSObject ossObject, CallbackImpl callback) {
        InputStream instream = ossObject.getObjectContent();
        CRC64 crc = new CRC64();
        CheckedInputStream checkedInputstream = new CheckedInputStream(instream, crc);
        ossObject.setObjectContent(checkedInputstream);
        BufferedOutputStream outputStream = null;
        try {
            int bytesRead;
            outputStream = new BufferedOutputStream(new FileOutputStream(this.file));
            byte[] buffer = new byte[8192];
            while ((bytesRead = ossObject.getObjectContent().read(buffer)) != -1) {
                ((OutputStream)outputStream).write(buffer, 0, bytesRead);
            }
            if (callback.getClientConfiguration().isCrcCheckEnabled() && callback.getRequest().getHeaders().get("Range") != null) {
                Long clientCRC = IOUtils.getCRCValue(ossObject.getObjectContent());
                OSSUtils.checkChecksum(clientCRC, ossObject.getServerCRC(), ossObject.getRequestId());
            }
            callback.setWrappedResult(ossObject.getObjectMetadata());
        }
        catch (IOException ex) {
            try {
                LogUtils.logException("[Post Process]:Cannot read object content stream: ", ex);
                callback.setException(new ClientException(OSSUtils.OSS_RESOURCE_MANAGER.getString("CannotReadContentStream"), ex));
            }
            catch (Throwable throwable) {
                IOUtils.safeClose(outputStream);
                IOUtils.safeClose(ossObject.getObjectContent());
                throw throwable;
            }
            IOUtils.safeClose(outputStream);
            IOUtils.safeClose(ossObject.getObjectContent());
        }
        IOUtils.safeClose(outputStream);
        IOUtils.safeClose(ossObject.getObjectContent());
    }
}

