/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.oss.common.comm;

import com.aliyun.oss.ClientConfiguration;
import com.aliyun.oss.ClientException;
import com.aliyun.oss.OSSException;
import com.aliyun.oss.common.comm.ExecutionContext;
import com.aliyun.oss.common.comm.HttpRequestFactory;
import com.aliyun.oss.common.comm.RequestMessage;
import com.aliyun.oss.common.comm.ResponseMessage;
import com.aliyun.oss.common.comm.RetryStrategy;
import com.aliyun.oss.common.comm.ServiceClient;
import com.aliyun.oss.common.comm.async.AsyncOperationManager;
import com.aliyun.oss.common.comm.async.CallbackImpl;
import com.aliyun.oss.common.utils.ExceptionFactory;
import com.aliyun.oss.common.utils.HttpUtil;
import com.aliyun.oss.common.utils.IOUtils;
import com.aliyun.oss.common.utils.LogUtils;
import com.aliyun.oss.model.OSSFuture;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import okhttp3.Authenticator;
import okhttp3.Call;
import okhttp3.ConnectionPool;
import okhttp3.Credentials;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.Route;

public class DefaultServiceClient
extends ServiceClient {
    protected static HttpRequestFactory httpRequestFactory = new HttpRequestFactory();
    protected OkHttpClient httpClient;

    public DefaultServiceClient(ClientConfiguration config) {
        super(config);
        ConnectionPool connectionPool = new ConnectionPool(config.getMaxIdleConnections(), config.getIdleConnectionTime(), TimeUnit.MILLISECONDS);
        OkHttpClient.Builder builder = new OkHttpClient.Builder().followRedirects(false).followSslRedirects(false).connectTimeout((long)config.getConnectionTimeout(), TimeUnit.MILLISECONDS).readTimeout((long)config.getReadTimeout(), TimeUnit.MILLISECONDS).writeTimeout((long)config.getWriteTimeout(), TimeUnit.MILLISECONDS).retryOnConnectionFailure(true).connectionPool(connectionPool);
        builder.hostnameVerifier(new HostnameVerifier(){

            @Override
            public boolean verify(String hostname, SSLSession session) {
                return true;
            }
        });
        TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

            @Override
            public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return new X509Certificate[0];
            }
        }};
        SSLSocketFactory sslSocketFactory = null;
        try {
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(null, trustAllCerts, new SecureRandom());
            sslSocketFactory = sslContext.getSocketFactory();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        builder.sslSocketFactory(sslSocketFactory, (X509TrustManager)trustAllCerts[0]);
        String proxyHost = config.getProxyHost();
        int proxyPort = config.getProxyPort();
        if (proxyHost != null && proxyPort > 0) {
            Proxy proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(proxyHost, proxyPort));
            final String proxyUsername = config.getProxyUsername();
            final String proxyPassword = config.getProxyPassword();
            Authenticator authenticator = new Authenticator(){

                public Request authenticate(Route route, Response response) throws IOException {
                    if (this.responseCount(response) >= 3) {
                        return null;
                    }
                    String credential = Credentials.basic((String)proxyUsername, (String)proxyPassword);
                    return response.request().newBuilder().header("Proxy-Authorization", credential).build();
                }

                private int responseCount(Response response) {
                    int result = 1;
                    while ((response = response.priorResponse()) != null) {
                        ++result;
                    }
                    return result;
                }
            };
            builder.proxy(proxy);
            builder.proxyAuthenticator(authenticator);
        }
        this.httpClient = builder.build();
        this.httpClient.dispatcher().setMaxRequests(config.getMaxConcurrentRequest());
        this.httpClient.dispatcher().setMaxRequestsPerHost(config.getMaxConcurrentRequest());
    }

    @Override
    protected ResponseMessage sendRequestCore(ServiceClient.Request request, ExecutionContext context) throws IOException {
        Response response;
        boolean writeTimeChanged;
        Request httpRequest = httpRequestFactory.createHttpRequest(request, context);
        boolean connectionTimeChanged = request.getConnectionTimeout() > 0 && request.getConnectionTimeout() != this.config.getConnectionTimeout();
        boolean readTimeChanged = request.getReadTimeout() > 0 && request.getReadTimeout() != this.config.getReadTimeout();
        boolean bl = writeTimeChanged = request.getWriteTimeout() > 0 && request.getWriteTimeout() != this.config.getWriteTimeout();
        OkHttpClient client = connectionTimeChanged || readTimeChanged || writeTimeChanged ? this.httpClient.newBuilder().connectTimeout(connectionTimeChanged ? (long)request.getConnectionTimeout() : (long)this.config.getConnectionTimeout(), TimeUnit.MILLISECONDS).readTimeout(readTimeChanged ? (long)request.getReadTimeout() : (long)this.config.getReadTimeout(), TimeUnit.MILLISECONDS).writeTimeout(writeTimeChanged ? (long)request.getWriteTimeout() : (long)this.config.getWriteTimeout(), TimeUnit.MILLISECONDS).build() : this.httpClient;
        Call call = client.newCall(httpRequest);
        try {
            response = call.execute();
        }
        catch (IOException ex) {
            call.cancel();
            throw ExceptionFactory.createNetworkException(ex);
        }
        return DefaultServiceClient.buildResponse(request, response);
    }

    @Override
    protected <T, RESULT> OSSFuture<RESULT> asyncSendRequestCore(ServiceClient.Request request, ExecutionContext context, CallbackImpl<T, RESULT> callback) {
        boolean writeTimeChanged;
        Request httpRequest = httpRequestFactory.createHttpRequest(request, context);
        boolean connectionTimeChanged = request.getConnectionTimeout() > 0 && request.getConnectionTimeout() != this.config.getConnectionRequestTimeout();
        boolean readTimeChanged = request.getReadTimeout() > 0 && request.getReadTimeout() != this.config.getReadTimeout();
        boolean bl = writeTimeChanged = request.getWriteTimeout() > 0 && request.getWriteTimeout() != this.config.getWriteTimeout();
        OkHttpClient client = connectionTimeChanged || readTimeChanged || writeTimeChanged ? this.httpClient.newBuilder().connectTimeout(connectionTimeChanged ? (long)request.getConnectionTimeout() : (long)this.config.getConnectionTimeout(), TimeUnit.MILLISECONDS).readTimeout(readTimeChanged ? (long)request.getReadTimeout() : (long)this.config.getReadTimeout(), TimeUnit.MILLISECONDS).writeTimeout(writeTimeChanged ? (long)request.getWriteTimeout() : (long)this.config.getWriteTimeout(), TimeUnit.MILLISECONDS).build() : this.httpClient;
        OSSFuture futureTask = new OSSFuture();
        callback.setRequest(request);
        callback.setContext(context);
        AsyncOperationManager.put(futureTask, callback);
        Call call = client.newCall(httpRequest);
        call.enqueue(callback);
        return futureTask;
    }

    public static ResponseMessage buildResponse(ServiceClient.Request request, Response httpResponse) throws IOException {
        assert (httpResponse != null);
        ResponseMessage response = new ResponseMessage(request);
        response.setUrl(request.getUri());
        response.setHttpResponse(httpResponse);
        response.setStatusCode(httpResponse.code());
        if (response.isSuccessful()) {
            response.setContent(httpResponse.body().byteStream());
        } else {
            DefaultServiceClient.readAndSetErrorResponse(httpResponse.body().byteStream(), response);
        }
        for (int index = 0; index < httpResponse.headers().size(); ++index) {
            String name = httpResponse.headers().name(index);
            String value = httpResponse.headers().value(index);
            if ("Content-Length".equals(name)) {
                response.setContentLength(Long.parseLong(value));
            }
            response.addHeader(name, value);
        }
        HttpUtil.convertHeaderCharsetFromIso88591(response.getHeaders());
        return response;
    }

    private static void readAndSetErrorResponse(InputStream originalContent, ResponseMessage response) throws IOException {
        byte[] contentBytes = IOUtils.readStreamAsByteArray(originalContent);
        response.setErrorResponseAsString(new String(contentBytes));
        response.setContent(new ByteArrayInputStream(contentBytes));
    }

    @Override
    protected RetryStrategy getDefaultRetryStrategy() {
        return new DefaultRetryStrategy();
    }

    @Override
    public void shutdown() {
        try {
            if (this.httpClient.dispatcher().executorService() != null) {
                this.httpClient.dispatcher().executorService().shutdown();
            }
            if (this.httpClient.connectionPool() != null) {
                this.httpClient.connectionPool().evictAll();
            }
            if (this.httpClient.cache() != null) {
                this.httpClient.cache().close();
            }
        }
        catch (IOException e) {
            LogUtils.logException("shutdown throw exception: ", e);
        }
    }

    private static class DefaultRetryStrategy
    extends RetryStrategy {
        private DefaultRetryStrategy() {
        }

        @Override
        public boolean shouldRetry(Exception ex, RequestMessage request, ResponseMessage response, int retries) {
            int statusCode;
            String errorCode;
            if (ex instanceof ClientException) {
                errorCode = ((ClientException)ex).getErrorCode();
                if (errorCode.equals("ConnectionTimeout") || errorCode.equals("SocketTimeout") || errorCode.equals("ConnectionRefused") || errorCode.equals("UnknownHost") || errorCode.equals("SocketException")) {
                    return true;
                }
                if (errorCode.equals("NonRepeatableRequest")) {
                    return false;
                }
            }
            if (ex instanceof OSSException && (errorCode = ((OSSException)ex).getErrorCode()).equals("InvalidResponse")) {
                return false;
            }
            return response != null && ((statusCode = response.getStatusCode()) == 500 || statusCode == 503);
        }
    }
}

