/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.oss.common.comm;

import com.aliyun.oss.ClientConfiguration;
import com.aliyun.oss.ClientException;
import com.aliyun.oss.OSSException;
import com.aliyun.oss.common.comm.ExecutionContext;
import com.aliyun.oss.common.comm.HttpRequestFactory;
import com.aliyun.oss.common.comm.IdleConnectionReaper;
import com.aliyun.oss.common.comm.RequestMessage;
import com.aliyun.oss.common.comm.ResponseMessage;
import com.aliyun.oss.common.comm.RetryStrategy;
import com.aliyun.oss.common.comm.ServiceClient;
import com.aliyun.oss.common.utils.ExceptionFactory;
import com.aliyun.oss.common.utils.HttpUtil;
import com.aliyun.oss.common.utils.IOUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.codec.binary.Base64;
import org.apache.http.Header;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.NTCredentials;
import org.apache.http.client.AuthCache;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.PoolingClientConnectionManager;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;

public class DefaultServiceClient
extends ServiceClient {
    protected static HttpRequestFactory httpRequestFactory = new HttpRequestFactory();
    protected HttpClient httpClient;
    protected ClientConnectionManager connectionManager = this.createHttpClientConnectionManager();
    protected CredentialsProvider credentialsProvider;
    protected HttpHost proxyHttpHost;
    protected AuthCache authCache;

    public DefaultServiceClient(ClientConfiguration config) {
        super(config);
        this.httpClient = this.createHttpClient(this.connectionManager);
        String proxyHost = config.getProxyHost();
        int proxyPort = config.getProxyPort();
        if (proxyHost != null && proxyPort > 0) {
            this.proxyHttpHost = new HttpHost(proxyHost, proxyPort);
            this.httpClient.getParams().setParameter("http.route.default-proxy", (Object)this.proxyHttpHost);
            String proxyUsername = config.getProxyUsername();
            String proxyPassword = config.getProxyPassword();
            String proxyDomain = config.getProxyDomain();
            String proxyWorkstation = config.getProxyWorkstation();
            if (proxyUsername != null && proxyPassword != null) {
                this.credentialsProvider = new BasicCredentialsProvider();
                this.credentialsProvider.setCredentials(new AuthScope(proxyHost, proxyPort), (Credentials)new NTCredentials(proxyUsername, proxyPassword, proxyWorkstation, proxyDomain));
                this.authCache = new BasicAuthCache();
                this.authCache.put(this.proxyHttpHost, (AuthScheme)new BasicScheme());
            }
        }
    }

    @Override
    public ResponseMessage sendRequestCore(ServiceClient.Request request, ExecutionContext context) throws IOException {
        HttpRequestBase httpRequest = httpRequestFactory.createHttpRequest(request, context);
        this.setProxyAuthorizationIfNeed(httpRequest);
        HttpContext httpContext = this.createHttpContext();
        HttpResponse httpResponse = null;
        try {
            httpResponse = this.httpClient.execute((HttpUriRequest)httpRequest, httpContext);
        }
        catch (IOException ex) {
            httpRequest.abort();
            throw ExceptionFactory.createNetworkException(ex);
        }
        return DefaultServiceClient.buildResponse(request, httpResponse);
    }

    protected static ResponseMessage buildResponse(ServiceClient.Request request, HttpResponse httpResponse) throws IOException {
        assert (httpResponse != null);
        ResponseMessage response = new ResponseMessage(request);
        response.setUrl(request.getUri());
        response.setHttpResponse(httpResponse);
        if (httpResponse.getStatusLine() != null) {
            response.setStatusCode(httpResponse.getStatusLine().getStatusCode());
        }
        if (httpResponse.getEntity() != null) {
            if (response.isSuccessful()) {
                response.setContent(httpResponse.getEntity().getContent());
            } else {
                DefaultServiceClient.readAndSetErrorResponse(httpResponse.getEntity().getContent(), response);
            }
        }
        for (Header header : httpResponse.getAllHeaders()) {
            if ("Content-Length".equals(header.getName())) {
                response.setContentLength(Long.parseLong(header.getValue()));
            }
            response.addHeader(header.getName(), header.getValue());
        }
        HttpUtil.convertHeaderCharsetFromIso88591(response.getHeaders());
        return response;
    }

    private static void readAndSetErrorResponse(InputStream originalContent, ResponseMessage response) throws IOException {
        byte[] contentBytes = IOUtils.readStreamAsByteArray(originalContent);
        response.setErrorResponseAsString(new String(contentBytes));
        response.setContent(new ByteArrayInputStream(contentBytes));
    }

    @Override
    protected RetryStrategy getDefaultRetryStrategy() {
        return new DefaultRetryStrategy();
    }

    protected HttpClient createHttpClient(ClientConnectionManager connectionManager) {
        BasicHttpParams httpParams = new BasicHttpParams();
        httpParams.setIntParameter("http.connection.timeout", this.config.getConnectionTimeout());
        httpParams.setIntParameter("http.socket.timeout", this.config.getSocketTimeout());
        httpParams.setBooleanParameter("http.tcp.nodelay", true);
        httpParams.setBooleanParameter("http.socket.keepalive", true);
        httpParams.setParameter("http.useragent", (Object)this.config.getUserAgent());
        DefaultHttpClient httpClient = new DefaultHttpClient(connectionManager, (HttpParams)httpParams);
        return httpClient;
    }

    protected ClientConnectionManager createHttpClientConnectionManager() {
        PoolingClientConnectionManager connectionManager = new PoolingClientConnectionManager();
        connectionManager.setDefaultMaxPerRoute(this.config.getMaxConnections());
        connectionManager.setMaxTotal(this.config.getMaxConnections());
        if (this.config.isUseReaper()) {
            IdleConnectionReaper.setIdleConnectionTime(this.config.getIdleConnectionTime());
            IdleConnectionReaper.registerConnectionManager((ClientConnectionManager)connectionManager);
        }
        return connectionManager;
    }

    protected HttpContext createHttpContext() {
        BasicHttpContext httpContext = new BasicHttpContext();
        if (this.credentialsProvider != null) {
            httpContext.setAttribute("http.auth.credentials-provider", (Object)this.credentialsProvider);
            httpContext.setAttribute("http.auth.auth-cache", (Object)this.authCache);
        }
        return httpContext;
    }

    private void setProxyAuthorizationIfNeed(HttpRequestBase httpRequest) {
        if (this.credentialsProvider != null) {
            String auth = this.config.getProxyUsername() + ":" + this.config.getProxyPassword();
            byte[] encodedAuth = Base64.encodeBase64((byte[])auth.getBytes());
            String authHeader = "Basic " + new String(encodedAuth);
            httpRequest.addHeader("Proxy-Authorization", authHeader);
        }
    }

    @Override
    public void shutdown() {
        IdleConnectionReaper.removeConnectionManager(this.connectionManager);
        this.connectionManager.shutdown();
    }

    private static class DefaultRetryStrategy
    extends RetryStrategy {
        private DefaultRetryStrategy() {
        }

        @Override
        public boolean shouldRetry(Exception ex, RequestMessage request, ResponseMessage response, int retries) {
            int statusCode;
            String errorCode;
            if (ex instanceof ClientException) {
                errorCode = ((ClientException)ex).getErrorCode();
                if (errorCode.equals("ConnectionTimeout") || errorCode.equals("SocketTimeout") || errorCode.equals("ConnectionRefused") || errorCode.equals("UnknownHost") || errorCode.equals("SocketException")) {
                    return true;
                }
                if (errorCode.equals("NonRepeatableRequest")) {
                    return false;
                }
            }
            if (ex instanceof OSSException && (errorCode = ((OSSException)ex).getErrorCode()).equals("InvalidResponse")) {
                return false;
            }
            return response != null && ((statusCode = response.getStatusCode()) == 500 || statusCode == 503);
        }
    }
}

