/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.oss.internal;

import com.aliyun.oss.ClientException;
import com.aliyun.oss.HttpMethod;
import com.aliyun.oss.OSSException;
import com.aliyun.oss.common.auth.ServiceCredentials;
import com.aliyun.oss.common.comm.ExecutionContext;
import com.aliyun.oss.common.comm.RequestMessage;
import com.aliyun.oss.common.comm.ResponseMessage;
import com.aliyun.oss.common.comm.ServiceClient;
import com.aliyun.oss.common.utils.CodingUtils;
import com.aliyun.oss.common.utils.DateUtil;
import com.aliyun.oss.internal.OSSOperation;
import com.aliyun.oss.internal.OSSRequestMessageBuilder;
import com.aliyun.oss.internal.OSSUtils;
import com.aliyun.oss.internal.ResponseParser;
import com.aliyun.oss.model.AccessControlList;
import com.aliyun.oss.model.Bucket;
import com.aliyun.oss.model.BucketList;
import com.aliyun.oss.model.BucketLoggingResult;
import com.aliyun.oss.model.BucketReferer;
import com.aliyun.oss.model.BucketWebsiteResult;
import com.aliyun.oss.model.CannedAccessControlList;
import com.aliyun.oss.model.CreateBucketRequest;
import com.aliyun.oss.model.LifecycleRule;
import com.aliyun.oss.model.ListBucketsRequest;
import com.aliyun.oss.model.ListObjectsRequest;
import com.aliyun.oss.model.ObjectListing;
import com.aliyun.oss.model.SetBucketLifecycleRequest;
import com.aliyun.oss.model.SetBucketLoggingRequest;
import com.aliyun.oss.model.SetBucketWebsiteRequest;
import java.io.ByteArrayInputStream;
import java.net.URI;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;

public class OSSBucketOperation
extends OSSOperation {
    private static final String SUBRESOURCE_ACL = "acl";
    private static final String SUBRESOURCE_REFERER = "referer";
    private static final String SUBRESOURCE_LOCATION = "location";
    private static final String SUBRESOURCE_LOGGING = "logging";
    private static final String SUBRESOURCE_WEBSITE = "website";
    private static final String SUBRESOURCE_LIFECYCLE = "lifecycle";

    public OSSBucketOperation(URI endpoint, ServiceClient client, ServiceCredentials cred) {
        super(endpoint, client, cred);
    }

    public Bucket createBucket(CreateBucketRequest createBucketRequest) throws OSSException, ClientException {
        String bucketName = createBucketRequest.getBucketName();
        String locationConstraint = createBucketRequest.getLocationConstraint();
        CodingUtils.assertParameterNotNull(bucketName, "bucketName");
        OSSUtils.ensureBucketNameValid(bucketName);
        String xmlBody = "";
        if (locationConstraint != null) {
            xmlBody = OSSBucketOperation.buildCreateBucketXml(locationConstraint);
        }
        byte[] inputBytes = xmlBody.getBytes();
        RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint()).setMethod(HttpMethod.PUT).setBucket(bucketName).setInputStream(new ByteArrayInputStream(inputBytes)).setInputSize(inputBytes.length).build();
        ExecutionContext context = this.createDefaultContext(request.getMethod(), bucketName);
        this.send(request, context);
        return new Bucket(bucketName);
    }

    public void deleteBucket(String bucketName) throws OSSException, ClientException {
        CodingUtils.assertParameterNotNull(bucketName, "bucketName");
        OSSUtils.ensureBucketNameValid(bucketName);
        RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint()).setMethod(HttpMethod.DELETE).setBucket(bucketName).build();
        ExecutionContext context = this.createDefaultContext(request.getMethod(), bucketName);
        this.send(request, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BucketList listBuckets(ListBucketsRequest listBucketRequest) throws OSSException, ClientException {
        BucketList bucketList;
        block6: {
            CodingUtils.assertParameterNotNull(listBucketRequest, "request");
            LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
            if (listBucketRequest.getPrefix() != null) {
                params.put("prefix", listBucketRequest.getPrefix());
            }
            if (listBucketRequest.getMarker() != null) {
                params.put("marker", listBucketRequest.getMarker());
            }
            if (listBucketRequest.getMaxKeys() != null) {
                params.put("max-keys", Integer.toString(listBucketRequest.getMaxKeys()));
            }
            ResponseMessage response = null;
            try {
                RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint()).setMethod(HttpMethod.GET).setParameters(params).build();
                ExecutionContext context = this.createDefaultContext(request.getMethod());
                response = this.send(request, context, true);
                bucketList = ResponseParser.parseListBucket(response.getRequestId(), response.getContent());
                if (response == null) break block6;
            }
            catch (Throwable throwable) {
                if (response != null) {
                    OSSUtils.safeCloseResponse(response);
                }
                throw throwable;
            }
            OSSUtils.safeCloseResponse(response);
        }
        return bucketList;
    }

    public void setBucketAcl(String bucketName, CannedAccessControlList acl) throws OSSException, ClientException {
        CodingUtils.assertParameterNotNull(bucketName, "bucketName");
        OSSUtils.ensureBucketNameValid(bucketName);
        if (acl == null) {
            acl = CannedAccessControlList.Private;
        }
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("x-oss-acl", acl.toString());
        HashMap<String, String> params = new HashMap<String, String>();
        params.put(SUBRESOURCE_ACL, null);
        RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint()).setMethod(HttpMethod.PUT).setBucket(bucketName).setHeaders(headers).setParameters(params).build();
        ExecutionContext context = this.createDefaultContext(request.getMethod(), bucketName);
        this.send(request, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AccessControlList getBucketAcl(String bucketName) throws OSSException, ClientException {
        AccessControlList accessControlList;
        block3: {
            CodingUtils.assertParameterNotNull(bucketName, "bucketName");
            OSSUtils.ensureBucketNameValid(bucketName);
            HashMap<String, String> params = new HashMap<String, String>();
            params.put(SUBRESOURCE_ACL, null);
            ResponseMessage response = null;
            try {
                RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint()).setMethod(HttpMethod.GET).setBucket(bucketName).setParameters(params).build();
                ExecutionContext context = this.createDefaultContext(request.getMethod(), bucketName);
                response = this.send(request, context, true);
                accessControlList = ResponseParser.parseGetBucketAcl(response.getRequestId(), response.getContent());
                if (response == null) break block3;
            }
            catch (Throwable throwable) {
                if (response != null) {
                    OSSUtils.safeCloseResponse(response);
                }
                throw throwable;
            }
            OSSUtils.safeCloseResponse(response);
        }
        return accessControlList;
    }

    public void setBucketReferer(String bucketName, BucketReferer referer) throws OSSException, ClientException {
        CodingUtils.assertParameterNotNull(bucketName, "bucketName");
        OSSUtils.ensureBucketNameValid(bucketName);
        if (referer == null) {
            referer = new BucketReferer();
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put(SUBRESOURCE_REFERER, null);
        byte[] inputBytes = referer.toXmlString().getBytes();
        RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint()).setMethod(HttpMethod.PUT).setBucket(bucketName).setParameters(params).setInputStream(new ByteArrayInputStream(inputBytes)).setInputSize(inputBytes.length).build();
        ExecutionContext context = this.createDefaultContext(request.getMethod(), bucketName);
        this.send(request, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BucketReferer getBucketReferer(String bucketName) throws OSSException, ClientException {
        BucketReferer bucketReferer;
        block3: {
            CodingUtils.assertParameterNotNull(bucketName, "bucketName");
            OSSUtils.ensureBucketNameValid(bucketName);
            HashMap<String, String> params = new HashMap<String, String>();
            params.put(SUBRESOURCE_REFERER, null);
            ResponseMessage response = null;
            try {
                RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint()).setMethod(HttpMethod.GET).setBucket(bucketName).setParameters(params).build();
                ExecutionContext context = this.createDefaultContext(request.getMethod(), bucketName);
                response = this.send(request, context, true);
                bucketReferer = ResponseParser.parseGetBucketReferer(response.getRequestId(), response.getContent());
                if (response == null) break block3;
            }
            catch (Throwable throwable) {
                if (response != null) {
                    OSSUtils.safeCloseResponse(response);
                }
                throw throwable;
            }
            OSSUtils.safeCloseResponse(response);
        }
        return bucketReferer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getBucketLocation(String bucketName) {
        String string;
        block3: {
            CodingUtils.assertParameterNotNull(bucketName, "bucketName");
            OSSUtils.ensureBucketNameValid(bucketName);
            HashMap<String, String> params = new HashMap<String, String>();
            params.put(SUBRESOURCE_LOCATION, null);
            ResponseMessage response = null;
            try {
                RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint()).setMethod(HttpMethod.GET).setBucket(bucketName).setParameters(params).build();
                ExecutionContext context = this.createDefaultContext(request.getMethod(), bucketName);
                response = this.send(request, context, true);
                string = ResponseParser.parseGetBucketLocation(response.getRequestId(), response.getContent());
                if (response == null) break block3;
            }
            catch (Throwable throwable) {
                if (response != null) {
                    OSSUtils.safeCloseResponse(response);
                }
                throw throwable;
            }
            OSSUtils.safeCloseResponse(response);
        }
        return string;
    }

    public boolean bucketExists(String bucketName) throws OSSException, ClientException {
        block2: {
            CodingUtils.assertParameterNotNull(bucketName, "bucketName");
            OSSUtils.ensureBucketNameValid(bucketName);
            try {
                this.getBucketAcl(bucketName);
            }
            catch (OSSException e) {
                if (!e.getErrorCode().equals("NoSuchBucket")) break block2;
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectListing listObjects(ListObjectsRequest listObjectRequest) throws OSSException, ClientException {
        ObjectListing objectListing;
        block8: {
            CodingUtils.assertParameterNotNull(listObjectRequest, "request");
            if (listObjectRequest.getBucketName() == null) {
                throw new IllegalArgumentException(OSSUtils.OSS_RESOURCE_MANAGER.getString("MustSetBucketName"));
            }
            OSSUtils.ensureBucketNameValid(listObjectRequest.getBucketName());
            LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
            if (listObjectRequest.getPrefix() != null) {
                params.put("prefix", listObjectRequest.getPrefix());
            }
            if (listObjectRequest.getMarker() != null) {
                params.put("marker", listObjectRequest.getMarker());
            }
            if (listObjectRequest.getDelimiter() != null) {
                params.put("delimiter", listObjectRequest.getDelimiter());
            }
            if (listObjectRequest.getMaxKeys() != null) {
                params.put("max-keys", Integer.toString(listObjectRequest.getMaxKeys()));
            }
            ResponseMessage response = null;
            try {
                RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint()).setMethod(HttpMethod.GET).setBucket(listObjectRequest.getBucketName()).setParameters(params).build();
                ExecutionContext context = this.createDefaultContext(request.getMethod(), listObjectRequest.getBucketName());
                response = this.send(request, context, true);
                objectListing = ResponseParser.parseListObjects(response.getRequestId(), response.getContent());
                if (response == null) break block8;
            }
            catch (Throwable throwable) {
                if (response != null) {
                    OSSUtils.safeCloseResponse(response);
                }
                throw throwable;
            }
            OSSUtils.safeCloseResponse(response);
        }
        return objectListing;
    }

    public void setBucketLogging(SetBucketLoggingRequest setBucketLoggingRequest) throws OSSException, ClientException {
        String bucketName = setBucketLoggingRequest.getBucketName();
        String targetBucket = setBucketLoggingRequest.getTargetBucket();
        String targetPrefix = setBucketLoggingRequest.getTargetPrefix();
        CodingUtils.assertParameterNotNull(bucketName, "bucketName");
        OSSUtils.ensureBucketNameValid(bucketName);
        CodingUtils.assertParameterNotNull(targetBucket, "targetBucket");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put(SUBRESOURCE_LOGGING, null);
        String xmlBody = "";
        xmlBody = OSSBucketOperation.buildPutBucketLoggingXml(targetBucket, targetPrefix);
        byte[] inputBytes = xmlBody.getBytes();
        RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint()).setMethod(HttpMethod.PUT).setBucket(bucketName).setParameters(params).setInputStream(new ByteArrayInputStream(inputBytes)).setInputSize(inputBytes.length).build();
        ExecutionContext context = this.createDefaultContext(request.getMethod(), bucketName);
        this.send(request, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BucketLoggingResult getBucketLogging(String bucketName) throws OSSException, ClientException {
        BucketLoggingResult bucketLoggingResult;
        block3: {
            CodingUtils.assertParameterNotNull(bucketName, "bucketName");
            OSSUtils.ensureBucketNameValid(bucketName);
            HashMap<String, String> params = new HashMap<String, String>();
            params.put(SUBRESOURCE_LOGGING, null);
            ResponseMessage response = null;
            try {
                RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint()).setMethod(HttpMethod.GET).setBucket(bucketName).setParameters(params).build();
                ExecutionContext context = this.createDefaultContext(request.getMethod(), bucketName);
                response = this.send(request, context, true);
                bucketLoggingResult = ResponseParser.parseBucketLogging(response.getRequestId(), response.getContent());
                if (response == null) break block3;
            }
            catch (Throwable throwable) {
                if (response != null) {
                    OSSUtils.safeCloseResponse(response);
                }
                throw throwable;
            }
            OSSUtils.safeCloseResponse(response);
        }
        return bucketLoggingResult;
    }

    public void deleteBucketLogging(String bucketName) throws OSSException, ClientException {
        CodingUtils.assertParameterNotNull(bucketName, "bucketName");
        OSSUtils.ensureBucketNameValid(bucketName);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put(SUBRESOURCE_LOGGING, null);
        RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint()).setMethod(HttpMethod.DELETE).setBucket(bucketName).setParameters(params).build();
        ExecutionContext context = this.createDefaultContext(request.getMethod(), bucketName);
        this.send(request, context);
    }

    public void setBucketWebsite(SetBucketWebsiteRequest setBucketWebSiteRequest) throws OSSException, ClientException {
        String bucketName = setBucketWebSiteRequest.getBucketName();
        String indexDocument = setBucketWebSiteRequest.getIndexDocument();
        String errorDocument = setBucketWebSiteRequest.getErrorDocument();
        CodingUtils.assertParameterNotNull(bucketName, "bucketName");
        OSSUtils.ensureBucketNameValid(bucketName);
        CodingUtils.assertParameterNotNull(indexDocument, "indexDocument");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put(SUBRESOURCE_WEBSITE, null);
        String xmlBody = "";
        xmlBody = OSSBucketOperation.buildPutBucketWebSiteXml(indexDocument, errorDocument);
        byte[] inputBytes = xmlBody.getBytes();
        RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint()).setMethod(HttpMethod.PUT).setBucket(bucketName).setParameters(params).setInputStream(new ByteArrayInputStream(inputBytes)).setInputSize(inputBytes.length).build();
        ExecutionContext context = this.createDefaultContext(request.getMethod(), bucketName);
        this.send(request, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BucketWebsiteResult getBucketWebsite(String bucketName) throws OSSException, ClientException {
        BucketWebsiteResult bucketWebsiteResult;
        block3: {
            CodingUtils.assertParameterNotNull(bucketName, "bucketName");
            OSSUtils.ensureBucketNameValid(bucketName);
            HashMap<String, String> params = new HashMap<String, String>();
            params.put(SUBRESOURCE_WEBSITE, null);
            ResponseMessage response = null;
            try {
                RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint()).setMethod(HttpMethod.GET).setBucket(bucketName).setParameters(params).build();
                ExecutionContext context = this.createDefaultContext(request.getMethod(), bucketName);
                response = this.send(request, context, true);
                bucketWebsiteResult = ResponseParser.parseBucketWebsite(response.getRequestId(), response.getContent());
                if (response == null) break block3;
            }
            catch (Throwable throwable) {
                if (response != null) {
                    OSSUtils.safeCloseResponse(response);
                }
                throw throwable;
            }
            OSSUtils.safeCloseResponse(response);
        }
        return bucketWebsiteResult;
    }

    public void deleteBucketWebsite(String bucketName) throws OSSException, ClientException {
        CodingUtils.assertParameterNotNull(bucketName, "bucketName");
        OSSUtils.ensureBucketNameValid(bucketName);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put(SUBRESOURCE_WEBSITE, null);
        RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint()).setMethod(HttpMethod.DELETE).setBucket(bucketName).setParameters(params).build();
        ExecutionContext context = this.createDefaultContext(request.getMethod(), bucketName);
        this.send(request, context);
    }

    public void setBucketLifecycle(SetBucketLifecycleRequest setBucketLifecycleRequest) throws OSSException, ClientException {
        String bucketName = setBucketLifecycleRequest.getBucketName();
        List<LifecycleRule> lifecycleRules = setBucketLifecycleRequest.getLifecycleRules();
        CodingUtils.assertParameterNotNull(bucketName, "bucketName");
        OSSUtils.ensureBucketNameValid(bucketName);
        CodingUtils.assertParameterNotNull(lifecycleRules, "lifecycleRules");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put(SUBRESOURCE_LIFECYCLE, null);
        String xmlBody = "";
        xmlBody = OSSBucketOperation.buildSetBucketLifecycleXml(lifecycleRules);
        byte[] inputBytes = xmlBody.getBytes();
        RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint()).setMethod(HttpMethod.PUT).setBucket(bucketName).setParameters(params).setInputStream(new ByteArrayInputStream(inputBytes)).setInputSize(inputBytes.length).build();
        ExecutionContext context = this.createDefaultContext(request.getMethod(), bucketName);
        this.send(request, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<LifecycleRule> getBucketLifecycle(String bucketName) throws OSSException, ClientException {
        List<LifecycleRule> list;
        block3: {
            CodingUtils.assertParameterNotNull(bucketName, "bucketName");
            OSSUtils.ensureBucketNameValid(bucketName);
            HashMap<String, String> params = new HashMap<String, String>();
            params.put(SUBRESOURCE_LIFECYCLE, null);
            ResponseMessage response = null;
            try {
                RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint()).setMethod(HttpMethod.GET).setBucket(bucketName).setParameters(params).build();
                ExecutionContext context = this.createDefaultContext(request.getMethod(), bucketName);
                response = this.send(request, context, true);
                list = ResponseParser.parseGetBucketLifecycle(response.getRequestId(), response.getContent());
                if (response == null) break block3;
            }
            catch (Throwable throwable) {
                if (response != null) {
                    OSSUtils.safeCloseResponse(response);
                }
                throw throwable;
            }
            OSSUtils.safeCloseResponse(response);
        }
        return list;
    }

    public void deleteBucketLifecycle(String bucketName) throws OSSException, ClientException {
        CodingUtils.assertParameterNotNull(bucketName, "bucketName");
        OSSUtils.ensureBucketNameValid(bucketName);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put(SUBRESOURCE_LIFECYCLE, null);
        RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint()).setMethod(HttpMethod.DELETE).setBucket(bucketName).setParameters(params).build();
        ExecutionContext context = this.createDefaultContext(request.getMethod(), bucketName);
        this.send(request, context);
    }

    private static String buildPutBucketWebSiteXml(String indexDocument, String errorDocument) {
        StringBuffer xml = new StringBuffer();
        xml.append("<WebsiteConfiguration>");
        xml.append("<IndexDocument>");
        xml.append("<Suffix>" + indexDocument + "</Suffix>");
        xml.append("</IndexDocument>");
        if (errorDocument != null) {
            xml.append("<ErrorDocument>");
            xml.append("<Key>" + errorDocument + "</Key>");
            xml.append("</ErrorDocument>");
        }
        xml.append("</WebsiteConfiguration>");
        return xml.toString();
    }

    private static String buildPutBucketLoggingXml(String targetBucket, String targetPrefix) {
        StringBuffer xml = new StringBuffer();
        xml.append("<BucketLoggingStatus>");
        xml.append("<LoggingEnabled>");
        xml.append("<TargetBucket>" + targetBucket + "</TargetBucket>");
        if (targetPrefix != null) {
            xml.append("<TargetPrefix>" + targetPrefix + "</TargetPrefix>");
        }
        xml.append("</LoggingEnabled>");
        xml.append("</BucketLoggingStatus>");
        return xml.toString();
    }

    private static String buildCreateBucketXml(String locationConstraint) {
        StringBuffer xml = new StringBuffer();
        xml.append("<CreateBucketConfiguration>");
        xml.append("<LocationConstraint>" + locationConstraint + "</LocationConstraint>");
        xml.append("</CreateBucketConfiguration>");
        return xml.toString();
    }

    private static String buildSetBucketLifecycleXml(List<LifecycleRule> lifecycleRules) {
        StringBuffer xml = new StringBuffer();
        xml.append("<LifecycleConfiguration>");
        for (LifecycleRule rule : lifecycleRules) {
            xml.append("<Rule>");
            xml.append("<ID>" + rule.getId() + "</ID>");
            xml.append("<Prefix>" + rule.getPrefix() + "</Prefix>");
            if (rule.getStatus() == LifecycleRule.RuleStatus.Enabled) {
                xml.append("<Status>Enabled</Status>");
            } else {
                xml.append("<Status>Disabled</Status>");
            }
            if (rule.getExpirationTime() != null) {
                String formatDate = DateUtil.formatIso8601Date(rule.getExpirationTime());
                xml.append("<Expiration><Date>" + formatDate + "</Date></Expiration>");
            } else {
                xml.append("<Expiration><Days>" + rule.getExpriationDays() + "</Days></Expiration>");
            }
            xml.append("</Rule>");
        }
        xml.append("</LifecycleConfiguration>");
        return xml.toString();
    }
}

