/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore.model;

import com.alicloud.openservices.tablestore.core.utils.OptionalValue;
import com.alicloud.openservices.tablestore.core.utils.Preconditions;
import com.alicloud.openservices.tablestore.model.CapacityUnit;
import com.alicloud.openservices.tablestore.model.Request;
import com.alicloud.openservices.tablestore.model.ReservedThroughput;
import com.alicloud.openservices.tablestore.model.StreamSpecification;
import com.alicloud.openservices.tablestore.model.TableMeta;
import com.alicloud.openservices.tablestore.model.TableOptions;

public class CreateTableRequest
implements Request {
    private TableMeta tableMeta;
    private ReservedThroughput reservedThroughput;
    private TableOptions tableOptions;
    private OptionalValue<StreamSpecification> streamSpecification = new OptionalValue("StreamSpecification");

    public CreateTableRequest(TableMeta tableMeta, TableOptions tableOptions) {
        this(tableMeta, tableOptions, new ReservedThroughput());
    }

    public CreateTableRequest(TableMeta tableMeta, TableOptions tableOptions, ReservedThroughput reservedThroughput) {
        this.setTableOptions(tableOptions);
        this.setReservedThroughput(reservedThroughput);
        this.setTableMeta(tableMeta);
    }

    @Override
    public String getOperationName() {
        return "CreateTable";
    }

    public TableMeta getTableMeta() {
        return this.tableMeta;
    }

    public void setTableMeta(TableMeta tableMeta) {
        Preconditions.checkNotNull(tableMeta, "TableMeta should not be null.");
        this.tableMeta = tableMeta;
    }

    public ReservedThroughput getReservedThroughput() {
        return this.reservedThroughput;
    }

    public void setReservedThroughput(ReservedThroughput reservedThroughput) {
        Preconditions.checkNotNull(reservedThroughput, "ReservedThroughput should not be null.");
        CapacityUnit cu = reservedThroughput.getCapacityUnit();
        Preconditions.checkArgument(cu.hasSetReadCapacityUnit() && cu.hasSetWriteCapacityUnit(), "You must set both read and write capacity unit.");
        Preconditions.checkArgument(cu.getReadCapacityUnit() >= 0, "The value of read capacity unit must be greater than 0.");
        Preconditions.checkArgument(cu.getWriteCapacityUnit() >= 0, "The value of write capacity unit must be greater than 0.");
        this.reservedThroughput = reservedThroughput;
    }

    public TableOptions getTableOptions() {
        return this.tableOptions;
    }

    public void setTableOptions(TableOptions tableOptions) {
        Preconditions.checkNotNull(tableOptions, "TableOptionsEx should not be null.");
        this.tableOptions = tableOptions;
    }

    public StreamSpecification getStreamSpecification() {
        return this.streamSpecification.getValue();
    }

    public void setStreamSpecification(StreamSpecification streamSpecification) {
        Preconditions.checkArgument(streamSpecification != null, "The stream specification should not be null");
        this.streamSpecification.setValue(streamSpecification);
    }
}

