/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.ots.internal.streamclient.lease;

import com.aliyun.openservices.ots.internal.streamclient.DependencyException;
import com.aliyun.openservices.ots.internal.streamclient.StreamClientException;
import com.aliyun.openservices.ots.internal.streamclient.lease.Lease;
import com.aliyun.openservices.ots.internal.streamclient.lease.interfaces.ILeaseManager;
import com.aliyun.openservices.ots.internal.streamclient.lease.interfaces.ILeaseTaker;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LeaseTaker<T extends Lease>
implements ILeaseTaker<T> {
    private static final Logger LOG = LoggerFactory.getLogger(LeaseTaker.class);
    private final ILeaseManager<T> leaseManager;
    private final String workerIdentifier;
    private final long leaseDurationMillis;
    private boolean autoSteal;
    private long lastUpdateLeasesMillis = 0L;
    private final Map<String, T> allLeases = new HashMap<String, T>();

    public LeaseTaker(ILeaseManager<T> leaseManager, String workerIdentifier, long leaseDurationMillis, boolean autoSteal) {
        this.leaseManager = leaseManager;
        this.workerIdentifier = workerIdentifier;
        this.leaseDurationMillis = leaseDurationMillis;
        this.autoSteal = autoSteal;
    }

    @Override
    public synchronized Map<String, T> takeLeases() throws StreamClientException, DependencyException {
        T lease;
        LOG.debug("Start take leases.");
        HashMap<String, Lease> takenLeases = new HashMap<String, Lease>();
        ArrayList leasesStealComplete = new ArrayList();
        this.updateAllLeases(leasesStealComplete);
        List<T> expiredLeases = this.getExpiredLeases();
        Map<String, Integer> leaseCounts = this.computeLeaseCounts(expiredLeases);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Lease after updated.");
            for (Lease lease2 : this.allLeases.values()) {
                LOG.debug("Lease: {}", (Object)lease2);
            }
            for (Lease lease3 : leasesStealComplete) {
                LOG.debug("Steal lease has been transferred to this worker. Lease: {}.", (Object)lease3.getLeaseKey());
            }
            for (Lease lease4 : expiredLeases) {
                LOG.debug("LeaseExpired, LeaseKey: {}.", (Object)lease4.getLeaseKey());
            }
            for (Map.Entry entry : leaseCounts.entrySet()) {
                LOG.debug("Owner: {}, Count: {}", entry.getKey(), entry.getValue());
            }
        }
        int numLeases = this.allLeases.size();
        int n = leaseCounts.size();
        int target = numLeases / n + (numLeases % n == 0 ? 0 : 1);
        int need = target - leaseCounts.get(this.workerIdentifier);
        LOG.debug("Try to take lease. NumLeases: {}, NumWorkers: {}, Target: {}, Need: {}.", new Object[]{numLeases, n, target, need});
        Map leasesToTake = this.computeLeasesToTake(leasesStealComplete, expiredLeases, need);
        for (Lease lease3 : leasesToTake.values()) {
            if (this.leaseManager.takeLease(lease3, this.workerIdentifier)) {
                lease3.setLastCounterIncrementMillis(System.currentTimeMillis());
                LOG.info("Successfully take lease. Lease: {}.", (Object)lease3);
                takenLeases.put(lease3.getLeaseKey(), lease3);
                continue;
            }
            LOG.info("Failed to take lease. Lease: {}.", (Object)lease3);
        }
        LOG.debug("Worker: {}, AutoSteal: {}, TakenLeases: {}, Need: {}", new Object[]{this.workerIdentifier, this.autoSteal, takenLeases.size(), need});
        if (this.autoSteal && need > takenLeases.size() && (lease = this.chooseLeaseToSteal(leaseCounts, need, target)) != null) {
            LOG.info("Steal lease, Lease: {}.", lease);
            this.leaseManager.stealLease(lease, this.workerIdentifier);
        }
        return takenLeases;
    }

    void updateAllLeases(List<T> leasesStealComplete) throws StreamClientException, DependencyException {
        List<T> newList = this.leaseManager.listLeases();
        this.lastUpdateLeasesMillis = System.currentTimeMillis();
        LOG.debug("Update all leases: {}.", (Object)this.lastUpdateLeasesMillis);
        HashSet<String> notUpdated = new HashSet<String>(this.allLeases.keySet());
        for (Lease lease : newList) {
            String leaseKey = lease.getLeaseKey();
            Lease oldLease = (Lease)this.allLeases.get(leaseKey);
            notUpdated.remove(leaseKey);
            if (oldLease != null) {
                if (oldLease.getLeaseCounter() == lease.getLeaseCounter()) {
                    lease.setLastCounterIncrementMillis(oldLease.getLastCounterIncrementMillis());
                } else {
                    lease.setLastCounterIncrementMillis(this.lastUpdateLeasesMillis);
                }
            } else if (lease.getLeaseOwner().isEmpty()) {
                lease.setLastCounterIncrementMillis(0L);
            } else {
                lease.setLastCounterIncrementMillis(this.lastUpdateLeasesMillis);
            }
            if (lease.getLeaseOwner().equals(this.workerIdentifier) && lease.getLeaseStealer().equals(this.workerIdentifier)) {
                leasesStealComplete.add(lease);
            }
            this.allLeases.put(leaseKey, lease);
        }
        for (String key : notUpdated) {
            this.allLeases.remove(key);
        }
    }

    public Map<String, T> getAllLeases() {
        HashMap copy = new HashMap();
        for (Map.Entry<String, T> entry : this.allLeases.entrySet()) {
            copy.put(entry.getKey(), ((Lease)entry.getValue()).copy());
        }
        return copy;
    }

    private List<T> getExpiredLeases() {
        ArrayList<Lease> expiredLeases = new ArrayList<Lease>();
        for (Lease lease : this.allLeases.values()) {
            if (!lease.isExpired(this.leaseDurationMillis, this.lastUpdateLeasesMillis)) continue;
            expiredLeases.add(lease);
        }
        return expiredLeases;
    }

    Map<String, T> computeLeasesToTake(List<T> leasesStealComplete, List<T> expiredLeases, int need) {
        HashMap<String, Lease> leasesToTake = new HashMap<String, Lease>();
        for (Lease lease : leasesStealComplete) {
            leasesToTake.put(lease.getLeaseKey(), lease);
            if (--need > 0) continue;
            return leasesToTake;
        }
        LinkedList<T> leaseToPick = new LinkedList<T>(expiredLeases);
        Collections.shuffle(leaseToPick);
        while (need > 0 && leaseToPick.size() > 0) {
            Lease lease;
            lease = (Lease)leaseToPick.remove(0);
            if (leasesToTake.containsKey(lease.getLeaseKey())) continue;
            leasesToTake.put(lease.getLeaseKey(), lease);
            --need;
        }
        return leasesToTake;
    }

    Map<String, Integer> computeLeaseCounts(List<T> expiredLeases) {
        HashMap<String, Integer> leaseCounts = new HashMap<String, Integer>();
        for (Lease lease : this.allLeases.values()) {
            if (expiredLeases.contains(lease) || !lease.getLeaseStealer().isEmpty()) continue;
            String leaseOwner = lease.getLeaseOwner();
            Integer oldCount = (Integer)leaseCounts.get(leaseOwner);
            if (oldCount == null) {
                leaseCounts.put(leaseOwner, 1);
                continue;
            }
            leaseCounts.put(leaseOwner, oldCount + 1);
        }
        if (leaseCounts.get(this.workerIdentifier) == null) {
            leaseCounts.put(this.workerIdentifier, 0);
        }
        return leaseCounts;
    }

    T chooseLeaseToSteal(Map<String, Integer> leaseCounts, int need, int target) {
        if (leaseCounts.isEmpty()) {
            return null;
        }
        Map.Entry<String, Integer> mostLoadedWorker = null;
        for (Map.Entry<String, Integer> worker : leaseCounts.entrySet()) {
            if (mostLoadedWorker != null && (Integer)mostLoadedWorker.getValue() >= worker.getValue()) continue;
            mostLoadedWorker = worker;
        }
        if ((Integer)mostLoadedWorker.getValue() <= target - 1 || need <= 1 && mostLoadedWorker.getValue() == target) {
            return null;
        }
        String mostLoadedWorkerIdentifier = mostLoadedWorker.getKey();
        ArrayList<Lease> candidates = new ArrayList<Lease>();
        for (Lease lease : this.allLeases.values()) {
            if (!mostLoadedWorkerIdentifier.equals(lease.getLeaseOwner())) continue;
            candidates.add(lease);
        }
        if (candidates.isEmpty()) {
            return null;
        }
        int randomIndex = new Random().nextInt(candidates.size());
        return (T)((Lease)candidates.get(randomIndex));
    }
}

