/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.ots.internal.streamclient.lease;

public class Lease {
    private String leaseKey;
    private String leaseOwner = "";
    private long leaseCounter = 0L;
    private String leaseStealer = "";
    private long lastCounterIncrementMillis = 0L;
    private String leaseIdentifier = "";

    public Lease(String leaseKey) {
        this.leaseKey = leaseKey;
    }

    public Lease(Lease lease) {
        this.leaseKey = lease.getLeaseKey();
        this.leaseOwner = lease.getLeaseOwner();
        this.leaseCounter = lease.getLeaseCounter();
        this.lastCounterIncrementMillis = lease.getLastCounterIncrementMillis();
        this.leaseIdentifier = lease.getLeaseIdentifier();
        this.leaseStealer = lease.getLeaseStealer();
    }

    public <T extends Lease> void update(T other) {
    }

    public String getLeaseKey() {
        return this.leaseKey;
    }

    public void setLeaseKey(String leaseKey) {
        this.leaseKey = leaseKey;
    }

    public String getLeaseOwner() {
        return this.leaseOwner;
    }

    public void setLeaseOwner(String leaseOwner) {
        this.leaseOwner = leaseOwner;
    }

    public long getLeaseCounter() {
        return this.leaseCounter;
    }

    public void setLeaseCounter(long leaseCounter) {
        this.leaseCounter = leaseCounter;
    }

    public long getLastCounterIncrementMillis() {
        return this.lastCounterIncrementMillis;
    }

    public void setLastCounterIncrementMillis(long lastCounterIncrementMillis) {
        this.lastCounterIncrementMillis = lastCounterIncrementMillis;
    }

    public String getLeaseIdentifier() {
        return this.leaseIdentifier;
    }

    public void setLeaseIdentifier(String leaseIdentifier) {
        this.leaseIdentifier = leaseIdentifier;
    }

    public boolean isExpired(long leaseDurationMillis, long now) {
        return now - this.lastCounterIncrementMillis > leaseDurationMillis;
    }

    public String getLeaseStealer() {
        return this.leaseStealer;
    }

    public void setLeaseStealer(String leaseStealer) {
        this.leaseStealer = leaseStealer;
    }

    public <T extends Lease> T copy() {
        return (T)new Lease(this);
    }

    public int hashCode() {
        int result = this.leaseKey != null ? this.leaseKey.hashCode() : 0;
        result = 31 * result + (this.leaseOwner != null ? this.leaseOwner.hashCode() : 0);
        result = 31 * result + (int)(this.leaseCounter ^ this.leaseCounter >>> 32);
        result = 31 * result + (this.leaseIdentifier != null ? this.leaseIdentifier.hashCode() : 0);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Lease)) {
            return false;
        }
        if (!this.getLeaseKey().equals(((Lease)obj).getLeaseKey())) {
            return false;
        }
        if (!this.getLeaseOwner().equals(((Lease)obj).getLeaseOwner())) {
            return false;
        }
        if (this.getLeaseCounter() != ((Lease)obj).getLeaseCounter()) {
            return false;
        }
        return this.getLeaseIdentifier().equals(((Lease)obj).getLeaseIdentifier());
    }
}

