/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.ots.utils;

import com.aliyun.openservices.ots.model.ColumnValue;
import com.aliyun.openservices.ots.model.PrimaryKeyValue;
import com.aliyun.openservices.ots.model.RowDeleteChange;
import com.aliyun.openservices.ots.model.RowPrimaryKey;
import com.aliyun.openservices.ots.model.RowPutChange;
import com.aliyun.openservices.ots.model.RowUpdateChange;
import java.io.UnsupportedEncodingException;
import java.util.Map;

public class CalculateHelper {
    public static int getStringDataSize(String str) throws IllegalStateException {
        try {
            return str.getBytes("UTF-8").length;
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e.getMessage(), e.getCause());
        }
    }

    public static int getPrimaryKeyDataSize(String name, PrimaryKeyValue value) throws IllegalStateException {
        int primaryKeyTotalSize = CalculateHelper.getStringDataSize(name);
        switch (value.getType()) {
            case INTEGER: {
                primaryKeyTotalSize += 8;
                break;
            }
            case STRING: {
                primaryKeyTotalSize += CalculateHelper.getStringDataSize(value.asString());
                break;
            }
            default: {
                throw new IllegalStateException("Bug: not support the type : " + (Object)((Object)value.getType()));
            }
        }
        return primaryKeyTotalSize;
    }

    public static int getPrimaryKeyDataSize(RowPrimaryKey primaryKey) throws IllegalStateException {
        int primaryKeyTotalSize = 0;
        for (Map.Entry<String, PrimaryKeyValue> pk : primaryKey.getPrimaryKey().entrySet()) {
            primaryKeyTotalSize += CalculateHelper.getPrimaryKeyDataSize(pk.getKey(), pk.getValue());
        }
        return primaryKeyTotalSize;
    }

    public static int getAttributeColumnDataSize(String name, ColumnValue value) throws IllegalStateException {
        int columnTotalSize = CalculateHelper.getStringDataSize(name);
        switch (value.getType()) {
            case BINARY: {
                columnTotalSize += value.asBinary().length;
                break;
            }
            case BOOLEAN: {
                ++columnTotalSize;
                break;
            }
            case DOUBLE: {
                columnTotalSize += 8;
                break;
            }
            case INTEGER: {
                columnTotalSize += 8;
                break;
            }
            case STRING: {
                columnTotalSize += CalculateHelper.getStringDataSize(value.asString());
                break;
            }
            default: {
                throw new IllegalStateException("Bug: not support the type : " + (Object)((Object)value.getType()));
            }
        }
        return columnTotalSize;
    }

    public static int getAttributeColumnDataSize(Map<String, ColumnValue> columns) throws IllegalStateException {
        int columnTotalSize = 0;
        for (Map.Entry<String, ColumnValue> column : columns.entrySet()) {
            columnTotalSize += CalculateHelper.getAttributeColumnDataSize(column.getKey(), column.getValue());
        }
        return columnTotalSize;
    }

    public static int getRowChangeDataSize(RowPutChange change) throws IllegalStateException {
        return CalculateHelper.getPrimaryKeyDataSize(change.getRowPrimaryKey()) + CalculateHelper.getAttributeColumnDataSize(change.getAttributeColumns());
    }

    public static int getRowChangeDataSize(RowUpdateChange change) throws IllegalStateException {
        return CalculateHelper.getPrimaryKeyDataSize(change.getRowPrimaryKey()) + CalculateHelper.getAttributeColumnDataSize(change.getAttributeColumns());
    }

    public static int getRowChangeDataSize(RowDeleteChange change) throws IllegalStateException {
        return CalculateHelper.getPrimaryKeyDataSize(change.getRowPrimaryKey());
    }
}

