/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.ots.model;

import com.aliyun.openservices.ots.model.ColumnValue;
import com.aliyun.openservices.ots.model.RowChange;
import com.aliyun.openservices.ots.utils.CalculateHelper;
import com.aliyun.openservices.ots.utils.CodingUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class RowPutChange
extends RowChange {
    private Map<String, ColumnValue> attributeColumns = new HashMap<String, ColumnValue>();
    private int valueTotalSize = -1;

    public RowPutChange(String tableName) {
        super(tableName);
    }

    @Override
    public int getDataSize() {
        if (this.valueTotalSize == -1) {
            this.valueTotalSize = 0;
            for (Map.Entry<String, ColumnValue> entry : this.attributeColumns.entrySet()) {
                this.valueTotalSize += CalculateHelper.getStringDataSize(entry.getKey());
                this.valueTotalSize += entry.getValue().getSize();
            }
        }
        return this.primaryKey.getSize() + this.valueTotalSize;
    }

    public Map<String, ColumnValue> getAttributeColumns() {
        return Collections.unmodifiableMap(this.attributeColumns);
    }

    public RowPutChange addAttributeColumn(String name, ColumnValue value) {
        CodingUtils.assertParameterNotNull(name, "name");
        CodingUtils.assertParameterNotNull(value, "value");
        this.attributeColumns.put(name, value);
        this.valueTotalSize = -1;
        return this;
    }
}

