/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.ots.internal;

import com.aliyun.openservices.ots.internal.OTSCallable;
import com.aliyun.openservices.ots.internal.OTSRetryStrategy;
import com.aliyun.openservices.ots.internal.OTSTraceLogger;
import com.aliyun.openservices.ots.model.OTSBasicFuture;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.http.concurrent.FutureCallback;

public class OTSExecutionContext<Req, Res> {
    private Req request;
    private OTSBasicFuture<Res> future;
    private OTSTraceLogger traceLogger;
    private FutureCallback<Res> asyncClientCallback;
    private OTSRetryStrategy retryStrategy;
    private ScheduledExecutorService retryExecutor;
    private OTSCallable callable;
    protected int retries = 0;

    public OTSExecutionContext(Req request, OTSBasicFuture<Res> future, OTSTraceLogger traceLogger, OTSRetryStrategy retryStrategy, ScheduledExecutorService retryExecutor) {
        this.request = request;
        this.future = future;
        this.traceLogger = traceLogger;
        this.retryStrategy = retryStrategy;
        this.retryExecutor = retryExecutor;
    }

    public void setAsyncClientCallback(FutureCallback futureCallback) {
        this.asyncClientCallback = futureCallback;
    }

    public void setCallable(OTSCallable callable) {
        this.callable = callable;
    }

    public OTSCallable getCallable() {
        return this.callable;
    }

    public void retry(Exception ex) {
        ++this.retries;
    }

    public void setRequest(Req request) {
        this.request = request;
    }

    public Req getRequest() {
        return this.request;
    }

    public OTSBasicFuture<Res> getFuture() {
        return this.future;
    }

    public OTSTraceLogger getTraceLogger() {
        return this.traceLogger;
    }

    public FutureCallback<Res> getAsyncClientCallback() {
        return this.asyncClientCallback;
    }

    public OTSRetryStrategy getRetryStrategy() {
        return this.retryStrategy;
    }

    public ScheduledExecutorService getRetryExecutor() {
        return this.retryExecutor;
    }

    public int getRetries() {
        return this.retries;
    }
}

