/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.ons.api.impl.util;

import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.log.ClientLogger;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.logging.InternalLogger;
import java.util.Arrays;

public class ClientLoggerUtil {
    private static final String CLIENT_LOG_ROOT = "ons.client.logRoot";
    private static final String CLIENT_LOG_FILEMAXINDEX = "ons.client.logFileMaxIndex";
    private static final String CLIENT_LOG_LEVEL = "ons.client.logLevel";
    private static final String[] levelArray = new String[]{"ERROR", "WARN", "INFO", "DEBUG"};
    private static final long CLIENT_LOG_FILESIZE = 0x4000000L;

    public static InternalLogger getClientLogger() {
        String onsClientLogRoot = System.getProperty(CLIENT_LOG_ROOT, System.getProperty("user.home") + "/logs");
        System.setProperty("rocketmq.client.logRoot", onsClientLogRoot);
        String onsClientLogLevel = System.getProperty(CLIENT_LOG_LEVEL, "INFO").trim().toUpperCase();
        if (!Arrays.asList(levelArray).contains(onsClientLogLevel)) {
            onsClientLogLevel = "INFO";
        }
        System.setProperty("rocketmq.client.logLevel", onsClientLogLevel);
        String onsClientLogMaxIndex = System.getProperty(CLIENT_LOG_FILEMAXINDEX, "10").trim();
        try {
            int maxIndex = Integer.parseInt(onsClientLogMaxIndex);
            if (maxIndex <= 0 || maxIndex > 100) {
                throw new NumberFormatException();
            }
        }
        catch (NumberFormatException e) {
            onsClientLogMaxIndex = "10";
        }
        System.setProperty("rocketmq.client.logFileMaxIndex", onsClientLogMaxIndex);
        System.setProperty("rocketmq.client.logFileName", "ons.log");
        System.setProperty("rocketmq.client.logFileMaxSize", String.valueOf(0x4000000L));
        return ClientLogger.getLog();
    }
}

